/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.xqparser;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class XMLWriter {
    protected Stack _openElemStack = new Stack();
    protected PrintWriter _pw1;
    protected PrintWriter _pw2;
    protected String[][] NO_ATTRIBUTES = new String[0][];
    protected static int _MAXCHAR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setOutputs_NoEncodingException(PrintStream ps1, PrintStream ps2) {
        try {
            this.setOutputs(ps1, ps2);
        }
        catch (UnsupportedEncodingException e) {
            this._pw1 = ps1 == null ? null : new PrintWriter(ps1);
            this._pw2 = ps2 == null ? null : new PrintWriter(ps2);
        }
    }

    public void setOutputs(PrintStream ps1, PrintStream ps2) throws UnsupportedEncodingException {
        this._pw1 = this._ps_to_pw(ps1, "utf-8");
        this._pw2 = this._ps_to_pw(ps2, "utf-8");
    }

    protected PrintWriter _ps_to_pw(PrintStream ps, String charsetName) throws UnsupportedEncodingException {
        if (ps == null) {
            return null;
        }
        return new PrintWriter(new OutputStreamWriter((OutputStream)ps, charsetName));
    }

    public void putXMLDecl() {
        this.putText("<?xml version=\"1.0\"?>\n");
    }

    public void putComment(String s) {
        this._indent();
        this.putText("<!-- " + s + " -->\n");
    }

    public void putEmptyElement(Object check_obj, String xqx_element_name) {
        this._indent();
        this.putText("<" + xqx_element_name + "/>\n");
    }

    public void putSimpleElement(Object check_obj, String xqx_element_name, String content) {
        this.putStartTag(check_obj, xqx_element_name, false);
        this.putTextEscaped(content);
        this.putEndTag(check_obj, false);
    }

    public void putStartTag(Object check_obj, String xqx_element_name) {
        this.putStartTag(check_obj, xqx_element_name, this.NO_ATTRIBUTES, true);
    }

    public void putStartTag(Object check_obj, String xqx_element_name, boolean doLF) {
        this.putStartTag(check_obj, xqx_element_name, this.NO_ATTRIBUTES, doLF);
    }

    public void putStartTag(Object check_obj, String xqx_element_name, String[][] attributes, boolean doLF) {
        this._indent();
        this.putText("<" + xqx_element_name);
        for (int i = 0; i < attributes.length; ++i) {
            if (i > 0) {
                this.putText("\n           ");
            }
            String[] attribute = attributes[i];
            if (!$assertionsDisabled && attribute.length != 2) {
                throw new AssertionError();
            }
            String name = attribute[0];
            String value = attribute[1];
            this.putText(" " + name + "=\"" + value + "\"");
        }
        this.putText(">");
        if (doLF) {
            this.putText("\n");
        }
        this._openElemStack.push(xqx_element_name);
        this._openElemStack.push(check_obj);
    }

    public void putEndTag(Object check_obj) {
        this.putEndTag(check_obj, true);
    }

    public void putEndTag(Object check_obj, boolean doIndent) {
        if (this._openElemStack.empty()) {
            throw new RuntimeException("putEndTag() was called for " + check_obj.toString() + " but there's no matching call to putStartTag()");
        }
        Object earlier_check_obj = this._openElemStack.pop();
        if (check_obj != earlier_check_obj) {
            throw new RuntimeException("putEndTag() was called for " + check_obj.toString() + " but the matching putStartTag() was called for " + earlier_check_obj.toString());
        }
        String elemName = (String)this._openElemStack.pop();
        if (doIndent) {
            this._indent();
        }
        this.putText("</" + elemName + ">\n");
    }

    protected void _indent() {
        int indentAmount = this._openElemStack.size();
        for (int i = 0; i < indentAmount; ++i) {
            this.putText(" ");
        }
    }

    public int getDepthOfOpenElementStack() {
        return this._openElemStack.size() / 2;
    }

    public void putTextEscaped(String s) {
        this.putTextEscaped(s, false);
    }

    public void putTextEscaped(String s, boolean escapeAmp) {
        int strLen = s.length();
        for (int i = 0; i < strLen; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                if (!escapeAmp) {
                    this.putText(c);
                    continue;
                }
                this.putText("&amp;");
                continue;
            }
            if (c == '<') {
                this.putText("&lt;");
                continue;
            }
            if (c == '>') {
                this.putText("&gt;");
                continue;
            }
            if (XMLWriter._isUTF16Surrogate(c)) {
                char[] chars = s.toCharArray();
                int n = s.length();
                this._putDecimalCharRef(XMLWriter._getURF16SurrogateValue(c, chars, i++, n));
                continue;
            }
            if (c > '\u007f') {
                this._putDecimalCharRef(c);
                continue;
            }
            if (c == '\r') {
                if (i + 1 < s.length() && s.charAt(i + 1) == '\n') continue;
                this.putText("\n");
                continue;
            }
            if (c == '\r' || c == '\u0085' || c == '\u2028') {
                this._putDecimalCharRef(c);
                continue;
            }
            this.putText(c);
        }
    }

    protected void _putDecimalCharRef(int i) {
        this.putText("&#" + Integer.toString(i) + ";");
    }

    protected static final boolean _isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    protected static void _writeUTF16Surrogate(PrintWriter pw, char c, char[] ch, int i, int end) {
        int surrogateValue = XMLWriter._getURF16SurrogateValue(c, ch, i, end);
        pw.print('&');
        pw.print('#');
        pw.print(Integer.toString(surrogateValue));
        pw.print(';');
    }

    protected static int _getURF16SurrogateValue(char c, char[] ch, int i, int end) {
        int next;
        if (i + 1 >= end) {
            throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (next = ch[++i]) || next >= 57344) {
            throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        next = (c - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    protected static boolean _canConvert(char ch) {
        boolean isLegal;
        boolean bl = isLegal = ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
        if (!isLegal) {
            throw new RuntimeException("Characters MUST match the production for Char.");
        }
        return ch <= _MAXCHAR;
    }

    public void putText(String s) {
        if (this._pw1 != null) {
            this._pw1.print(s);
        }
        if (this._pw2 != null) {
            this._pw2.print(s);
        }
    }

    public void putText(char s) {
        if (this._pw1 != null) {
            this._pw1.print(s);
        }
        if (this._pw2 != null) {
            this._pw2.print(s);
        }
    }

    public void flush() {
        if (this._pw1 != null) {
            this._pw1.flush();
        }
        if (this._pw2 != null) {
            this._pw2.flush();
        }
    }

    static {
        $assertionsDisabled = !XMLWriter.class.desiredAssertionStatus();
        _MAXCHAR = 65535;
    }
}

