/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.xqparser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.xqparser.SimpleNode;
import org.w3c.xqparser.XParser;
import org.w3c.xqparser.XParserTreeConstants;

public class Xq2xml {
    private static int MAXCHAR = 65535;

    public static void convert(String prefix, PrintWriter outWriter, SimpleNode tree) {
        outWriter.println();
        outWriter.print(prefix + "<" + XParserTreeConstants.jjtNodeName[tree.id] + ">");
        if (tree.m_value != null) {
            outWriter.print("<data>");
            Xq2xml.printEscaped(outWriter, tree.m_value);
            outWriter.print("</data>");
        }
        if (tree.children != null) {
            for (int i = 0; i < tree.children.length; ++i) {
                SimpleNode n = (SimpleNode)tree.children[i];
                if (n == null) continue;
                Xq2xml.convert(prefix + " ", outWriter, n);
            }
            outWriter.println();
            outWriter.print(prefix);
        }
        outWriter.print("</" + XParserTreeConstants.jjtNodeName[tree.id] + ">");
    }

    public static String convert(String expr) throws UnsupportedEncodingException {
        StringReader ir = new StringReader(expr);
        StringWriter w = new StringWriter();
        Xq2xml.convert(ir, w);
        w.flush();
        String s = w.getBuffer().toString();
        return s;
    }

    public static String convert(File file) throws IOException, UnsupportedEncodingException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader ir = new InputStreamReader((InputStream)is, "utf-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(63488);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, "utf-8");
        Xq2xml.convert(ir, w);
        try {
            ((Writer)w).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s = new String(baos.toByteArray());
        return s;
    }

    public static void convert(Reader reader, Writer writer) {
        try {
            XParser parser = new XParser(reader);
            SimpleNode tree = parser.START();
            if (null == tree) {
                Xq2xml.printErrorString(writer, "no data");
            } else {
                PrintWriter ps = new PrintWriter(writer);
                Xq2xml.convert("", ps, tree);
            }
        }
        catch (Exception e) {
            Xq2xml.printErrorString(writer, e.getMessage());
        }
        catch (Error err) {
            Xq2xml.printErrorString(writer, err.getMessage());
        }
    }

    public static void convert(InputStream is, OutputStream os) throws UnsupportedEncodingException {
        InputStreamReader ir = new InputStreamReader(is, "utf-8");
        OutputStreamWriter ow = new OutputStreamWriter(os, "utf-8");
        Xq2xml.convert(ir, ow);
    }

    private static void writeUTF16Surrogate(PrintWriter ps, char c, char[] ch, int i, int end) {
        int surrogateValue = Xq2xml.getURF16SurrogateValue(c, ch, i, end);
        ps.print('&');
        ps.print('#');
        ps.print(Integer.toString(surrogateValue));
        ps.print(';');
    }

    private static int getURF16SurrogateValue(char c, char[] ch, int i, int end) {
        int next;
        if (i + 1 >= end) {
            throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (next = ch[++i]) || next >= 57344) {
            throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        next = (c - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    private static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    private static boolean canConvert(char ch) {
        boolean isLegal;
        boolean bl = isLegal = ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
        if (!isLegal) {
            throw new RuntimeException("Characters MUST match the production for Char.");
        }
        return ch <= MAXCHAR;
    }

    private static void printEscaped(PrintWriter ps, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                ps.print("&lt;");
                continue;
            }
            if (c == '>') {
                ps.print("&gt;");
                continue;
            }
            if (c == '&') {
                ps.print("&amp;");
                continue;
            }
            if (Xq2xml.isUTF16Surrogate(c)) {
                char[] chars = s.toCharArray();
                int n = s.length();
                Xq2xml.writeUTF16Surrogate(ps, c, chars, i, n - 1);
                continue;
            }
            if (!Xq2xml.canConvert(c)) {
                ps.print("&#");
                ps.print(Integer.toString(c));
                ps.print(";");
                continue;
            }
            ps.print(c);
        }
    }

    private static void printErrorString(PrintWriter ps, String msg) {
        ps.print("<error><data>");
        Xq2xml.printEscaped(ps, msg);
        ps.print("</data></error>");
    }

    private static void printErrorString(Writer w, String msg) {
        PrintWriter ps = new PrintWriter(w);
        Xq2xml.printErrorString(ps, msg);
        ps.flush();
    }

    private static String getErrorString(String msg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(63488);
        PrintWriter ps = new PrintWriter(baos);
        Xq2xml.printErrorString(ps, msg);
        ps.flush();
        String s = new String(baos.toByteArray());
        return s;
    }
}

