/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.xqparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.xqparser.ParseException;
import org.w3c.xqparser.PostParseException;
import org.w3c.xqparser.SimpleNode;
import org.w3c.xqparser.TokenMgrError;
import org.w3c.xqparser.XParser;
import org.w3c.xqparser.Xq2xml;
import org.xml.sax.SAXException;

public class Test {
    static final String language = "xpath1";
    static final int DUMP_NONE = 1;
    static final int DUMP_AST = 2;
    static final int DUMP_XQUERYX = 3;
    static final int DUMP_AST_XML = 4;
    int dumpFormat;
    String XQueryXOutputFilename = null;
    String XQueryXOutputHierarchyRoot = null;
    boolean validateXQueryX = false;
    int maxInvalidXQueryX = -1;
    private static final String UTF_16_BE = "UTF-16BE";
    private static final String UTF_16_LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseEncoding(String filePath) {
        if (filePath == null) return null;
        if (filePath.equals("")) {
            return null;
        }
        FileInputStream fileInstream = null;
        BufferedReader br = null;
        InputStreamReader reader = null;
        try {
            StringBuffer sub;
            fileInstream = new FileInputStream(filePath);
            int byteOne = fileInstream.read();
            int byteTwo = fileInstream.read();
            if (byteOne == 254 && byteTwo == 255) {
                String string = UTF_16_BE;
                return string;
            }
            if (byteOne == 255 && byteTwo == 254) {
                String string = UTF_16_LE;
                return string;
            }
            int byteThree = fileInstream.read();
            if (byteOne == 239 && byteTwo == 187 && byteThree == 191) {
                String ex = UTF_8;
                return ex;
            }
            reader = new FileReader(filePath);
            br = new BufferedReader(reader);
            String text = br.readLine();
            int index = text.indexOf("encoding") + 8;
            if (index > 7 && (sub = new StringBuffer(text.substring(index).trim())).charAt(0) == '=') {
                int qouteIndex;
                sub.deleteCharAt(0);
                String st = sub.toString().trim();
                if (st.charAt(0) == '\"' && (qouteIndex = st.indexOf(34, 1)) > -1) {
                    String string = st.substring(1, qouteIndex);
                    return string;
                }
            }
            String string = UTF_8;
            return string;
        }
        catch (FileNotFoundException fne) {
            String string = null;
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fileInstream != null) {
                    fileInstream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void main(String[] args) {
        Test test = new Test();
        test.process(args);
    }

    public void process(String[] args) {
        boolean haveXQueryXConverter = this.thisPackageHasAnXQueryXConverter();
        int argsStart = 0;
        this.dumpFormat = 1;
        while (argsStart < args.length) {
            try {
                String arg = args[argsStart];
                ++argsStart;
                if (arg.equals("-dumptree")) {
                    this.dumpFormat = 2;
                    continue;
                }
                if (arg.equals("-dumpxml")) {
                    this.dumpFormat = 4;
                    continue;
                }
                if (arg.equals("-xqueryx")) {
                    if (haveXQueryXConverter) {
                        this.dumpFormat = 3;
                        continue;
                    }
                    System.out.println("Ignoring arg '-xqueryx': this package does not have an XQueryX converter.");
                    continue;
                }
                if ("-xqueryxfile".equalsIgnoreCase(arg)) {
                    if (haveXQueryXConverter) {
                        this.XQueryXOutputFilename = args[argsStart];
                        this.XQueryXOutputHierarchyRoot = null;
                        this.dumpFormat = 3;
                    } else {
                        System.out.println("Ignoring arg '-xqueryxfile': this package does not have an XQueryX converter.");
                    }
                    ++argsStart;
                    continue;
                }
                if (arg.equalsIgnoreCase("-XQueryXOutputHierarchyRoot")) {
                    if (haveXQueryXConverter) {
                        this.XQueryXOutputHierarchyRoot = args[argsStart];
                        this.XQueryXOutputFilename = null;
                        this.dumpFormat = 3;
                    } else {
                        System.out.println("Ignoring arg '-XQueryXOutputHierarchyRoot': this package does not have an XQueryX converter.");
                    }
                    ++argsStart;
                    continue;
                }
                if (arg.equalsIgnoreCase("-validateXQueryX")) {
                    if (haveXQueryXConverter) {
                        this.validateXQueryX = true;
                        continue;
                    }
                    System.out.println("Ignoring arg '-validateXQueryX': this package does not have an XQueryX converter.");
                    continue;
                }
                if (arg.equalsIgnoreCase("-maxInvalidXQueryX")) {
                    if (haveXQueryXConverter) {
                        this.maxInvalidXQueryX = Integer.parseInt(args[argsStart]);
                    } else {
                        System.out.println("Ignoring arg '-maxInvalidXQueryX': this package does not have an XQueryX converter.");
                    }
                    ++argsStart;
                    continue;
                }
                if ("-file".equalsIgnoreCase(arg)) {
                    String filename = args[argsStart];
                    ++argsStart;
                    this.processFile(filename);
                    continue;
                }
                if (arg.endsWith(".xquery")) {
                    this.processFile(arg);
                    continue;
                }
                if ("-expr".equalsIgnoreCase(arg)) {
                    String expression = args[argsStart];
                    ++argsStart;
                    this.processString(expression);
                    continue;
                }
                if ("-catalog".equalsIgnoreCase(arg)) {
                    String catalogFileName = args[argsStart];
                    ++argsStart;
                    this.processW3CTestCatalog(catalogFileName);
                    continue;
                }
                this.processExprsInXmlFile(arg);
            }
            catch (TokenMgrError tme) {
                System.err.println("    " + tme.getMessage());
            }
            catch (ParseException pe) {
                System.err.println("    " + pe.getMessage());
            }
            catch (PostParseException ppe) {
                System.err.println("    " + ppe.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void processExprsInXmlFile(String filename) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(filename);
        Element tests = doc.getDocumentElement();
        NodeList testElems = tests.getChildNodes();
        int nChildren = testElems.getLength();
        int testid = 0;
        for (int i = 0; i < nChildren; ++i) {
            Node node = testElems.item(i);
            if (1 != node.getNodeType()) continue;
            ++testid;
            String xpathString = ((Element)node).getAttribute("value");
            if (this.dumpFormat != 1) {
                System.out.println("  Test[" + testid + "]: " + xpathString);
            } else {
                System.out.print("[" + testid + "]");
                System.out.flush();
                if (testid < 20) {
                    if (testid % 18 == 0) {
                        System.out.println();
                    }
                } else if (testid < 114) {
                    if (testid % 14 == 0) {
                        System.out.println();
                    }
                } else if (testid < 1000) {
                    if (testid % 12 == 0) {
                        System.out.println();
                    }
                } else if (testid % 10 == 0) {
                    System.out.println();
                }
            }
            try {
                this.dump(this.parseString(xpathString));
                continue;
            }
            catch (TokenMgrError e) {
                System.err.println(e.getMessage());
                continue;
            }
            catch (ParseException e) {
                System.out.println("parse error (" + this.getFirstLine(e.getMessage()) + ")");
            }
        }
        System.out.println();
        if (this.dumpFormat != 3) {
            System.out.println("End of file.");
        }
        System.out.flush();
    }

    String getFirstLine(String s) {
        String eol = System.getProperty("line.separator", "\n");
        int indexOfFirstEOL = s.indexOf(eol);
        return indexOfFirstEOL == -1 ? s : s.substring(0, indexOfFirstEOL);
    }

    private void processW3CTestCatalog(String catalogFileName) throws ParserConfigurationException, SAXException, IOException {
        System.out.println("Running catalog for: " + catalogFileName);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(catalogFileName);
        File catFile = new File(catalogFileName);
        String catDir = catFile.getParent();
        String xqFilePathCommonPrefix = catDir + File.separator + "Queries" + File.separator + "XQuery" + File.separator;
        SuiteFilesHandler sfh = new SuiteFilesHandler(xqFilePathCommonPrefix);
        try {
            Element testGroup;
            NodeIterator testGroups = this.getDescendantsNamed(doc, doc, "test-group");
            while ((testGroup = (Element)testGroups.nextNode()) != null) {
                String groupName = testGroup.getAttribute("name");
                sfh.groupStart(groupName);
                for (Node tgChild = testGroup.getFirstChild(); tgChild != null; tgChild = tgChild.getNextSibling()) {
                    Element query;
                    String isXPath2;
                    if (!tgChild.getNodeName().equals("test-case")) continue;
                    Element testCase = (Element)tgChild;
                    if (language.startsWith("xpath") && ((isXPath2 = testCase.getAttribute("is-XPath2")).equals("false") || isXPath2.equals(""))) continue;
                    String tcName = testCase.getAttribute("name");
                    String tcFilePath = testCase.getAttribute("FilePath").replace('/', File.separatorChar);
                    NodeIterator queries = this.getDescendantsNamed(doc, testCase, "query");
                    while ((query = (Element)queries.nextNode()) != null) {
                        boolean qExpectsParseError = false;
                        for (Node qSib = query.getNextSibling(); qSib != null; qSib = qSib.getNextSibling()) {
                            String errorCode;
                            boolean isRelevant;
                            if (qSib.getNodeType() != 1) continue;
                            String specVersion = ((Element)qSib).getAttribute("spec-version");
                            boolean bl = isRelevant = specVersion.equals("") || specVersion.equals("1.0") && (language.startsWith("xquery10") || language.startsWith("xpath")) || specVersion.equals("1.1") && language.startsWith("xquery30") || specVersion.equals("3.0") && language.startsWith("xquery30");
                            if (!isRelevant) continue;
                            String qSibName = qSib.getNodeName();
                            if (qSibName.equals("input-query")) {
                                String inputQueryName = ((Element)qSib).getAttribute("name");
                                sfh.handleFile(tcFilePath + inputQueryName + ".xq", false);
                                continue;
                            }
                            if (!qSibName.equals("expected-error") || !(errorCode = Test.getTextContent((Element)qSib)).equals("XPST0003") && !errorCode.equals("XQST0090") && (!errorCode.equals("*") || !language.startsWith("xpath") || !tcName.equals("K2-Literals-35") && !tcName.equals("K2-Literals-36") && !tcName.equals("K2-ErrorFunc-2")) && (!tcName.startsWith("eqname-") && !tcName.startsWith("switch-") || !language.startsWith("xquery10"))) continue;
                            qExpectsParseError = true;
                        }
                        String qName = query.getAttribute("name");
                        String xqRelPath = tcFilePath + qName + ".xq";
                        sfh.handleFile(xqRelPath, qExpectsParseError);
                        String qStaticName = query.getAttribute("static-name");
                        if (qStaticName.equals("")) continue;
                        sfh.handleFile(tcFilePath + qStaticName + ".xq", false);
                    }
                }
            }
        }
        catch (TooManyProblems tmp) {
            System.out.println("\n\nAborting processing of the catalog due to an unusually large number of problems:");
            System.out.println(tmp.getMessage());
        }
        sfh.report();
    }

    NodeIterator getDescendantsNamed(Document doc, Node base, final String localName) {
        return ((DocumentTraversal)((Object)doc)).createNodeIterator(base, 1, new NodeFilter(){

            public short acceptNode(Node node) {
                String nm = node.getLocalName();
                String namespace = node.getNamespaceURI();
                boolean nameMatches = nm.equals(localName) && namespace != null && namespace.startsWith("http://www.w3.org/2005/02/query-test-");
                return nameMatches ? (short)1 : 3;
            }
        }, true);
    }

    String leftPad(String s, int width, char padChar) {
        if (s.length() >= width) {
            return s;
        }
        return this.leftPad(padChar + s, width, padChar);
    }

    void processFile(String filename) throws FileNotFoundException, IOException, UnsupportedEncodingException, ParseException {
        if (this.dumpFormat != 3) {
            System.out.println("Running test for: " + filename);
        }
        this.dump(this.parseFile(filename, false));
        if (this.dumpFormat != 3) {
            System.out.println("Test successful!!!");
        }
    }

    void processString(String str) throws ParseException {
        if (this.dumpFormat != 3) {
            System.out.println("Running test for: " + str);
        }
        this.dump(this.parseString(str));
        if (this.dumpFormat != 3) {
            System.out.println("Test successful!!!");
        }
    }

    SimpleNode parseFile(String filename, boolean suppressCustomizationSection) throws FileNotFoundException, IOException, UnsupportedEncodingException, ParseException {
        Reader reader;
        File file = new File(filename);
        String encoding = Test.parseEncoding(file.getAbsolutePath());
        FileInputStream fis = new FileInputStream(file);
        if (encoding != null && (encoding.equals(UTF_16_BE) || encoding.equals(UTF_16_LE))) {
            fis.read();
            fis.read();
        }
        InputStreamReader inputStreamReader = reader = null == encoding ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encoding);
        if (suppressCustomizationSection) {
            String original = Test.readAll(reader);
            String tweaked = original.replaceFirst("(?s)\\(: *insert-start *:\\).*?\\(: *insert-end *:\\)", "");
            reader = new StringReader(tweaked);
        }
        XParser parser = new XParser(reader);
        SimpleNode tree = parser.START();
        return tree;
    }

    SimpleNode parseString(String str) throws ParseException {
        StringReader reader = new StringReader(str);
        XParser parser = new XParser(reader);
        SimpleNode tree = parser.START();
        return tree;
    }

    void dump(SimpleNode tree) {
        if (this.dumpFormat == 2) {
            tree.dump("|");
        }
        if (this.dumpFormat == 4) {
            try {
                PrintWriter systemOutWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, UTF_8));
                Xq2xml.convert(" ", systemOutWriter, tree);
                systemOutWriter.flush();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (this.dumpFormat == 3) {
            Vector errors = new Vector();
            this.convertXQueryToXQueryX(tree, System.out, this.XQueryXOutputFilename);
            if (this.XQueryXOutputFilename == null) {
                System.err.println("\n   Skipping validation, because the XQueryX translation isn't in a file.");
                return;
            }
            if (!this.validateXQueryX) {
                return;
            }
            boolean isValid = this.validateXMLFile(this.XQueryXOutputFilename, errors);
            if (!isValid) {
                System.err.println("\n   XQueryX Translation is invalid!");
                for (int i = 0; i < errors.size(); ++i) {
                    String msg = (String)errors.elementAt(i);
                    System.err.println(msg);
                }
            }
        }
    }

    private boolean thisPackageHasAnXQueryXConverter() {
        try {
            Class.forName("org.w3c.xqparser.ConversionController");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void convertXQueryToXQueryX(SimpleNode tree, PrintStream ps1, String xqueryxFilename) {
        try {
            PrintStream ps2 = xqueryxFilename != null ? new PrintStream(new FileOutputStream(xqueryxFilename)) : null;
            Class<?> transformerClass = Class.forName("org.w3c.xqparser.ConversionController");
            Object transformer = transformerClass.newInstance();
            Class[] argTypes = new Class[]{SimpleNode.class, PrintStream.class, PrintStream.class};
            Method transformMethod = transformerClass.getMethod("transform", argTypes);
            Object[] args = new Object[]{tree, ps1, ps2};
            transformMethod.invoke(transformer, args);
            if (ps2 != null) {
                ps2.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (PostParseException ppe) {
            throw ppe;
        }
        catch (ClassNotFoundException e) {
            System.err.println("XQueryX translator not yet supported!");
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PostParseException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private boolean validateXMLFile(String xmlFilename, Vector errors) {
        boolean isValidDoc = false;
        try {
            Class<?> validatorClass = Class.forName("org.w3c.xqparser.XMLValidator");
            Object validator = validatorClass.newInstance();
            Class[] argTypes = new Class[]{String.class, Vector.class};
            Method validateXMLFileMethod = validatorClass.getMethod("validateXMLFile", argTypes);
            Object[] args = new Object[]{xmlFilename, errors};
            Boolean isValid = (Boolean)validateXMLFileMethod.invoke(validator, args);
            isValidDoc = isValid;
        }
        catch (ClassNotFoundException e) {
            System.err.println("XML Validator class not found!");
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return isValidDoc;
    }

    static String getTextContent(Element e) {
        NodeList children = e.getChildNodes();
        if (!$assertionsDisabled && children.getLength() != 1) {
            throw new AssertionError();
        }
        Node child = children.item(0);
        if (!$assertionsDisabled && child.getNodeType() != 3) {
            throw new AssertionError();
        }
        return child.getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(Reader reader) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        reader = new BufferedReader(reader);
        char[] chars = new char[1024];
        try {
            int numRead;
            while ((numRead = reader.read(chars)) != -1) {
                sb.append(chars, 0, numRead);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    static {
        $assertionsDisabled = !Test.class.desiredAssertionStatus();
    }

    class TooManyProblems
    extends Exception {
        TooManyProblems(String msg) {
            super(msg);
        }
    }

    class FailureList {
        private String header;
        private Vector failures = new Vector();

        public FailureList(String header) {
            this.header = header;
        }

        public void add(String xqRelPath) {
            this.failures.addElement(xqRelPath);
        }

        public int size() {
            return this.failures.size();
        }

        public void show() {
            String indent = "    ";
            if (this.failures.size() > 0) {
                System.out.println(this.header + " (" + this.failures.size() + "):");
                for (int i = 0; i != this.failures.size(); ++i) {
                    String fname = (String)this.failures.elementAt(i);
                    System.out.println(indent + fname);
                }
                System.out.println();
            }
        }
    }

    class SuiteFilesHandler {
        private String xqFilePathCommonPrefix;
        private int nFilesTotal;
        private int nFilesInThisGroup;
        private FailureList failedToParse;
        private FailureList failedToRaiseError;
        private FailureList failedToConvertToXqx;
        private FailureList failedToValidateXqx;
        private FailureList failedOddlyInParse;
        private FailureList failedOddlyInConvert;

        public SuiteFilesHandler(String xqFilePathCommonPrefix) {
            this.xqFilePathCommonPrefix = xqFilePathCommonPrefix;
            this.nFilesTotal = 0;
            this.nFilesInThisGroup = 0;
            this.failedToParse = new FailureList("Should have parsed but raised an error");
            this.failedToRaiseError = new FailureList("Should have raised a parse error but didn't");
            this.failedToConvertToXqx = new FailureList("Conversion to XQueryX failed");
            this.failedToValidateXqx = new FailureList("XQueryX validation failed");
            this.failedOddlyInParse = new FailureList("Unanticipated exception occurred during parsing");
            this.failedOddlyInConvert = new FailureList("Unanticipated exception occurred during conversion to XQueryX");
            System.out.println("'i' means test parsed but XQueryX is invalid (test failed).");
            System.out.println("'x' means a parse error should have taken place (test failed).");
            System.out.println("'e' means a parse error took place but shouldn't have (test failed).");
            System.out.println("'v' means parse succeeded and XQueryX output was validated (test succeeds).");
            System.out.println("',' means parse error properly took place (test succeeds).");
        }

        public void groupStart(String groupName) {
            System.out.println();
            System.out.print(groupName + ":");
            this.nFilesInThisGroup = 0;
        }

        public void handleFile(String xqRelPath, boolean expectParseError) throws TooManyProblems {
            String xqFilePath = this.xqFilePathCommonPrefix + xqRelPath;
            if (Test.this.dumpFormat != 1 && Test.this.dumpFormat != 3) {
                System.out.print("== ");
                System.out.print(xqFilePath);
                System.out.println(" ==");
            }
            if (this.nFilesInThisGroup % 50 == 0) {
                System.out.println();
                System.out.print("  ");
                System.out.print(Test.this.leftPad(Integer.toString(this.nFilesInThisGroup), 4, ' ') + "+  ");
            }
            ++this.nFilesTotal;
            ++this.nFilesInThisGroup;
            SimpleNode tree = null;
            try {
                boolean suppressCustomizationSection = Test.language.startsWith("xpath");
                tree = Test.this.parseFile(xqFilePath, suppressCustomizationSection);
                if (expectParseError) {
                    this.failedToRaiseError.add(xqRelPath);
                    System.out.print("x");
                    System.out.flush();
                } else {
                    System.out.print(".");
                    System.out.flush();
                }
            }
            catch (Throwable t) {
                if (t instanceof TokenMgrError || t instanceof ParseException) {
                    if (expectParseError) {
                        System.out.print(",");
                        System.out.flush();
                    } else {
                        this.failedToParse.add(xqRelPath);
                        System.out.print("e");
                        System.out.flush();
                    }
                }
                this.failedOddlyInParse.add(xqRelPath);
                System.out.print("!");
            }
            if (Test.this.XQueryXOutputFilename == null && Test.this.XQueryXOutputHierarchyRoot == null) {
                return;
            }
            String xqueryxFilename = null;
            if (tree != null) {
                try {
                    if (Test.this.XQueryXOutputHierarchyRoot != null) {
                        xqueryxFilename = Test.this.XQueryXOutputHierarchyRoot + File.separatorChar + xqRelPath + "x";
                        new File(xqueryxFilename).getParentFile().mkdirs();
                    } else {
                        xqueryxFilename = Test.this.XQueryXOutputFilename;
                    }
                    Test.this.convertXQueryToXQueryX(tree, null, xqueryxFilename);
                }
                catch (PostParseException ppe) {
                    this.failedToConvertToXqx.add(xqRelPath);
                    xqueryxFilename = null;
                }
                catch (Throwable t) {
                    this.failedOddlyInConvert.add(xqRelPath);
                    xqueryxFilename = null;
                }
            }
            if (!Test.this.validateXQueryX) {
                return;
            }
            if (xqueryxFilename != null) {
                boolean isValid;
                try {
                    isValid = Test.this.validateXMLFile(xqueryxFilename, null);
                }
                catch (Throwable t) {
                    isValid = false;
                }
                System.out.print(isValid ? "v" : "i");
                System.out.flush();
                if (!isValid) {
                    this.failedToValidateXqx.add(xqRelPath);
                    if (Test.this.maxInvalidXQueryX >= 0 && this.failedToValidateXqx.size() > Test.this.maxInvalidXQueryX) {
                        throw new TooManyProblems("More than " + Test.this.maxInvalidXQueryX + " invalid XQueryX conversions");
                    }
                }
            }
        }

        public void report() {
            System.out.println();
            System.out.println("All filepaths shown below are relative to:");
            System.out.println("    " + this.xqFilePathCommonPrefix);
            System.out.println();
            this.failedOddlyInParse.show();
            this.failedToParse.show();
            this.failedToRaiseError.show();
            int nParseFailures = this.failedToParse.size() + this.failedToRaiseError.size();
            if (nParseFailures > 0) {
                System.out.print("Failed " + nParseFailures + " out of ");
            } else {
                System.out.print("Total Success!! ");
            }
            System.out.println(this.nFilesTotal + " cases");
            System.out.println();
            this.failedOddlyInConvert.show();
            this.failedToConvertToXqx.show();
            this.failedToValidateXqx.show();
        }
    }
}

