/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.xqparser;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import org.w3c.xqparser.Node;
import org.w3c.xqparser.PostParseException;
import org.w3c.xqparser.SimpleNode;
import org.w3c.xqparser.XParserTreeConstants;

public class XQueryXConverterBase
implements XParserTreeConstants {
    Stack _openElemStack = new Stack();
    Stack _openXMLElemStack = new Stack();
    Stack _outputStack = new Stack();
    Stack _stackChecks = new Stack();
    PrintWriter _xqout1;
    PrintWriter _xqout2;
    static final int BSP_STRIP = 0;
    static final int BSP_PRESERVE = 1;
    int _boundarySpacePolicy = 0;
    boolean _isAttribute = false;
    protected static int MAXCHAR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XQueryXConverterBase() throws UnsupportedEncodingException {
        try {
            this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            try {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            }
            catch (UnsupportedEncodingException e1) {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding")));
            }
        }
    }

    public XQueryXConverterBase(PrintWriter xqout) throws UnsupportedEncodingException {
        this._xqout1 = xqout;
    }

    public XQueryXConverterBase(PrintStream xqout) throws UnsupportedEncodingException {
        this._xqout1 = xqout != null ? new PrintWriter(new OutputStreamWriter((OutputStream)xqout, "utf-8")) : null;
    }

    public XQueryXConverterBase(PrintStream xqout, PrintStream xqout2) throws UnsupportedEncodingException {
        this._xqout1 = xqout != null ? new PrintWriter(new OutputStreamWriter((OutputStream)xqout, "utf-8")) : null;
        this._xqout2 = xqout2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)xqout2, "utf-8")) : null;
    }

    protected void xqprintln() {
        if (null != this._xqout1) {
            this._xqout1.println();
        }
        if (null != this._xqout2) {
            this._xqout2.println();
        }
    }

    protected void xqprintln(String s) {
        if (null != this._xqout1) {
            this._xqout1.println(s);
        }
        if (null != this._xqout2) {
            this._xqout2.println(s);
        }
    }

    protected void xqprint(String s) {
        if (null != this._xqout1) {
            this._xqout1.print(s);
        }
        if (null != this._xqout2) {
            this._xqout2.print(s);
        }
    }

    protected void xqprint(char s) {
        if (null != this._xqout1) {
            this._xqout1.print(s);
        }
        if (null != this._xqout2) {
            this._xqout2.print(s);
        }
    }

    protected static void writeUTF16Surrogate(PrintWriter ps, char c, char[] ch, int i, int end) {
        int surrogateValue = XQueryXConverterBase.getURF16SurrogateValue(c, ch, i, end);
        ps.print('&');
        ps.print('#');
        ps.print(Integer.toString(surrogateValue));
        ps.print(';');
    }

    protected static int getURF16SurrogateValue(char c, char[] ch, int i, int end) {
        int next;
        if (i + 1 >= end) {
            throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (next = ch[++i]) || next >= 57344) {
            throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        next = (c - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    protected static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    protected static boolean canConvert(char ch) {
        boolean isLegal;
        boolean bl = isLegal = ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
        if (!isLegal) {
            throw new RuntimeException("Characters MUST match the production for Char.");
        }
        return ch <= MAXCHAR;
    }

    protected void xqprintEscaped(String s, char enclosingChar) {
        this.xqprintEscaped(s, enclosingChar, false);
    }

    protected void xqprintEscaped(String s, char enclosingChar, boolean escapeAmp) {
        int strLen = s.length();
        for (int i = 0; i < strLen; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                if (!escapeAmp) {
                    this.xqprint(c);
                    continue;
                }
                this.xqprint("&amp;");
                continue;
            }
            if (c == '<') {
                this.xqprint("&lt;");
                continue;
            }
            if (c == '>') {
                this.xqprint("&gt;");
                continue;
            }
            if (c == '\'' && i + 1 < s.length() && s.charAt(i + 1) == '\'' && enclosingChar == '\'') {
                this.xqprint("'");
                ++i;
                continue;
            }
            if (c == '\"' && i + 1 < s.length() && s.charAt(i + 1) == '\"' && enclosingChar == '\"') {
                this.xqprint("\"");
                ++i;
                continue;
            }
            if (XQueryXConverterBase.isUTF16Surrogate(c)) {
                char[] chars = s.toCharArray();
                int n = s.length();
                this.xqprint("&#");
                this.xqprint(Integer.toString(XQueryXConverterBase.getURF16SurrogateValue(c, chars, i++, n)));
                this.xqprint(";");
                continue;
            }
            if (c > '\u007f') {
                this.xqprint("&#");
                this.xqprint(Integer.toString(c));
                this.xqprint(";");
                continue;
            }
            if (c == '\r') {
                if (i + 1 < s.length() && s.charAt(i + 1) == '\n') continue;
                this.xqprint("\n");
                continue;
            }
            if (this._isAttribute && (c == '\t' || c == '\n')) {
                if (null != this._xqout1) {
                    this._xqout1.print(' ');
                }
                if (null == this._xqout2) continue;
                this._xqout2.print(' ');
                continue;
            }
            if (c == '\r' || c == '\u0085' || c == '\u2028') {
                this.xqprint("&#");
                this.xqprint(Integer.toString(c));
                this.xqprint(";");
                continue;
            }
            if (null != this._xqout1) {
                this._xqout1.print(c);
            }
            if (null == this._xqout2) continue;
            this._xqout2.print(c);
        }
    }

    protected void indent() {
        int indentAmount = this._openElemStack.size();
        for (int i = 0; i < indentAmount; ++i) {
            this.xqprint(" ");
        }
    }

    protected void pd(String s, int i) {
        this.indent();
        for (int j = 0; j < i; ++j) {
            this.xqprint(" ");
        }
        this.xqprint("<!-- ");
        this.xqprint(s);
        this.xqprintln(" -->");
    }

    protected void pd(String s) {
        this.pd(s, 0);
    }

    protected void pushElem(int id, SimpleNode node) {
        this.indent();
        this._outputStack.push("<");
        String nodeName = jjtNodeName[id];
        String s = "xqx:" + nodeName.substring(0, 1).toLowerCase() + nodeName.substring(1);
        this._outputStack.push(s);
        this._openElemStack.push(s);
        this._openElemStack.push(node);
    }

    protected void pushElem(String s, SimpleNode node) {
        this.indent();
        this._outputStack.push("<");
        this._outputStack.push(s);
        this._openElemStack.push(s);
        this._openElemStack.push(node);
    }

    protected void pushAttr(String name, String val) {
        this._outputStack.push(" ");
        this._outputStack.push(name);
        this._outputStack.push("=\"");
        this._outputStack.push(val);
        this._outputStack.push("\"");
    }

    protected void flushOpen(SimpleNode node, boolean doLF) {
        if (this._outputStack.size() > 0) {
            if (node != this._openElemStack.peek()) {
                return;
            }
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String s = (String)this._outputStack.elementAt(i);
                this.xqprint(s);
            }
            this.xqprint(">");
            if (doLF) {
                this.xqprintln();
            }
            this._outputStack.removeAllElements();
        }
    }

    protected void flushOpen(SimpleNode node) {
        this.flushOpen(node, true);
    }

    protected void flushEmpty(SimpleNode node) {
        if (this._outputStack.size() > 0) {
            if (node != this._openElemStack.peek()) {
                return;
            }
            this._openElemStack.pop();
            this._openElemStack.pop();
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String s = (String)this._outputStack.elementAt(i);
                this.xqprint(s);
            }
            this.xqprintln("/>");
            this._outputStack.removeAllElements();
        }
    }

    protected void flushClose(SimpleNode node, boolean doIndent) {
        if (this._openElemStack.size() == 0) {
            return;
        }
        if (node != this._openElemStack.peek()) {
            return;
        }
        this._openElemStack.pop();
        String elemName = (String)this._openElemStack.pop();
        if (doIndent) {
            this.indent();
        }
        this.xqprint("</");
        this.xqprint(elemName);
        this.xqprintln(">");
    }

    protected void flushClose(SimpleNode node) {
        this.flushClose(node, true);
    }

    protected boolean isJustWhitespace(SimpleNode node) {
        if (node.id == 126 || node.id == 115) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                if (this.isJustWhitespace(child)) continue;
                return false;
            }
            return true;
        }
        if (node.id == 148) {
            return false;
        }
        if (node.id == 127 || node.id == 123 || node.id == 125) {
            return node.m_value.trim().length() == 0;
        }
        return false;
    }

    protected boolean isPreviousSiblingBoundaryWhitespaceChar(SimpleNode node) {
        if ((node = this.getPreviousSibling(this.sn(node.jjtGetParent()))) == null) {
            return true;
        }
        if (node.jjtGetNumChildren() > 0) {
            node = this.sn(node.jjtGetChild(0));
        }
        if (node.id == 148) {
            return false;
        }
        if (node.id == 127 || node.id == 123 || node.id == 125) {
            if (node.m_value.trim().length() == 0) {
                return this.isPreviousSiblingBoundaryWhitespaceChar(node);
            }
        } else {
            if (node.id == 128) {
                node = this.sn(node.jjtGetChild(0));
                if (node.id == 131 || node.id == 132 || node.id == 130 || node.id == 129) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isNextSiblingBoundaryWhitespaceChar(SimpleNode node) {
        if ((node = this.getNextSibling(this.sn(node.jjtGetParent()))) == null) {
            return true;
        }
        if (node.jjtGetNumChildren() > 0) {
            node = this.sn(node.jjtGetChild(0));
        }
        if (node.id == 148) {
            return false;
        }
        if (node.id == 127 || node.id == 123 || node.id == 125) {
            if (node.m_value.trim().length() == 0) {
                return this.isNextSiblingBoundaryWhitespaceChar(node);
            }
        } else {
            if (node.id == 128) {
                node = this.sn(node.jjtGetChild(0));
                if (node.id == 131 || node.id == 132 || node.id == 130 || node.id == 129) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isBoundaryWhitespaceChar(SimpleNode node) {
        if (node.id == 148) {
            return false;
        }
        return (node.id == 127 || node.id == 123 || node.id == 125) && node.m_value.trim().length() == 0 && this.isPreviousSiblingBoundaryWhitespaceChar(node) && this.isNextSiblingBoundaryWhitespaceChar(node);
    }

    protected boolean shouldStripChar(SimpleNode node) {
        return this._boundarySpacePolicy == 0 && this.isBoundaryWhitespaceChar(node);
    }

    protected boolean shouldVoidPathExpr(SimpleNode node) {
        if (this.getNumExprChildren(node) > 1) {
            return false;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            if (child.id == 83) {
                return false;
            }
            if (child.id != 81 && child.id != 82) continue;
            return false;
        }
        return true;
    }

    protected void markCheck() {
        this._stackChecks.push(new Integer(this._openElemStack.size()));
    }

    protected boolean check(SimpleNode node) {
        int currentSize;
        int markSize = (Integer)this._stackChecks.pop();
        if (markSize != (currentSize = this._openElemStack.size())) {
            System.err.println("Stack not flushed properly!!! " + jjtNodeName[node.id]);
        }
        return markSize == currentSize;
    }

    protected void xqflush() {
        if (null != this._xqout1) {
            this._xqout1.flush();
        }
        if (null != this._xqout2) {
            this._xqout2.flush();
        }
    }

    public boolean transform(SimpleNode node, PrintStream ps1) throws UnsupportedEncodingException {
        this._xqout1 = ps1 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps1, "utf-8")) : null;
        boolean ret = this.transform(node);
        this.xqflush();
        return ret;
    }

    public boolean transform(SimpleNode node, PrintStream ps1, PrintStream ps2) throws UnsupportedEncodingException {
        this._xqout1 = ps1 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps1, "utf-8")) : null;
        this._xqout2 = ps2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps2, "utf-8")) : null;
        boolean ret = this.transform(node);
        this.xqflush();
        return ret;
    }

    public boolean transformNoEncodingException(SimpleNode node, PrintStream ps1, PrintStream ps2) {
        try {
            this._xqout1 = ps1 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps1, "utf-8")) : null;
            this._xqout2 = ps2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps2, "utf-8")) : null;
        }
        catch (UnsupportedEncodingException e) {
            this._xqout1 = ps1 != null ? new PrintWriter(ps1) : null;
            this._xqout2 = ps2 != null ? new PrintWriter(ps2) : null;
        }
        boolean ret = this.transform(node);
        this.xqflush();
        return ret;
    }

    public boolean transform(SimpleNode node) {
        this.markCheck();
        int id = node.id;
        SimpleNode possiblyNewNode = this.transformNode(node, id);
        if (possiblyNewNode == null) {
            int n = node.jjtGetNumChildren();
            if (n == 0) {
                this.flushEmpty(node);
            } else {
                this.flushOpen(node);
                this.transformChildren(node);
                this.flushClose(node);
            }
            return this.check(node);
        }
        return this.check(possiblyNewNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleNode transformNode(SimpleNode node, int id) {
        switch (id) {
            case 0: {
                this.xqprintln("<?xml version=\"1.0\"?>");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.pushElem("xqx:module", node);
                this.pushAttr("xmlns:xqx", "http://www.w3.org/2005/XQueryX");
                this._outputStack.push("\n           ");
                this.pushAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this._outputStack.push("\n           ");
                this.pushAttr("xsi:schemaLocation", "http://www.w3.org/2005/XQueryX\n                                http://www.w3.org/2005/XQueryX/xqueryx.xsd");
                break;
            }
            case 3: {
                this.pushElem(id, node);
                this.flushOpen(node);
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                    if (i == 0) {
                        this.pushElem("xqx:version", child);
                        this.flushOpen(child, false);
                        this.xqprint(child.m_value.substring(1, child.m_value.length() - 1));
                        this.flushClose(child, false);
                        continue;
                    }
                    if (i != 1) continue;
                    this.pd("encoding: " + child.m_value);
                }
                this.flushClose(node);
                return node;
            }
            case 4: 
            case 95: 
            case 96: 
            case 97: {
                String elemName;
                boolean doValue = true;
                switch (id) {
                    case 95: {
                        elemName = "xqx:integerConstantExpr";
                        break;
                    }
                    case 96: {
                        elemName = "xqx:decimalConstantExpr";
                        break;
                    }
                    case 97: {
                        elemName = "xqx:doubleConstantExpr";
                        break;
                    }
                    case 4: {
                        if (this.getParentID(node) == 15) {
                            elemName = "xqx:optionContents";
                            doValue = false;
                            break;
                        }
                        elemName = "xqx:stringConstantExpr";
                        break;
                    }
                    default: {
                        elemName = "UNKNOWN!";
                    }
                }
                this.pushElem(elemName, node);
                this.flushOpen(node, doValue);
                if (doValue) {
                    this.pushElem("xqx:value", node);
                    this.flushOpen(node, false);
                }
                String val = node.m_value;
                if (id == 4) {
                    char enclosing = val.charAt(0);
                    val = val.substring(1, val.length() - 1);
                    this.xqprintEscaped(val, enclosing);
                } else {
                    this.xqprintEscaped(val, 'x');
                }
                if (doValue) {
                    this.flushClose(node, false);
                }
                this.flushClose(node, doValue);
                return node;
            }
            case 24: {
                break;
            }
            case 184: {
                if (this.getParentID(node) == 24) {
                    this.pushElem("xqx:baseUriDecl", node);
                } else if (this.getParentID(node) == 48) {
                    this.pushElem("xqx:collation", node);
                } else if (this.getParentID(node) == 23) {
                    this.pushElem("xqx:defaultCollationDecl", node);
                } else if (this.getParentID(node) == 27) {
                    SimpleNode firstChild = (SimpleNode)node.jjtGetParent().jjtGetChild(0);
                    if (firstChild == node || firstChild.id == 185 && (SimpleNode)node.jjtGetParent().jjtGetChild(1) == node) {
                        this.pushElem("xqx:targetNamespace", node);
                    } else {
                        this.pushElem("xqx:targetLocation", node);
                    }
                } else {
                    this.pushElem("xqx:uri", node);
                }
                this.flushOpen(node, false);
                SimpleNode child = this.sn(node.jjtGetChild(0));
                String val = child.m_value;
                char enclosing = val.charAt(0);
                val = val.substring(1, val.length() - 1);
                this.xqprintEscaped(val, enclosing);
                this.flushClose(node, false);
                return node;
            }
            case 8: {
                if (node.jjtGetNumChildren() <= 0) break;
                this.pushElem("xqx:prolog", node);
                break;
            }
            case 91: 
            case 92: {
                String qname = node.m_value;
                int i = qname.indexOf(58);
                if (i > 0) {
                    String prefix = qname.substring(0, i);
                    qname = qname.substring(i + 1);
                    if (prefix.equals("*")) {
                        this.pushElem("xqx:star", node);
                        this.flushEmpty(node);
                    } else {
                        this.pushElem("xqx:NCName", node);
                        this.flushOpen(node, false);
                        this.xqprint(prefix);
                        this.flushClose(node, false);
                    }
                }
                if (qname.equals("*")) {
                    this.pushElem("xqx:star", node);
                    this.flushEmpty(node);
                } else {
                    this.pushElem("xqx:NCName", node);
                    this.flushOpen(node, false);
                    this.xqprint(qname);
                    this.flushClose(node, false);
                }
                return node;
            }
            case 162: {
                boolean optionality = node.m_value != null;
                this.pushElem(id, node);
                this.flushOpen(node);
                this.transformChildren(node);
                if (optionality) {
                    this.pushElem("xqx:optional", node);
                    this.flushEmpty(node);
                }
                this.flushClose(node);
                return node;
            }
            case 74: 
            case 77: {
                break;
            }
            case 167: {
                break;
            }
            case 174: 
            case 178: {
                if (node.m_value == null || !node.m_value.equals("*")) break;
                this.pushElem(id == 174 ? 181 : 182, node);
                this.flushOpen(node);
                this.pushElem("xqx:star", node);
                this.flushEmpty(node);
                this.flushClose(node);
                return node;
            }
            case 181: 
            case 182: {
                this.pushElem(id, node);
                break;
            }
            case 185: 
            case 186: {
                int pid = this.getParentID(node);
                if (pid == 156 || pid == 158) {
                    this.pushElem("xqx:tagName", node);
                } else if (pid == 183) {
                    this.pushElem("xqx:typeName", node);
                } else if (pid == 161) {
                    this.pushElem("xqx:piTarget", node);
                } else if (pid == 167) {
                    this.pushElem(167, node);
                } else if (pid == 12) {
                    this.pushElem("xqx:prefix", node);
                } else if (pid == 28 || pid == 33) {
                    this.pushElem("xqx:varName", node);
                } else if (pid == 31) {
                    this.pushElem("xqx:functionName", node);
                } else if (pid == 15) {
                    this.pushElem("xqx:optionName", node);
                } else if (pid == 15) {
                    this.pushElem("xqx:optionName", node);
                } else if (pid == 27) {
                    this.pushElem("xqx:namespacePrefix", node);
                } else if (pid == 73) {
                    this.pushElem("xqx:pragmaName", node);
                } else {
                    this.pushElem("xqx:QName", node);
                }
                String qname = this.processPrefix(node.m_value);
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                return node;
            }
            case 112: {
                SimpleNode openTag = (SimpleNode)this._openXMLElemStack.peek();
                if (!openTag.getValue().equals(node.getValue())) {
                    throw new PostParseException("Error: In a direct element constructor, the name used in the end tag must exactly match the name used in the corresponding start tag, including its prefix or absence of a prefix.");
                }
                return node;
            }
            case 109: {
                if (this.getParentID(node) == 113 && this.isNamespaceDecl(node)) {
                    if (!node.m_value.equals("xmlns")) {
                        this.pushElem("xqx:prefix", node);
                        this.flushOpen(node, false);
                        int i = node.m_value.indexOf(58);
                        String prefix = node.m_value.substring(i + 1);
                        this.xqprint(prefix);
                        this.flushClose(node, false);
                    }
                    return node;
                }
                if (this.getParentID(node) == 113) {
                    if (node.getValue().startsWith("xmlns:")) {
                        this.pushElem("xqx:prefix", node);
                    } else if (!node.getValue().equals("xmlns")) {
                        this.pushElem("xqx:attributeName", node);
                    }
                } else {
                    this.pushElem("xqx:tagName", node);
                }
                String qname = null;
                qname = this.processPrefix(node.m_value);
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                return node;
            }
            case 187: {
                this.pushElem("xqx:functionName", node);
                String qname = this.processPrefix(node.m_value);
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                return node;
            }
            case 90: {
                this.pushElem("xqx:Wildcard", node);
                break;
            }
            case 89: {
                if (this.getChildID(node, 0) == 90) break;
            }
            case 98: {
                SimpleNode parent = (SimpleNode)node.jjtGetParent();
                int pid = parent.id;
                if (pid == 52 && this.getNextSibling(node) != null) {
                    this.pushElem("xqx:variableBinding", node);
                } else if (id == 98) {
                    this.pushElem("xqx:varRef", node);
                    this.flushOpen(node, true);
                    this.pushElem("xqx:name", node);
                } else {
                    this.pushElem(id, node);
                }
                String qname = ((SimpleNode)node.jjtGetChild((int)0)).m_value;
                if (null != qname) {
                    qname = this.processPrefix(qname);
                }
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                SimpleNode nextSibling = this.getNextSibling(node);
                if (null != nextSibling && nextSibling.id == 163) {
                    this.transform(nextSibling);
                }
                if (id == 98) {
                    this.flushClose(node, true);
                }
                return node;
            }
            case 42: {
                this.pushElem("xqx:positionalVariableBinding", node);
                String val = this.sn((Node)this.sn((Node)node.jjtGetChild((int)0)).jjtGetChild((int)0)).m_value;
                String qname = this.processPrefix(val);
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                return node;
            }
            case 166: {
                if (node.m_value == null || !node.m_value.equals("item")) break;
                this.pushElem("xqx:anyItemType", node);
                this.flushEmpty(node);
                return node;
            }
            case 164: {
                boolean shouldBeSeqType;
                int pid = this.getParentID(node);
                boolean bl = shouldBeSeqType = pid == 53;
                if (shouldBeSeqType) {
                    this.pushElem("xqx:sequenceType", node);
                    this.flushOpen(node);
                } else if (pid == 31) {
                    this.pushElem("xqx:typeDeclaration", node);
                    this.flushOpen(node);
                }
                if (node.m_value != null && node.m_value.equals("empty-sequence")) {
                    this.pushElem("xqx:voidSequenceType", node);
                    this.flushEmpty(node);
                } else {
                    this.transformChildren(node);
                }
                if (shouldBeSeqType || pid == 31) {
                    this.flushClose(node);
                }
                return node;
            }
            case 38: {
                if (this.getNumExprChildren(node) > 1) {
                    this.pushElem("xqx:sequenceExpr", node);
                    this.flushOpen(node);
                    this.transformChildren(node);
                    this.flushClose(node);
                } else {
                    this.transformChildren(node);
                }
                return node;
            }
            case 80: {
                if (this.shouldVoidPathExpr(node)) break;
                this.pushElem(id, node);
                this.flushOpen(node, true);
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    if (child.id == 81) {
                        this.pushElem("xqx:rootExpr", child);
                        this.flushEmpty(child);
                        this.flushClose(child);
                        continue;
                    }
                    if (child.id == 82) {
                        this.transform(child);
                        continue;
                    }
                    boolean isFilter = this.isFilterExpr(child);
                    if (isFilter) {
                        this.pushElem("xqx:stepExpr", node);
                        this.flushOpen(node, true);
                        this.pushElem("xqx:filterExpr", node);
                        this.flushOpen(node, true);
                        if (child.id == 99) {
                            this.pushElem("xqx:sequenceExpr", node);
                            this.flushOpen(node, true);
                        }
                    }
                    this.transform(child);
                    if (!isFilter) continue;
                    this.flushClose(node);
                    this.flushClose(node);
                    if (child.id != 99) continue;
                    this.flushClose(node);
                }
                this.flushClose(node);
                return node;
            }
            case 93: {
                this.pushElem("xqx:predicates", node);
                break;
            }
            case 103: {
                this.pushElem("xqx:functionCallExpr", node);
                this.flushOpen(node, true);
                SimpleNode funcNameExpr = (SimpleNode)node.jjtGetChild(0);
                this.transform(funcNameExpr);
                this.pushElem("xqx:arguments", node);
                this.flushOpen(node, true);
                int start = 1;
                this.transformChildren(node, start);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 83: {
                boolean isReducedPathExpr;
                SimpleNode parent = (SimpleNode)node.jjtGetParent();
                boolean bl = isReducedPathExpr = parent.id != 80;
                if (isReducedPathExpr) {
                    this.pushElem("xqx:pathExpr", node);
                    this.flushOpen(node, true);
                }
                this.pushElem(id, node);
                this.flushOpen(node, true);
                int start = 0;
                int childID = this.getChildID(node, start);
                boolean isFilter = this.isFilterExpr((SimpleNode)node.jjtGetChild(0));
                if (isFilter) {
                    this.pushElem("xqx:filterExpr", node);
                    this.flushOpen(node, true);
                    if (childID == 99) {
                        this.pushElem("xqx:sequenceExpr", node);
                        this.flushOpen(node, true);
                    }
                    SimpleNode predicateList = null;
                    for (int i = start; i < node.jjtGetNumChildren(); ++i) {
                        SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                        if (child.id == 93) {
                            predicateList = child;
                            continue;
                        }
                        this.transform(child);
                    }
                    this.flushClose(node, true);
                    if (childID == 99) {
                        this.flushClose(node, true);
                    }
                    if (null != predicateList) {
                        this.transform(predicateList);
                    }
                } else {
                    if (childID == 84 || childID == 86) {
                        this.pushElem("xqx:xpathAxis", node);
                        this.flushOpen(node, false);
                        String axisStr = this.sn((Node)node.jjtGetChild((int)0)).m_value;
                        this.xqprint(axisStr);
                        ++start;
                        this.flushClose(node, false);
                    } else if (childID == 87) {
                        this.pushElem("xqx:xpathAxis", node);
                        this.flushOpen(node, false);
                        this.xqprint("parent");
                        this.flushClose(node, false);
                        this.pushElem("xqx:anyKindTest", node);
                        this.flushEmpty(node);
                        ++start;
                    } else if (childID == 85) {
                        String optionalAttribIndicator = this.sn((Node)node.jjtGetChild((int)0)).m_value;
                        SimpleNode afs = this.sn(node.jjtGetChild(0));
                        SimpleNode possibleNodeTest = null;
                        SimpleNode possibleAttributeTest = null;
                        if (afs != null && (possibleNodeTest = this.sn(afs.jjtGetChild(0))) != null) {
                            possibleAttributeTest = this.sn(possibleNodeTest.jjtGetChild(0));
                        }
                        if (optionalAttribIndicator != null && optionalAttribIndicator.equals("@")) {
                            this.pushElem("xqx:xpathAxis", node);
                            this.flushOpen(node, false);
                            this.xqprint("attribute");
                            this.flushClose(node, false);
                        } else if (possibleNodeTest != null && possibleNodeTest.id == 88 && possibleAttributeTest != null && (possibleAttributeTest.id == 173 || possibleAttributeTest.id == 175)) {
                            this.pushElem("xqx:xpathAxis", node);
                            this.flushOpen(node, false);
                            this.xqprint("attribute");
                            this.flushClose(node, false);
                        } else {
                            this.pushElem("xqx:xpathAxis", node);
                            this.flushOpen(node, false);
                            this.xqprint("child");
                            this.flushClose(node, false);
                        }
                        this.transformChildren(this.sn(node.jjtGetChild(0)), start);
                        ++start;
                    } else if (!this.isFilterExpr((SimpleNode)node.jjtGetChild(0))) {
                        this.pushElem("xqx:xpathAxis", node);
                        this.flushOpen(node, false);
                        this.xqprint("child");
                        this.flushClose(node, false);
                    }
                    this.transformChildren(node, start);
                }
                this.flushClose(node);
                if (isReducedPathExpr) {
                    this.flushClose(node);
                }
                return node;
            }
            case 51: {
                this.pushElem(id, node);
                this.flushOpen(node);
                this.pushElem("xqx:quantifier", node);
                this.flushOpen(node, false);
                this.xqprint(node.m_value);
                this.flushClose(node, false);
                int n = node.jjtGetNumChildren();
                int i = 0;
                while (i < n - 1) {
                    SimpleNode typedVariableBinding = this.sn(node.jjtGetChild(i));
                    ++i;
                    this.pushElem("xqx:quantifiedExprInClause", node);
                    this.flushOpen(node);
                    this.pushElem("xqx:typedVariableBinding", node);
                    this.flushOpen(node, true);
                    this.pushElem(typedVariableBinding.id, typedVariableBinding);
                    String qname = ((SimpleNode)typedVariableBinding.jjtGetChild((int)0)).m_value;
                    if (null != qname) {
                        qname = this.processPrefix(qname);
                    }
                    this.flushOpen(typedVariableBinding, false);
                    this.xqprint(qname);
                    this.flushClose(typedVariableBinding, false);
                    SimpleNode nextChild = (SimpleNode)node.jjtGetChild(i);
                    ++i;
                    if (nextChild.id == 163) {
                        this.transform(nextChild);
                        nextChild = (SimpleNode)node.jjtGetChild(i);
                        ++i;
                    }
                    this.flushClose(node, true);
                    this.pushElem("xqx:sourceExpr", node);
                    this.flushOpen(node);
                    this.transform(nextChild);
                    this.flushClose(node);
                    this.flushClose(node);
                }
                this.pushElem("xqx:predicateExpr", node);
                this.flushOpen(node);
                this.transformChildren(node, n - 1, n - 1);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 54: {
                this.pushElem("xqx:ifThenElseExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:ifClause", node);
                this.flushOpen(node);
                this.transformChildren(node, 0, 0);
                this.flushClose(node);
                this.pushElem("xqx:thenClause", node);
                this.flushOpen(node);
                this.transformChildren(node, 1, 1);
                this.flushClose(node);
                this.pushElem("xqx:elseClause", node);
                this.flushOpen(node);
                this.transformChildren(node, 2, 2);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 40: {
                this.pushElem("xqx:flworExpr", node);
                this.flushOpen(node);
                int n = node.jjtGetNumChildren();
                this.transformChildren(node, 0, n - 2);
                this.pushElem("xqx:returnClause", node);
                this.flushOpen(node);
                this.transformChildren(node, n - 1, n - 1);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 58: {
                this.pushElem("xqx:rangeSequenceExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:startExpr", node);
                this.flushOpen(node);
                this.transform(this.sn(node.jjtGetChild(0)));
                this.flushClose(node);
                this.pushElem("xqx:endExpr", node);
                this.flushOpen(node);
                this.transform(this.sn(node.jjtGetChild(1)));
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 67: {
                int nUnarys = 0;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    if (child.id == 69) {
                        this.pushElem("xqx:unaryPlusOp", node);
                        this.flushOpen(node);
                        this.pushElem("xqx:operand", node);
                        this.flushOpen(node);
                        ++nUnarys;
                        continue;
                    }
                    if (child.id == 68) {
                        this.pushElem("xqx:unaryMinusOp", node);
                        this.flushOpen(node);
                        this.pushElem("xqx:operand", node);
                        this.flushOpen(node);
                        ++nUnarys;
                        continue;
                    }
                    this.transform(child);
                    for (int j = 0; j < nUnarys; ++j) {
                        this.flushClose(node);
                        this.flushClose(node);
                    }
                    break;
                }
                return node;
            }
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                switch (id) {
                    case 59: {
                        String op = node.m_value;
                        String elemName = op.equals("+") ? "xqx:addOp" : (op.equals("-") ? "xqx:subtractOp" : "JJTADDITIVEEXPR UNKNOWN EXPR!");
                        this.pushElem(elemName, node);
                        break;
                    }
                    case 60: {
                        String op = node.m_value;
                        String elemName = op.equals("*") ? "xqx:multiplyOp" : (op.equals("div") ? "xqx:divOp" : (op.equals("idiv") ? "xqx:idivOp" : (op.equals("mod") ? "xqx:modOp" : "JJTMULTIPLICATIVEEXPR UNKNOWN EXPR: " + op)));
                        this.pushElem(elemName, node);
                        break;
                    }
                    case 61: {
                        this.pushElem("xqx:unionOp", node);
                        break;
                    }
                    case 62: {
                        String op = node.m_value;
                        String elemName = op.equals("intersect") ? "xqx:intersectOp" : (op.equals("except") ? "xqx:exceptOp" : "JJTINTERSECTEXCEPTEXPR UNKNOWN EXPR: " + op);
                        this.pushElem(elemName, node);
                        break;
                    }
                    case 56: {
                        this.pushElem("xqx:andOp", node);
                        break;
                    }
                    case 55: {
                        this.pushElem("xqx:orOp", node);
                        break;
                    }
                    case 57: {
                        String op = node.m_value;
                        String elemName = op.equals("eq") ? "xqx:eqOp" : (op.equals("ne") ? "xqx:neOp" : (op.equals("lt") ? "xqx:ltOp" : (op.equals("le") ? "xqx:leOp" : (op.equals("gt") ? "xqx:gtOp" : (op.equals("ge") ? "xqx:geOp" : (op.equals("=") ? "xqx:equalOp" : (op.equals("!=") ? "xqx:notEqualOp" : (op.equals("<") ? "xqx:lessThanOp" : (op.equals("<=") ? "xqx:lessThanOrEqualOp" : (op.equals(">") ? "xqx:greaterThanOp" : (op.equals(">=") ? "xqx:greaterThanOrEqualOp" : (op.equals("is") ? "xqx:isOp" : (op.equals("<<") ? "xqx:nodeBeforeOp" : (op.equals(">>") ? "xqx:nodeAfterOp" : "JJTCOMPARISONEXPR UNKNOWN: " + op))))))))))))));
                        this.pushElem(elemName, node);
                        break;
                    }
                    default: {
                        this.pushElem("???", node);
                    }
                }
                this.flushOpen(node);
                this.pushElem("xqx:firstOperand", node);
                this.flushOpen(node);
                this.transform(this.sn(node.jjtGetChild(0)));
                this.flushClose(node);
                this.pushElem("xqx:secondOperand", node);
                this.flushOpen(node);
                this.transform(this.sn(node.jjtGetChild(1)));
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 81: {
                this.pushElem("xqx:sequenceExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:pathExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:rootExpr", node);
                this.flushEmpty(node);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 82: {
                if (this.sn(node.jjtGetParent()).jjtGetChild(0) == node) {
                    this.pushElem("xqx:rootExpr", node);
                    this.flushEmpty(node);
                    this.pushElem("xqx:stepExpr", node);
                    this.flushOpen(node);
                    this.pushElem("xqx:xpathAxis", node);
                    this.flushOpen(node, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(node, false);
                    this.pushElem("xqx:anyKindTest", node);
                    this.flushEmpty(node);
                    this.flushClose(node);
                    this.flushClose(node);
                } else {
                    this.pushElem("xqx:stepExpr", node);
                    this.flushOpen(node);
                    this.pushElem("xqx:xpathAxis", node);
                    this.flushOpen(node, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(node, false);
                    this.pushElem("xqx:anyKindTest", node);
                    this.flushEmpty(node);
                    this.flushClose(node);
                }
                return node;
            }
            case 41: 
            case 43: {
                boolean is_for = id == 41;
                this.pushElem(id, node);
                this.flushOpen(node);
                int n = node.jjtGetNumChildren();
                int i = 0;
                while (i < n) {
                    i = this.transform_ClauseItem(node, is_for, i);
                }
                this.flushClose(node);
                return node;
            }
            case 45: {
                this.pushElem(id, node);
                this.flushOpen(node, true);
                if (node.m_value != null && node.m_value.equals("stable")) {
                    this.pushElem("xqx:stable", node);
                    this.flushEmpty(node);
                }
                int n = node.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    this.transform(child);
                }
                this.flushClose(node);
                return node;
            }
            case 46: {
                int n = node.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    this.pushElem("xqx:orderBySpec", node);
                    this.flushOpen(node);
                    this.transform(child);
                    if (child.id == 47) {
                        int n2 = child.jjtGetNumChildren();
                        for (int j = 0; j < n2; ++j) {
                            SimpleNode child2 = this.sn(child.jjtGetChild(j));
                            if (child2.id != 48 || child2.jjtGetNumChildren() <= 0) continue;
                            this.transform(child2);
                        }
                    }
                    this.flushClose(node);
                }
                return node;
            }
            case 47: {
                this.pushElem("xqx:orderByExpr", node);
                this.flushOpen(node);
                int n = node.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    if (child.id == 48) continue;
                    this.transform(child);
                }
                this.flushClose(node);
                return node;
            }
            case 48: {
                if (node.jjtGetNumChildren() == 0) {
                    return node;
                }
                this.pushElem(id, node);
                break;
            }
            case 172: {
                this.pushElem("xqx:piTest", node);
                if (node.jjtGetNumChildren() > 0) {
                    this.flushOpen(node);
                    SimpleNode child = this.sn(node.jjtGetChild(0));
                    this.markCheck();
                    this.pushElem("xqx:piTarget", child);
                    this.flushOpen(child, false);
                    String ncName = child.m_value;
                    if (child.id == 4) {
                        ncName = ncName.substring(1, ncName.length() - 1);
                    }
                    this.xqprint(ncName);
                    this.flushClose(child, false);
                    this.check(child);
                    this.flushClose(node);
                } else {
                    this.flushEmpty(node);
                }
                return node;
            }
            case 25: {
                SimpleNode targetNamespace;
                this.pushElem("xqx:schemaImport", node);
                this.flushOpen(node);
                SimpleNode child = this.sn(node.jjtGetChild(0));
                int start = 0;
                if (child.id == 26 && child.jjtGetNumChildren() > 0) {
                    this.pushElem("xqx:namespacePrefix", node);
                    this.flushOpen(node, false);
                    this.xqprint(this.sn((Node)child.jjtGetChild((int)0)).m_value);
                    ++start;
                    this.flushClose(node, false);
                    targetNamespace = this.sn(node.jjtGetChild(1));
                    ++start;
                } else if (child.id == 26) {
                    this.pushElem("xqx:defaultElementNamespace", node);
                    this.flushEmpty(node);
                    ++start;
                    targetNamespace = this.sn(node.jjtGetChild(1));
                    ++start;
                } else {
                    targetNamespace = child;
                    ++start;
                }
                this.pushElem("xqx:targetNamespace", targetNamespace);
                this.flushOpen(targetNamespace, false);
                String val = this.sn((Node)targetNamespace.jjtGetChild((int)0)).m_value;
                val = val.substring(1, val.length() - 1);
                this.xqprint(val);
                this.flushClose(targetNamespace, false);
                for (int i = start; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode tl = this.sn(node.jjtGetChild(i));
                    this.pushElem("xqx:targetLocation", tl);
                    this.flushOpen(tl, false);
                    val = this.sn((Node)targetNamespace.jjtGetChild((int)0)).m_value;
                    val = val.substring(1, val.length() - 1);
                    this.xqprint(val);
                    this.flushClose(tl, false);
                }
                this.flushClose(node);
                return node;
            }
            case 49: 
            case 50: {
                this.pushElem("xqx:orderingKind", node);
                this.flushOpen(node, false);
                if (id == 49) {
                    this.xqprint("ascending");
                } else {
                    this.xqprint("descending");
                }
                this.flushClose(node, false);
                return node;
            }
            case 18: 
            case 19: {
                if (this.getParentID(node) == 17) {
                    this.pushElem("xqx:emptyOrderingDecl", node);
                } else {
                    this.pushElem("xqx:emptyOrderingMode", node);
                }
                this.flushOpen(node, false);
                if (id == 18) {
                    this.xqprint("empty greatest");
                } else {
                    this.xqprint("empty least");
                }
                this.flushClose(node, false);
                return node;
            }
            case 99: {
                if (node.jjtGetNumChildren() != 0) break;
                this.pushElem("xqx:sequenceExpr", node);
                break;
            }
            case 14: {
                this.pushElem(id, node);
                this.flushOpen(node);
                this.pushElem("xqx:defaultNamespaceCategory", node);
                this.flushOpen(node, false);
                this.xqprint(node.m_value);
                this.flushClose(node, false);
                this.transformChildren(node);
                this.flushClose(node);
                return node;
            }
            case 13: {
                this._boundarySpacePolicy = node.m_value.equals("preserve") ? 1 : 0;
                return node;
            }
            case 16: 
            case 21: 
            case 22: 
            case 30: 
            case 165: {
                this.pushElem(id, node);
                this.flushOpen(node, false);
                this.xqprint(node.m_value);
                this.flushClose(node, false);
                return node;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                if (id == 63) {
                    this.pushElem("xqx:instanceOfExpr", node);
                } else {
                    this.pushElem(id, node);
                }
                this.flushOpen(node);
                this.pushElem("xqx:argExpr", node);
                this.flushOpen(node);
                this.transformChildren(node, 0, 0);
                this.flushClose(node);
                if (id != 66 && id != 65) {
                    this.pushElem("xqx:sequenceType", node);
                    this.flushOpen(node);
                    this.transformChildren(node, 1, 1);
                    this.flushClose(node);
                } else {
                    this.transformChildren(node, 1, 1);
                }
                this.flushClose(node);
                return node;
            }
            case 101: 
            case 102: {
                this.pushElem(id, node);
                this.flushOpen(node);
                this.pushElem("xqx:argExpr", node);
                this.flushOpen(node);
                this.transformChildren(node);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 52: {
                this.pushElem(id, node);
                this.flushOpen(node);
                this.pushElem("xqx:argExpr", node);
                this.flushOpen(node);
                this.transformChildren(node, 0, 0);
                this.flushClose(node);
                int n = node.jjtGetNumChildren();
                int startOfDefault = n - 2;
                this.transformChildren(node, 1, startOfDefault - 1);
                if (this.getChildID(node, startOfDefault) != 98) {
                    this.transformChildren(node, startOfDefault, startOfDefault);
                    ++startOfDefault;
                }
                this.pushElem("xqx:typeswitchExprDefaultClause", node);
                this.flushOpen(node);
                if (startOfDefault == n - 2) {
                    this.transformChildren(node, startOfDefault, startOfDefault);
                    ++startOfDefault;
                }
                this.pushElem("xqx:resultExpr", node);
                this.flushOpen(node);
                this.transformChildren(node, startOfDefault, startOfDefault);
                this.flushClose(node);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 53: {
                this.pushElem("xqx:typeswitchExprCaseClause", node);
                this.flushOpen(node);
                int nChildren = node.jjtGetNumChildren();
                int currentChild = 0;
                if (nChildren == 3) {
                    ++currentChild;
                    this.pushElem("xqx:variableBinding", node);
                    String qname = this.getFirstChildOfFirstChild((SimpleNode)node).m_value;
                    if (null != qname) {
                        qname = this.processPrefix(qname);
                    }
                    this.flushOpen(node, false);
                    this.xqprint(qname);
                    this.flushClose(node, false);
                }
                this.transformChildren(node, currentChild, currentChild);
                this.pushElem("xqx:resultExpr", node);
                this.flushOpen(node);
                this.transformChildren(node, ++currentChild);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 31: {
                this.pushElem(id, node);
                this.flushOpen(node);
                int start = 0;
                this.transformChildren(node, start, start);
                if (this.getChildID(node, ++start) == 32) {
                    this.transformChildren(node, start, start);
                    ++start;
                } else {
                    this.pushElem("xqx:paramList", node);
                    this.flushEmpty(node);
                }
                int end = node.jjtGetNumChildren() - 1;
                this.transformChildren(node, start, end - 1);
                start = end;
                if (this.getChildID(node, end) == 29) {
                    this.pushElem("xqx:externalDefinition", node);
                    this.flushEmpty(node);
                } else {
                    this.pushElem("xqx:functionBody", node);
                    this.flushOpen(node);
                    this.transformChildren(node, start, end);
                    this.flushClose(node);
                }
                this.flushClose(node);
                return node;
            }
            case 28: {
                this.pushElem(id, node);
                this.flushOpen(node);
                int start = 0;
                int end = node.jjtGetNumChildren() - 1;
                this.transformChildren(node, start, end - 1);
                start = end;
                if (this.getChildID(node, end) == 29) {
                    this.transformChildren(node, start, end);
                } else {
                    this.pushElem("xqx:varValue", node);
                    this.flushOpen(node);
                    this.transformChildren(node, start, end);
                    this.flushClose(node);
                }
                this.flushClose(node);
                return node;
            }
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 20: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 33: 
            case 37: 
            case 39: 
            case 44: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 163: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 173: 
            case 176: 
            case 177: 
            case 180: {
                this.pushElem(id, node);
                break;
            }
            case 175: {
                SimpleNode qn = this.sn(this.sn(this.sn(node.jjtGetChild(0)).jjtGetChild(0)).jjtGetChild(0));
                this.pushElem("xqx:schemaAttributeTest", node);
                String qname = this.processPrefix(qn.m_value);
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                return node;
            }
            case 179: {
                SimpleNode qn = this.sn(this.sn(this.sn(node.jjtGetChild(0)).jjtGetChild(0)).jjtGetChild(0));
                this.pushElem("xqx:schemaElementTest", node);
                String qname = this.processPrefix(qn.m_value);
                this.flushOpen(node, false);
                this.xqprint(qname);
                this.flushClose(node, false);
                return node;
            }
            case 7: {
                this.pushElem(id, node);
                this.flushOpen(node, true);
                SimpleNode ncname = this.sn(node.jjtGetChild(0));
                this.pushElem("xqx:prefix", ncname);
                this.flushOpen(ncname, false);
                this.xqprint(ncname.m_value);
                this.flushClose(ncname, false);
                this.transformChildren(node, 1, 1);
                this.flushClose(node);
                return node;
            }
            case 73: {
                this.pushElem(id, node);
                this.flushOpen(node, true);
                int n = node.jjtGetNumChildren();
                boolean foundPragmaContents = false;
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    this.transform(child);
                    if (child.id != 78) continue;
                    foundPragmaContents = true;
                }
                if (!foundPragmaContents) {
                    this.pushElem("xqx:pragmaContents", node);
                    this.flushEmpty(node);
                }
                this.flushClose(node);
                return node;
            }
            case 78: {
                this.pushElem("xqx:pragmaContents", node);
                this.flushOpen(node, false);
                this.transformChildren(node);
                this.flushClose(node, false);
                return node;
            }
            case 79: {
                this.xqprint(node.m_value);
                break;
            }
            case 72: {
                this.pushElem(id, node);
                this.flushOpen(node, true);
                int n = node.jjtGetNumChildren();
                boolean foundArg = false;
                SimpleNode argNode = null;
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    if (!foundArg && i == n - 2) {
                        foundArg = true;
                        argNode = child;
                        if (argNode.jjtGetNumChildren() == 0) continue;
                        this.pushElem("xqx:argExpr", argNode);
                        this.flushOpen(argNode, true);
                    }
                    this.transform(child);
                    if (argNode == null || i != n - 2) continue;
                    this.flushClose(argNode, true);
                }
                this.flushClose(node, true);
                return node;
            }
            case 100: {
                this.pushElem(id, node);
                break;
            }
            case 70: {
                this.pushElem(id, node);
                this.flushOpen(node, true);
                int n = node.jjtGetNumChildren();
                boolean foundArg = false;
                SimpleNode argNode = null;
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    if (!foundArg && child.id != 71) {
                        foundArg = true;
                        argNode = child;
                        this.pushElem("xqx:argExpr", argNode);
                        this.flushOpen(argNode, true);
                    }
                    this.transform(child);
                }
                this.flushClose(argNode, true);
                this.flushClose(node, true);
                return node;
            }
            case 71: {
                this.pushElem(id, node);
                this.flushOpen(node, false);
                this.xqprint(node.m_value);
                this.flushClose(node, false);
                return node;
            }
            case 10: 
            case 11: 
            case 17: 
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 68: 
            case 69: 
            case 75: 
            case 88: 
            case 94: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 128: 
            case 144: 
            case 183: {
                break;
            }
            case 9: {
                this.checkDuplicateSetters(node);
                break;
            }
            case 76: {
                this.xqprint(node.m_value);
                break;
            }
            case 129: {
                this.xqprint(node.m_value);
                break;
            }
            case 130: {
                String ref = node.m_value;
                this.xqprint(ref);
                break;
            }
            case 131: {
                this.xqprint("{");
                break;
            }
            case 132: {
                this.xqprint("}");
                break;
            }
            case 133: {
                this.pushElem("xqx:computedCommentConstructor", node);
                break;
            }
            case 137: {
                this.pushElem("xqx:argExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:stringConstantExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:value", node);
                this.flushOpen(node, false);
                this.transformChildren(node);
                this.flushClose(node, false);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 139: {
                this.xqprintEscaped(node.m_value, 'x', true);
                break;
            }
            case 138: 
            case 147: 
            case 153: {
                String charStr = node.m_value;
                if (!charStr.equals("\r")) {
                    if (node.id == 153) {
                        this.xqprint(charStr);
                    } else {
                        this.xqprintEscaped(charStr, 'x', true);
                    }
                } else {
                    SimpleNode sib = this.getNextSibling(node);
                    if (sib == null || sib.id != node.id || !sib.m_value.equals("\n")) {
                        this.xqprint("\n");
                    }
                }
                return node;
            }
            case 134: 
            case 135: 
            case 136: 
            case 141: 
            case 142: 
            case 145: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                break;
            }
            case 148: {
                this.pushElem("xqx:computedTextConstructor", node);
                this.flushOpen(node);
                this.pushElem("xqx:argExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:stringConstantExpr", node);
                this.flushOpen(node);
                this.pushElem("xqx:value", node);
                this.flushOpen(node, false);
                this.xqprint("<![CDATA[");
                this.transformChildren(node);
                this.xqprint("]]>");
                this.flushClose(node, false);
                this.flushClose(node);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 146: {
                break;
            }
            case 140: {
                this.pushElem("xqx:computedPIConstructor", node);
                this.flushOpen(node);
                this.pushElem("xqx:piTarget", node);
                this.flushOpen(node, false);
                this.xqprint(this.sn((Node)node.jjtGetChild((int)1)).m_value);
                this.flushClose(node, false);
                if (this.hasChildID(node, 146)) {
                    this.pushElem("xqx:piValueExpr", node);
                    this.flushOpen(node);
                    this.pushElem("xqx:stringConstantExpr", node);
                    this.flushOpen(node);
                    this.pushElem("xqx:value", node);
                    this.flushOpen(node, false);
                    this.transformChildren(node, 2);
                    this.flushClose(node, false);
                    this.flushClose(node);
                    this.flushClose(node);
                }
                this.flushClose(node);
                return node;
            }
            case 155: 
            case 159: 
            case 160: {
                String elemName;
                switch (id) {
                    case 155: {
                        elemName = "xqx:computedDocumentConstructor";
                        break;
                    }
                    case 159: {
                        elemName = "xqx:computedTextConstructor";
                        break;
                    }
                    case 160: {
                        elemName = "xqx:computedCommentConstructor";
                        break;
                    }
                    default: {
                        elemName = "UNKNOWN-" + jjtNodeName[id];
                    }
                }
                this.pushElem(elemName, node);
                this.flushOpen(node);
                this.pushElem("xqx:argExpr", node);
                this.flushOpen(node);
                this.transformChildren(node);
                this.flushClose(node);
                this.flushClose(node);
                return node;
            }
            case 154: {
                break;
            }
            case 156: 
            case 158: 
            case 161: {
                this.pushElem(id == 158 ? "xqx:computedAttributeConstructor" : (id == 161 ? "xqx:computedPIConstructor" : "xqx:computedElementConstructor"), node);
                this.flushOpen(node);
                int start = 0;
                if (this.getChildID(node, 0) == 35) {
                    if (id == 161) {
                        this.pushElem("xqx:piTargetExpr", node);
                    } else {
                        this.pushElem("xqx:tagNameExpr", node);
                    }
                    this.flushOpen(node);
                    this.transformChildren(node, 1, 1);
                    this.flushClose(node);
                    start += 3;
                } else {
                    this.transformChildren(node, 0, 0);
                    ++start;
                }
                if (id == 158 || id == 161) {
                    this.pushElem(id == 158 ? "xqx:valueExpr" : "xqx:piValueExpr", node);
                    this.flushOpen(node);
                    if (this.getNumExprChildren(node, start) == 0) {
                        this.pushElem("xqx:sequenceExpr", node);
                        this.flushEmpty(node);
                    } else {
                        this.transformChildren(node, start);
                    }
                    this.flushClose(node);
                } else {
                    this.transformChildren(node, start);
                }
                this.flushClose(node);
                return node;
            }
            case 157: {
                this.pushElem(id, node);
                break;
            }
            case 113: {
                if (this.getNumRealChildren(node) > 0) {
                    this.pushElem("xqx:attributeList", node);
                    this.flushOpen(node);
                    int n = node.jjtGetNumChildren();
                    for (int i = 0; i < n; ++i) {
                        SimpleNode child = this.sn(node.jjtGetChild(i));
                        if (child.id == 109) {
                            if (this.isNamespaceDecl(child)) {
                                this.pushElem("xqx:namespaceDeclaration", node);
                            } else {
                                this.pushElem("xqx:attributeConstructor", node);
                            }
                            this.flushOpen(node);
                        }
                        this.transform(child);
                        if (child.id != 115) continue;
                        this.flushClose(node);
                    }
                    this.flushClose(node);
                }
                return node;
            }
            case 126: {
                if (this.getChildID(node, 0) != 127) break;
                String charStr = this.sn((Node)node.jjtGetChild((int)0)).m_value;
                if (!charStr.equals("\r")) {
                    this.xqprintEscaped(charStr, 'x');
                } else {
                    SimpleNode sib = this.getNextSibling(node);
                    SimpleNode sibChild = null;
                    if (sib != null) {
                        sibChild = this.sn(sib.jjtGetChild(0));
                    }
                    if (sib == null || sib.id != 126 || sibChild == null || sibChild.id != 127 || !sibChild.m_value.equals("\n")) {
                        this.xqprint("\n");
                    }
                }
                return node;
            }
            case 106: {
                this.pushElem("xqx:elementConstructor", node);
                this.flushOpen(node);
                int n = node.jjtGetNumChildren();
                boolean didFindDirElemContent = false;
                SimpleNode openChild = null;
                int nPush = 0;
                boolean didPushOpenXMLElem = false;
                try {
                    boolean enclosed = false;
                    for (int i = 0; i < n; ++i) {
                        enclosed = false;
                        SimpleNode child = this.sn(node.jjtGetChild(i));
                        if (child.id == 109) {
                            this._openXMLElemStack.push(child);
                            didPushOpenXMLElem = true;
                        } else if (child.id == 126) {
                            if (!didFindDirElemContent) {
                                this.pushElem("xqx:elementContent", node);
                                this.flushOpen(node);
                                didFindDirElemContent = true;
                            }
                            if (this.isEncloseExpr(child)) {
                                if (nPush == 2) {
                                    this.flushClose(node, !this.isElemContentChar(openChild));
                                    this.flushClose(node);
                                }
                                openChild = this.sn(this.sn(child.jjtGetChild(0)).jjtGetChild(0));
                                child = this.sn(this.sn(child.jjtGetChild(0)).jjtGetChild(0));
                                nPush = 0;
                                enclosed = true;
                            } else if (this.isElemContentChar(child)) {
                                if (child.id == 126 && this.shouldStripChar(this.sn(child.jjtGetChild(0)))) continue;
                                if (!this.isElemContentChar(openChild)) {
                                    this.pushElem("xqx:stringConstantExpr", node);
                                    this.flushOpen(node);
                                    this.pushElem("xqx:value", node);
                                    this.flushOpen(node, false);
                                    nPush = 2;
                                }
                                openChild = child;
                            } else {
                                if (nPush == 2) {
                                    this.flushClose(node, !this.isElemContentChar(openChild));
                                    this.flushClose(node);
                                }
                                openChild = child;
                                nPush = 0;
                            }
                        }
                        if (enclosed) {
                            SimpleNode curChild = this.sn(child.jjtGetChild(1));
                            while (curChild != null && (curChild.id == 38 && curChild.jjtGetNumChildren() == 1 || curChild.id == 104 || curChild.id == 105 || curChild.id == 99)) {
                                if (curChild.jjtGetNumChildren() >= 1) {
                                    curChild = this.sn(curChild.jjtGetChild(0));
                                    continue;
                                }
                                curChild = null;
                            }
                            if (curChild != null && curChild.id == 106) {
                                this.pushElem("xqx:sequenceExpr", node);
                                this.flushOpen(node);
                                this.transform(child);
                                this.flushClose(node);
                                continue;
                            }
                            this.transform(child);
                            continue;
                        }
                        this.transform(child);
                    }
                }
                finally {
                    if (didPushOpenXMLElem) {
                        this._openXMLElemStack.pop();
                    }
                }
                if (nPush == 2) {
                    this.flushClose(node, false);
                    this.flushClose(node);
                }
                if (didFindDirElemContent) {
                    this.flushClose(node);
                }
                this.flushClose(node);
                return node;
            }
            case 115: {
                if (this.isJustWhitespace(node)) {
                    return node;
                }
                int n = node.jjtGetNumChildren();
                int isOpenMode = -1;
                boolean isAttributeValueExpr = false;
                for (int i = 0; i < n; ++i) {
                    SimpleNode child = this.sn(node.jjtGetChild(i));
                    if (!this.isEncloseExpr(child)) continue;
                    isAttributeValueExpr = true;
                    break;
                }
                if (isAttributeValueExpr) {
                    String val = this.getTagnameNodeFromAttributeValueNode((SimpleNode)node).m_value;
                    if (this.isNamespaceDecl(val)) {
                        String errMsg = "<err id='XQST0022'>It is a static error if the value of a namespace declaration attribute is not a URILiteral.</err>";
                        throw new RuntimeException(errMsg);
                    }
                    this.pushElem("xqx:attributeValueExpr", node);
                    this.flushOpen(node);
                    int nPush = 0;
                    for (int i = 0; i < n; ++i) {
                        SimpleNode child = this.sn(node.jjtGetChild(i));
                        if (this.isEncloseExpr(child)) {
                            if (nPush == 2) {
                                this.flushClose(node, !this.isAttrContentChar(isOpenMode));
                                this.flushClose(node);
                            }
                            isOpenMode = this.sn((Node)this.sn((Node)child.jjtGetChild((int)0)).jjtGetChild((int)0)).id;
                            child = this.sn(this.sn(child.jjtGetChild(0)).jjtGetChild(0));
                            nPush = 0;
                        } else if (this.isAttrContentChar(child.id)) {
                            if (!this.isAttrContentChar(isOpenMode)) {
                                this.pushElem("xqx:stringConstantExpr", node);
                                this.flushOpen(node);
                                this.pushElem("xqx:value", node);
                                this.flushOpen(node, false);
                                nPush = 2;
                            }
                            isOpenMode = child.id;
                        } else {
                            if (child.id == 116 || child.id == 118 || child.id == 119 || child.id == 121) continue;
                            if (nPush == 2) {
                                this.flushClose(node, !this.isAttrContentChar(isOpenMode));
                                this.flushClose(node);
                            }
                            isOpenMode = child.id;
                            nPush = 0;
                        }
                        boolean savedIsAttr = this._isAttribute;
                        try {
                            this._isAttribute = true;
                            this.transform(child);
                            continue;
                        }
                        finally {
                            this._isAttribute = savedIsAttr;
                        }
                    }
                    if (nPush == 2) {
                        this.flushClose(node, false);
                        this.flushClose(node);
                    }
                    this.flushClose(node);
                } else {
                    String val = this.getTagnameNodeFromAttributeValueNode((SimpleNode)node).m_value;
                    if (this.isNamespaceDecl(val)) {
                        this.pushElem("xqx:uri", node);
                    } else {
                        this.pushElem("xqx:attributeValue", node);
                    }
                    this.flushOpen(node, false);
                    for (int i = 0; i < n; ++i) {
                        SimpleNode child = this.sn(node.jjtGetChild(i));
                        if (child.id == 116 || child.id == 118 || child.id == 119 || child.id == 121) continue;
                        SimpleNode grandChild = null;
                        if (child.jjtGetNumChildren() > 0) {
                            grandChild = this.sn(child.jjtGetChild(0));
                        }
                        SimpleNode sib = null;
                        SimpleNode sibChild = null;
                        if (i + 1 < n) {
                            sib = this.sn(node.jjtGetChild(i + 1));
                        }
                        if (sib != null && sib.jjtGetNumChildren() > 0) {
                            sibChild = this.sn(sib.jjtGetChild(0));
                        }
                        if (child.id == 122 && grandChild != null && grandChild.id == 123 && grandChild.m_value.equals("\r") && sib != null && sib.id == 122 && sibChild != null && sibChild.id == 123 && sibChild.m_value.equals("\n") || child.id == 124 && grandChild != null && grandChild.id == 125 && grandChild.m_value.equals("\r") && sib != null && sib.id == 124 && sibChild != null && sibChild.id == 125 && sibChild.m_value.equals("\n")) continue;
                        boolean savedIsAttr = this._isAttribute;
                        try {
                            this._isAttribute = true;
                            this.transform(child);
                            continue;
                        }
                        finally {
                            this._isAttribute = savedIsAttr;
                        }
                    }
                    this.flushClose(node, false);
                }
                return node;
            }
            case 117: {
                this.xqprint("\"");
                return node;
            }
            case 120: {
                this.xqprint("'");
                return node;
            }
            case 123: 
            case 125: {
                if (node.m_value != null) {
                    SimpleNode nextCharNode;
                    boolean shouldSkip = false;
                    SimpleNode charParent = (SimpleNode)node.jjtGetParent();
                    SimpleNode nextSibling = this.getNextSibling(charParent);
                    if (null != nextSibling && nextSibling.jjtGetNumChildren() == 1 && null != (nextCharNode = (SimpleNode)nextSibling.jjtGetChild(0)) && node.m_value.equals("\r") && nextCharNode.equals("\n")) {
                        shouldSkip = true;
                    }
                    if (node.m_value.equals("\r") && !shouldSkip) {
                        node.m_value = "\n";
                    }
                    if (!shouldSkip) {
                        this.xqprintEscaped(node.m_value, 'x');
                    }
                }
                return node;
            }
            case 127: {
                if (node.m_value != null) {
                    this.xqprintEscaped(node.m_value, 'x');
                }
                return node;
            }
            default: {
                String context = "";
                SimpleNode parent = node;
                System.err.println("Unknown ID: " + XParserTreeConstants.jjtNodeName[id]);
                while ((parent = (SimpleNode)parent.jjtGetParent()) != null) {
                    context = XParserTreeConstants.jjtNodeName[parent.id] + (context.length() == 0 ? "" : ", " + context);
                }
                System.err.println("Context is " + context);
                break;
            }
        }
        return null;
    }

    protected int transform_ClauseItem(SimpleNode parent, boolean is_for, int i) {
        this.pushElem(is_for ? "xqx:forClauseItem" : "xqx:letClauseItem", parent);
        this.flushOpen(parent, true);
        SimpleNode nextChild = (SimpleNode)parent.jjtGetChild(i);
        if (!$assertionsDisabled && nextChild.id != 98) {
            throw new AssertionError();
        }
        this.pushElem("xqx:typedVariableBinding", parent);
        this.flushOpen(parent, true);
        this.pushElem(nextChild.id, nextChild);
        String qname = ((SimpleNode)nextChild.jjtGetChild((int)0)).m_value;
        if (null != qname) {
            qname = this.processPrefix(qname);
        }
        this.flushOpen(nextChild, false);
        this.xqprint(qname);
        this.flushClose(nextChild, false);
        nextChild = (SimpleNode)parent.jjtGetChild(++i);
        if (nextChild.id == 163) {
            this.transform(nextChild);
            nextChild = (SimpleNode)parent.jjtGetChild(++i);
        }
        this.flushClose(parent, true);
        if (nextChild.id == 42) {
            if (!$assertionsDisabled && !is_for) {
                throw new AssertionError();
            }
            this.transformChildren(parent, i, i);
            nextChild = (SimpleNode)parent.jjtGetChild(++i);
        }
        this.pushElem(is_for ? "xqx:forExpr" : "xqx:letExpr", parent);
        this.flushOpen(parent, true);
        this.transform(nextChild);
        this.flushClose(parent);
        this.flushClose(parent);
        return ++i;
    }

    protected void process_FunctionOption(SimpleNode option) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void checkDuplicateSetters(SimpleNode setter) {
        SimpleNode setterChild = (SimpleNode)setter.jjtGetChild(0);
        int childID = setterChild.id;
        SimpleNode parent = (SimpleNode)setter.jjtGetParent();
        int numParentChildren = parent.jjtGetNumChildren();
        for (int j = 0; j < numParentChildren; ++j) {
            String errorMsg;
            String errorCode;
            SimpleNode setterCandidate = (SimpleNode)parent.jjtGetChild(j);
            if (setterCandidate == setter || setterCandidate.id != 9 || ((SimpleNode)setterCandidate.jjtGetChild((int)0)).id != childID) continue;
            if (childID == 13) {
                errorCode = "err:XQST0068";
                errorMsg = "Prolog contains more than one boundary-space declaration.";
            } else if (childID == 23) {
                errorCode = "err:XQST0038";
                errorMsg = "Prolog contains more than one default collation declaration, or the value specified by a default collation declaration is not present in statically known collations.";
            } else if (childID == 24) {
                errorCode = "err:XQST0032";
                errorMsg = "Prolog contains more than one base URI declaration.";
            } else if (childID == 30) {
                errorCode = "err:XQST0067";
                errorMsg = "Prolog contains more than one construction declaration.";
            } else if (childID == 16) {
                errorCode = "err:XQST0065";
                errorMsg = "Prolog contains more than one ordering mode declaration.";
            } else if (childID == 17) {
                errorCode = "err:XQST0069";
                errorMsg = "Prolog contains more than one empty order declaration.";
            } else if (childID == 20) {
                errorCode = "err:XQST0055";
                errorMsg = "Prolog contains more than one copy-namespaces declaration.";
            } else {
                errorCode = "err:???";
                errorMsg = "Unknown setter found!";
            }
            throw new PostParseException(errorCode + " Static Error: " + errorMsg);
        }
    }

    protected SimpleNode getTagnameNodeFromAttributeValueNode(SimpleNode node) {
        SimpleNode prev = node;
        while ((prev = this.getPreviousSibling(prev)) != null) {
            if (prev.id == 114 || prev.id == 75) continue;
            return prev;
        }
        return null;
    }

    protected boolean isNamespaceDecl(SimpleNode child) {
        return child.m_value.startsWith("xmlns:") || child.m_value.equals("xmlns");
    }

    protected boolean isNamespaceDecl(String val) {
        return val.startsWith("xmlns:") || val.equals("xmlns");
    }

    protected SimpleNode getNextSibling(SimpleNode node) {
        int nSiblingsOrSelf = node.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < nSiblingsOrSelf; ++i) {
            SimpleNode siblingOrSelf = this.sn(node.jjtGetParent().jjtGetChild(i));
            if (siblingOrSelf != node) continue;
            if (i + 1 >= nSiblingsOrSelf) break;
            return this.sn(node.jjtGetParent().jjtGetChild(i + 1));
        }
        return null;
    }

    protected SimpleNode getPreviousSibling(SimpleNode node) {
        int nSiblingsOrSelf = node.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < nSiblingsOrSelf; ++i) {
            SimpleNode siblingOrSelf = this.sn(node.jjtGetParent().jjtGetChild(i));
            if (siblingOrSelf != node) continue;
            if (i <= 0) break;
            return this.sn(node.jjtGetParent().jjtGetChild(i - 1));
        }
        return null;
    }

    protected boolean hasChildID(SimpleNode node, int id) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode child = this.sn(node.jjtGetChild(i));
            if (child.id != id) continue;
            return true;
        }
        return false;
    }

    protected int getNumExprChildren(SimpleNode node) {
        return this.getNumExprChildren(node, 0);
    }

    protected int getNumExprChildren(SimpleNode node, int start) {
        int count = 0;
        int n = node.jjtGetNumChildren();
        for (int i = start; i < n; ++i) {
            SimpleNode child = this.sn(node.jjtGetChild(i));
            if (child.id == 75 || child.id == 35 || child.id == 36) continue;
            ++count;
        }
        return count;
    }

    protected int getNumRealChildren(SimpleNode node) {
        int count = 0;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode child = this.sn(node.jjtGetChild(i));
            if (child.id == 75) continue;
            ++count;
        }
        return count;
    }

    protected boolean isEncloseExpr(SimpleNode child) {
        return (child.id == 122 || child.id == 124 || child.id == 126) && this.sn((Node)child.jjtGetChild((int)0)).id == 128 && this.sn((Node)this.sn((Node)child.jjtGetChild((int)0)).jjtGetChild((int)0)).id == 34;
    }

    boolean isLastChild(Node n) {
        int count;
        SimpleNode sm = (SimpleNode)n;
        SimpleNode parent = (SimpleNode)sm.jjtGetParent();
        Node lastChild = parent.jjtGetChild((count = parent.jjtGetNumChildren()) - 1);
        return lastChild == sm;
    }

    protected boolean isAttrContentChar(int id) {
        switch (id) {
            case 117: 
            case 120: 
            case 122: 
            case 124: {
                return true;
            }
            case 128: {
                return true;
            }
        }
        return false;
    }

    protected boolean isFilterExpr(SimpleNode node) {
        int id = node.id;
        switch (id) {
            case 4: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    protected boolean isElemContentChar(SimpleNode node) {
        if (node == null) {
            return false;
        }
        if (node.id == 126) {
            switch (this.getChildID(node, 0)) {
                case 127: {
                    return true;
                }
                case 128: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected String processPrefix(String qname) {
        if (qname == null) {
            return qname;
        }
        int i = qname.indexOf(58);
        if (i > 0) {
            String prefix = qname.substring(0, i);
            qname = qname.substring(i + 1);
            this.pushAttr("xqx:prefix", prefix);
        }
        return qname;
    }

    protected SimpleNode sn(Node node) {
        return (SimpleNode)node;
    }

    protected void transformChildren(SimpleNode node, int start, int end) {
        for (int i = start; i <= end; ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            this.transform(child);
        }
    }

    protected void transformChildren(SimpleNode node, int start) {
        this.transformChildren(node, start, node.jjtGetNumChildren() - 1);
    }

    protected void transformChildren(SimpleNode node) {
        this.transformChildren(node, 0, node.jjtGetNumChildren() - 1);
    }

    protected int getParentID(SimpleNode node) {
        return ((SimpleNode)node.jjtGetParent()).id;
    }

    protected SimpleNode getFirstChildOfFirstChild(SimpleNode node) {
        if (node.jjtGetNumChildren() <= 0) {
            return null;
        }
        Node firstChild = node.jjtGetChild(0);
        if (((SimpleNode)firstChild).jjtGetNumChildren() <= 0) {
            return null;
        }
        return (SimpleNode)firstChild.jjtGetChild(0);
    }

    protected int getFirstChildOfFirstChildID(SimpleNode node) {
        if (node.jjtGetNumChildren() <= 0) {
            return -1;
        }
        Node firstChild = node.jjtGetChild(0);
        if (((SimpleNode)firstChild).jjtGetNumChildren() <= 0) {
            return -1;
        }
        return ((SimpleNode)firstChild.jjtGetChild((int)0)).id;
    }

    protected int getChildID(SimpleNode node, int i) {
        if (i < node.jjtGetNumChildren()) {
            return ((SimpleNode)node.jjtGetChild((int)i)).id;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !XQueryXConverterBase.class.desiredAssertionStatus();
        MAXCHAR = 65535;
    }
}

