/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.xqparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.xqparser.ParseException;
import org.w3c.xqparser.PostParseException;
import org.w3c.xqparser.SimpleNode;
import org.w3c.xqparser.XParser;
import org.w3c.xqparser.Xq2xml;
import org.xml.sax.SAXException;

public class Test {
    static final int DUMP_NONE = 1;
    static final int DUMP_AST = 2;
    static final int DUMP_XQUERYX = 3;
    static final int DUMP_AST_XML = 4;
    int dumpFormat;
    String XQueryXOutputFilename = null;
    String XQueryXOutputHierarchyRoot = null;
    boolean validateXQueryX = false;
    int maxInvalidXQueryX = -1;
    private static final String UTF_16_BE = "UTF-16BE";
    private static final String UTF_16_LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseEncoding(String filePath) {
        if (filePath == null) return null;
        if (filePath.equals("")) {
            return null;
        }
        FileInputStream fileInstream = null;
        BufferedReader br = null;
        InputStreamReader reader = null;
        try {
            StringBuffer sub;
            fileInstream = new FileInputStream(filePath);
            int byteOne = fileInstream.read();
            int byteTwo = fileInstream.read();
            if (byteOne == 254 && byteTwo == 255) {
                String string = UTF_16_BE;
                return string;
            }
            if (byteOne == 255 && byteTwo == 254) {
                String string = UTF_16_LE;
                return string;
            }
            int byteThree = fileInstream.read();
            if (byteOne == 239 && byteTwo == 187 && byteThree == 191) {
                String ex = UTF_8;
                return ex;
            }
            reader = new FileReader(filePath);
            br = new BufferedReader(reader);
            String text = br.readLine();
            int index = text.indexOf("encoding") + 8;
            if (index > 7 && (sub = new StringBuffer(text.substring(index).trim())).charAt(0) == '=') {
                int qouteIndex;
                sub.deleteCharAt(0);
                String st = sub.toString().trim();
                if (st.charAt(0) == '\"' && (qouteIndex = st.indexOf(34, 1)) > -1) {
                    String string = st.substring(1, qouteIndex);
                    return string;
                }
            }
            String string = UTF_8;
            return string;
        }
        catch (FileNotFoundException fne) {
            String string = null;
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fileInstream != null) {
                    fileInstream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void main(String[] args) {
        Test test = new Test();
        test.process(args);
    }

    public void process(String[] args) {
        boolean haveXQueryXConverter = this.thisPackageHasAnXQueryXConverter();
        int argsStart = 0;
        this.dumpFormat = 1;
        while (argsStart < args.length) {
            try {
                String arg = args[argsStart];
                ++argsStart;
                if (arg.equals("-dumptree")) {
                    this.dumpFormat = 2;
                    continue;
                }
                if (arg.equals("-dumpxml")) {
                    this.dumpFormat = 4;
                    continue;
                }
                if (arg.equals("-xqueryx")) {
                    if (haveXQueryXConverter) {
                        this.dumpFormat = 3;
                        continue;
                    }
                    System.out.println("Ignoring arg '-xqueryx': this package does not have an XQueryX converter.");
                    continue;
                }
                if ("-xqueryxfile".equalsIgnoreCase(arg)) {
                    if (haveXQueryXConverter) {
                        this.XQueryXOutputFilename = args[argsStart];
                        this.XQueryXOutputHierarchyRoot = null;
                        this.dumpFormat = 3;
                    } else {
                        System.out.println("Ignoring arg '-xqueryxfile': this package does not have an XQueryX converter.");
                    }
                    ++argsStart;
                    continue;
                }
                if (arg.equalsIgnoreCase("-XQueryXOutputHierarchyRoot")) {
                    if (haveXQueryXConverter) {
                        this.XQueryXOutputHierarchyRoot = args[argsStart];
                        this.XQueryXOutputFilename = null;
                        this.dumpFormat = 3;
                    } else {
                        System.out.println("Ignoring arg '-XQueryXOutputHierarchyRoot': this package does not have an XQueryX converter.");
                    }
                    ++argsStart;
                    continue;
                }
                if (arg.equalsIgnoreCase("-validateXQueryX")) {
                    if (haveXQueryXConverter) {
                        this.validateXQueryX = true;
                        continue;
                    }
                    System.out.println("Ignoring arg '-validateXQueryX': this package does not have an XQueryX converter.");
                    continue;
                }
                if (arg.equalsIgnoreCase("-maxInvalidXQueryX")) {
                    if (haveXQueryXConverter) {
                        this.maxInvalidXQueryX = Integer.parseInt(args[argsStart]);
                    } else {
                        System.out.println("Ignoring arg '-maxInvalidXQueryX': this package does not have an XQueryX converter.");
                    }
                    ++argsStart;
                    continue;
                }
                if ("-file".equalsIgnoreCase(arg)) {
                    String filename = args[argsStart];
                    ++argsStart;
                    this.processFile(filename);
                    continue;
                }
                if (arg.endsWith(".xquery")) {
                    this.processFile(arg);
                    continue;
                }
                if ("-expr".equalsIgnoreCase(arg)) {
                    String expression = args[argsStart];
                    ++argsStart;
                    this.processString(expression);
                    continue;
                }
                if ("-catalog".equalsIgnoreCase(arg)) {
                    String catalogFileName = args[argsStart];
                    ++argsStart;
                    this.processW3CTestCatalog(catalogFileName);
                    continue;
                }
                this.processExprsInXmlFile(arg);
            }
            catch (PostParseException ppe) {
                System.err.println("    " + ppe.getMessage());
                return;
            }
            catch (Exception e) {
                System.out.println("    " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    void processExprsInXmlFile(String filename) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(filename);
        Element tests = doc.getDocumentElement();
        NodeList testElems = tests.getChildNodes();
        int nChildren = testElems.getLength();
        int testid = 0;
        for (int i = 0; i < nChildren; ++i) {
            Node node = testElems.item(i);
            if (1 != node.getNodeType()) continue;
            ++testid;
            String xpathString = ((Element)node).getAttribute("value");
            if (this.dumpFormat != 1) {
                System.out.println("  Test[" + testid + "]: " + xpathString);
            } else {
                System.out.print("[" + testid + "]");
                System.out.flush();
                if (testid < 20) {
                    if (testid % 18 == 0) {
                        System.out.println();
                    }
                } else if (testid < 114) {
                    if (testid % 14 == 0) {
                        System.out.println();
                    }
                } else if (testid < 1000) {
                    if (testid % 12 == 0) {
                        System.out.println();
                    }
                } else if (testid % 10 == 0) {
                    System.out.println();
                }
            }
            try {
                this.dump(this.parseString(xpathString));
                continue;
            }
            catch (ParseException e) {
                System.out.println("parse error (" + this.getFirstLine(e.getMessage()) + ")");
            }
        }
        System.out.println();
        if (this.dumpFormat != 3) {
            System.out.println("End of file.");
        }
        System.out.flush();
    }

    String getFirstLine(String s) {
        String eol = System.getProperty("line.separator", "\n");
        int indexOfFirstEOL = s.indexOf(eol);
        return indexOfFirstEOL == -1 ? s : s.substring(0, indexOfFirstEOL);
    }

    private void processW3CTestCatalog(String catalogFileName) throws ParserConfigurationException, SAXException, IOException {
        Element testCase;
        System.out.println("Running catalog for: " + catalogFileName);
        System.out.println("'i' means test parsed but XQueryX is invalid (test failed).");
        System.out.println("'x' means a parse error should have taken place (test failed).");
        System.out.println("'e' means a parse error took place but shouldn't have (test failed).");
        System.out.println("'v' means parse succeeded and XQueryX output was validated (test succeeds).");
        System.out.println("',' means parse error properly took place (test succeeds).");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(catalogFileName);
        int nQueries = 0;
        FailureList failedToParse = new FailureList("Should have parsed but raised an error");
        FailureList failedToRaiseError = new FailureList("Should have raised a parse error but didn't");
        FailureList failedToFindFile = new FailureList("Files not found");
        FailureList failedToConvertToXqx = new FailureList("Conversion to XQueryX failed");
        FailureList failedToValidateXqx = new FailureList("XQueryX validation failed");
        boolean hadEnough = false;
        File catFile = new File(catalogFileName);
        String catDir = catFile.getParent();
        String xqFilePathCommonPrefix = catDir + File.separator + "Queries" + File.separator + "XQuery" + File.separator;
        NodeIterator testCases = this.getDescendantsNamed(doc, doc, "test-case");
        block7: while ((testCase = (Element)testCases.nextNode()) != null && !hadEnough) {
            Element query;
            String tcFilePath = testCase.getAttribute("FilePath").replace('/', File.separatorChar);
            String tcScenario = testCase.getAttribute("scenario");
            boolean tcExpectsParseError = tcScenario.equals("parse-error");
            NodeIterator queries = this.getDescendantsNamed(doc, testCase, "query");
            while ((query = (Element)queries.nextNode()) != null && !hadEnough) {
                boolean isValid;
                String qName = query.getAttribute("name");
                String xqRelPath = tcFilePath + qName + ".xq";
                String xqFilePath = xqFilePathCommonPrefix + xqRelPath;
                if (this.dumpFormat != 1 && this.dumpFormat != 3) {
                    System.out.print("== ");
                    System.out.print(xqFilePath);
                    System.out.println(" ==");
                }
                if (nQueries % 30 == 0) {
                    System.out.println();
                    System.out.print(this.leftPad(Integer.toString(nQueries), 5, ' ') + "+  ");
                }
                ++nQueries;
                SimpleNode tree = null;
                try {
                    tree = this.parseFile(xqFilePath);
                    if (tcExpectsParseError) {
                        failedToRaiseError.add(xqRelPath);
                        System.out.print("x");
                        System.out.flush();
                    } else {
                        System.out.print(".");
                        System.out.flush();
                    }
                }
                catch (FileNotFoundException e) {
                    failedToFindFile.add(xqRelPath);
                    System.out.print("f");
                    System.out.flush();
                }
                catch (Throwable t) {
                    if (tcExpectsParseError || tcScenario.equals("runtime-error")) {
                        System.out.print(",");
                        System.out.flush();
                    }
                    failedToParse.add(xqRelPath);
                    System.out.print("e");
                    System.out.flush();
                }
                if (this.XQueryXOutputFilename == null && this.XQueryXOutputHierarchyRoot == null) continue;
                String xqueryxFilename = null;
                if (tree != null) {
                    try {
                        if (this.XQueryXOutputHierarchyRoot != null) {
                            String outputDirName = this.XQueryXOutputHierarchyRoot + File.separatorChar + tcFilePath;
                            new File(outputDirName).mkdirs();
                            xqueryxFilename = outputDirName + qName + ".xqx";
                        } else {
                            xqueryxFilename = this.XQueryXOutputFilename;
                        }
                        this.convertXQueryToXQueryX(tree, null, xqueryxFilename);
                    }
                    catch (Throwable t) {
                        failedToConvertToXqx.add(xqRelPath);
                        xqueryxFilename = null;
                    }
                }
                if (!this.validateXQueryX || xqueryxFilename == null) continue;
                try {
                    isValid = this.validateXMLFile(xqueryxFilename, null);
                }
                catch (Throwable t) {
                    isValid = false;
                }
                System.out.print(isValid ? "v" : "i");
                System.out.flush();
                if (isValid) continue;
                failedToValidateXqx.add(xqRelPath);
                if (this.maxInvalidXQueryX < 0 || failedToValidateXqx.size() <= this.maxInvalidXQueryX) continue;
                System.out.println("\n\nAborting due to more than " + this.maxInvalidXQueryX + " invalid XQueryX conversions");
                System.out.flush();
                hadEnough = true;
                continue block7;
            }
        }
        System.out.println();
        System.out.println("All filepaths shown below are relative to:");
        System.out.println("    " + xqFilePathCommonPrefix);
        System.out.println();
        failedToFindFile.show();
        failedToParse.show();
        failedToRaiseError.show();
        int nParseFailures = failedToParse.size() + failedToRaiseError.size();
        if (nParseFailures > 0) {
            System.out.print("Failed " + nParseFailures + " out of ");
        } else {
            System.out.print("Total Success!! ");
        }
        System.out.println(nQueries + " cases");
        failedToConvertToXqx.show();
        failedToValidateXqx.show();
    }

    NodeIterator getDescendantsNamed(Document doc, Node base, final String localName) {
        return ((DocumentTraversal)((Object)doc)).createNodeIterator(base, 1, new NodeFilter(){

            public short acceptNode(Node node) {
                String nm = node.getLocalName();
                String namespace = node.getNamespaceURI();
                boolean nameMatches = nm.equals(localName) && namespace != null && namespace.startsWith("http://www.w3.org/2005/02/query-test-");
                return nameMatches ? (short)1 : 3;
            }
        }, true);
    }

    String leftPad(String s, int width, char padChar) {
        if (s.length() >= width) {
            return s;
        }
        return this.leftPad(padChar + s, width, padChar);
    }

    void processFile(String filename) throws FileNotFoundException, IOException, UnsupportedEncodingException, ParseException {
        if (this.dumpFormat != 3) {
            System.out.println("Running test for: " + filename);
        }
        this.dump(this.parseFile(filename));
        if (this.dumpFormat != 3) {
            System.out.println("Test successful!!!");
        }
    }

    void processString(String str) throws ParseException {
        if (this.dumpFormat != 3) {
            System.out.println("Running test for: " + str);
        }
        this.dump(this.parseString(str));
        if (this.dumpFormat != 3) {
            System.out.println("Test successful!!!");
        }
    }

    SimpleNode parseFile(String filename) throws FileNotFoundException, IOException, UnsupportedEncodingException, ParseException {
        File file = new File(filename);
        String encoding = Test.parseEncoding(file.getAbsolutePath());
        FileInputStream fis = new FileInputStream(file);
        if (encoding != null && (encoding.equals(UTF_16_BE) || encoding.equals(UTF_16_LE))) {
            fis.read();
            fis.read();
        }
        InputStreamReader isr = null == encoding ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encoding);
        XParser parser = new XParser(isr);
        SimpleNode tree = parser.START();
        return tree;
    }

    SimpleNode parseString(String str) throws ParseException {
        StringReader reader = new StringReader(str);
        XParser parser = new XParser(reader);
        SimpleNode tree = parser.START();
        return tree;
    }

    void dump(SimpleNode tree) {
        if (this.dumpFormat == 2) {
            tree.dump("|");
        }
        if (this.dumpFormat == 4) {
            try {
                PrintWriter systemOutWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, UTF_8));
                Xq2xml.convert(" ", systemOutWriter, tree);
                systemOutWriter.flush();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (this.dumpFormat == 3) {
            Vector errors = new Vector();
            this.convertXQueryToXQueryX(tree, System.out, this.XQueryXOutputFilename);
            if (this.XQueryXOutputFilename == null) {
                System.err.println("\n   Skipping validation, because the XQueryX translation isn't in a file.");
                return;
            }
            if (!this.validateXQueryX) {
                return;
            }
            boolean isValid = this.validateXMLFile(this.XQueryXOutputFilename, errors);
            if (!isValid) {
                System.err.println("\n   XQueryX Translation is invalid!");
                for (int i = 0; i < errors.size(); ++i) {
                    String msg = (String)errors.elementAt(i);
                    System.err.println(msg);
                }
            }
        }
    }

    private boolean thisPackageHasAnXQueryXConverter() {
        try {
            Class.forName("org.w3c.xqparser.XQueryXConverter");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void convertXQueryToXQueryX(SimpleNode tree, PrintStream ps1, String xqueryxFilename) {
        try {
            PrintStream ps2 = xqueryxFilename != null ? new PrintStream(new FileOutputStream(xqueryxFilename)) : null;
            Class<?> transformerClass = Class.forName("org.w3c.xqparser.XQueryXConverter");
            Object transformer = transformerClass.newInstance();
            Class[] argTypes = new Class[]{SimpleNode.class, PrintStream.class, PrintStream.class};
            Method transformMethod = transformerClass.getMethod("transform", argTypes);
            Object[] args = new Object[]{tree, ps1, ps2};
            transformMethod.invoke(transformer, args);
            if (ps2 != null) {
                ps2.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (PostParseException ppe) {
            throw ppe;
        }
        catch (ClassNotFoundException e) {
            System.err.println("XQueryX translator not yet supported!");
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PostParseException) {
                throw (RuntimeException)cause;
            }
            if (!cause.getMessage().startsWith("<err")) {
                e.getCause().printStackTrace();
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private boolean validateXMLFile(String xmlFilename, Vector errors) {
        boolean isValidDoc = false;
        try {
            Class<?> validatorClass = Class.forName("org.w3c.xqparser.XMLValidator");
            Object validator = validatorClass.newInstance();
            Class[] argTypes = new Class[]{String.class, Vector.class};
            Method validateXMLFileMethod = validatorClass.getMethod("validateXMLFile", argTypes);
            Object[] args = new Object[]{xmlFilename, errors};
            Boolean isValid = (Boolean)validateXMLFileMethod.invoke(validator, args);
            isValidDoc = isValid;
        }
        catch (ClassNotFoundException e) {
            System.err.println("XML Validator class not found!");
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            throw new RuntimeException(e);
        }
        return isValidDoc;
    }

    class FailureList {
        private String header;
        private Vector failures = new Vector();

        public FailureList(String header) {
            this.header = header;
        }

        public void add(String xqRelPath) {
            this.failures.addElement(xqRelPath);
        }

        public int size() {
            return this.failures.size();
        }

        public void show() {
            String indent = "    ";
            if (this.failures.size() > 0) {
                System.out.println(this.header + " (" + this.failures.size() + "):");
                for (int i = 0; i != this.failures.size(); ++i) {
                    String fname = (String)this.failures.elementAt(i);
                    System.out.println(indent + fname);
                }
                System.out.println();
            }
        }
    }
}

