/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TransPrep {
    public String inputDocName;
    public String outputDoc;
    public String externalRules;
    public int outputFormat;
    private static String itsnsuri = new String("http://www.w3.org/2005/11/its");
    private static int pos;
    private static String xlinknsuri;
    private static String translate;
    private static String yes;
    private static String no;
    private static String tve;
    private static String tva;
    private static String nsxp;
    private static String xpathWrongMatch;
    private static String countxp;

    public static void printUsage() {
        System.out.println("TransPrep v. 0.1\nFor documentation see http://www.w3.org/2008/05/transprep/\nUSAGE:\ninputfile outputfile outputformat [externalRules]\noutputformat can be one of:\n 1 = input document decorated with translation information\n 2 = pseudotranslate\n 3 = testsuite output");
    }

    private static void checkLocalMarkup(Element element) {
        if (element.hasAttributeNS(itsnsuri, translate)) {
            if (element.getAttributeNS(itsnsuri, translate).compareTo(yes) == 0) {
                element.setAttribute(tve, yes);
            }
            if (element.getAttributeNS(itsnsuri, translate).compareTo(no) == 0) {
                element.setAttribute(tve, no);
            }
        } else if (element.getNamespaceURI() != null && element.getNamespaceURI().compareTo(itsnsuri) == 0 && element.getLocalName().compareTo("span") == 0 && element.hasAttribute("translate")) {
            String string = element.getAttribute("translate");
            if (string.compareTo(yes) == 0) {
                element.setAttribute(tve, yes);
            }
            if (string.compareTo(no) == 0) {
                element.setAttribute(tve, no);
            }
        }
    }

    private static void traversing(Element element) {
        Object object;
        TransPrep.checkLocalMarkup(element);
        String string = element.getAttribute(tve);
        if (string.compareTo("") == 0) {
            object = (Element)element.getParentNode();
            String string2 = object.getAttribute(tve);
            if (string2 != "") {
                element.setAttribute(tve, string2);
            } else {
                element.setAttribute(tve, yes);
            }
        }
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (!(node instanceof Element)) continue;
            TransPrep.traversing((Element)object.item(i));
        }
    }

    private static ArrayList<Element> gatherRules(Element element, ArrayList<Element> arrayList) throws Exception {
        NodeList nodeList = element.getOwnerDocument().getElementsByTagNameNS(itsnsuri, "rules");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n = i + 1;
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagNameNS(itsnsuri, "translateRule");
            String string = element2.getAttributeNS(xlinknsuri, "href");
            if (string.compareTo("") != 0) {
                String string2 = element.getBaseURI();
                String[] stringArray = string2.split("[(\\)(/)]");
                String string3 = stringArray[stringArray.length - 1];
                String string4 = string2.replaceAll(string3, "");
                URI uRI = new URI(string4.concat(string).replaceAll("file:///", ""));
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new File(uRI));
                Element element3 = document.getDocumentElement();
                TransPrep.gatherRules(element3, arrayList);
            }
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                arrayList.add((Element)nodeList2.item(j));
            }
        }
        return arrayList;
    }

    private static void processGlobalRules(Element element, List<Element> list) throws XPathExpressionException {
        if (list.size() != 0) {
            int n;
            for (int i = n = list.size() - 1; i >= 0; --i) {
                Object object;
                String string;
                Element element2 = list.get(i);
                MyNamespaceContext myNamespaceContext = new MyNamespaceContext();
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile(nsxp);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    string = new String(nodeList.item(j).getNodeValue());
                    object = new String(element2.lookupPrefix(string));
                    myNamespaceContext.setNamespace((String)object, string);
                }
                String string2 = element2.getAttribute("selector");
                string = element2.getAttribute("translate");
                object = XPathFactory.newInstance().newXPath();
                object.setNamespaceContext(myNamespaceContext);
                NodeList nodeList2 = (NodeList)object.evaluate(string2, element, XPathConstants.NODESET);
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node;
                    Node node2 = nodeList2.item(j);
                    Short s = node2.getNodeType();
                    if (s == 1) {
                        node = (Element)node2;
                        if (node.getAttribute(tve) != "") continue;
                        node.setAttribute(tve, string);
                        continue;
                    }
                    if (s == 2) {
                        node = (Attr)node2;
                        Element element3 = node.getOwnerElement();
                        if (string.compareTo(yes) != 0) continue;
                        if (element3.getAttribute(tva) == "") {
                            element3.setAttribute(tva, "#" + node.getName() + "#");
                            continue;
                        }
                        String string3 = element3.getAttribute(tva);
                        element3.setAttribute(tva, string3 + "#" + node.getName() + "#");
                        continue;
                    }
                    System.out.println(xpathWrongMatch + string2 + " Node type: " + node2.getNodeName());
                }
            }
        }
    }

    public Document decorateDom() throws Exception, SAXParseException, SAXException, ParserConfigurationException, IOException {
        Object object;
        Object object2;
        Document document = this.parseDoc(this.inputDocName);
        Element element = document.getDocumentElement();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (this.externalRules != null) {
            object2 = this.parseDoc(this.externalRules).getDocumentElement();
            object = TransPrep.gatherRules((Element)object2, arrayList);
            ArrayList<Element> arrayList2 = TransPrep.gatherRules(element, object);
            TransPrep.processGlobalRules(element, arrayList2);
        } else {
            object2 = TransPrep.gatherRules(element, arrayList);
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            }
            TransPrep.processGlobalRules(element, (List<Element>)object2);
        }
        TransPrep.checkLocalMarkup(element);
        object2 = element.getAttribute(tve);
        if (((String)object2).compareTo("") == 0) {
            element.setAttribute(tve, yes);
        }
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            Short s = node.getNodeType();
            if (s != 1) continue;
            TransPrep.traversing((Element)object.item(i));
        }
        return document;
    }

    private static void pseudoTranslate(Element element) {
        Object object;
        String string = element.getAttribute("itsTva");
        element.removeAttribute("itsTva");
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            object = attr.getName();
            String string2 = "#".concat((String)object).concat("#");
            if (!string.contains(string2)) continue;
            attr.setNodeValue("Xxxx");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (object instanceof Text && element.getAttribute("itsTve").compareTo("yes") == 0) {
                object.setNodeValue("Xxxx");
            }
            if (!(object instanceof Element)) continue;
            TransPrep.pseudoTranslate((Element)nodeList.item(i));
        }
        element.removeAttribute("itsTve");
    }

    private static String countPos(Node node, String string) {
        if (node.getNodeName().equals(string)) {
            ++pos;
        }
        if (node.getPreviousSibling() != null) {
            Node node2 = node.getPreviousSibling();
            TransPrep.countPos(node2, string);
        }
        return "" + pos;
    }

    private static String writePath(Node node) {
        String string = ("{" + node.getNamespaceURI() + "}").replace("{null}", "{}");
        Short s = node.getNodeType();
        Node node2 = node.getParentNode();
        switch (s) {
            case 1: {
                Object object = node2.getNodeType();
                switch ((Short)object) {
                    case 1: {
                        pos = 0;
                        String string2 = "[" + TransPrep.countPos(node, node.getNodeName()) + "]";
                        return TransPrep.writePath(node2) + "/" + string + node.getLocalName() + string2;
                    }
                    case 9: {
                        return "/" + string + node.getLocalName();
                    }
                }
            }
            case 2: {
                Object object = (Attr)node;
                Element element = object.getOwnerElement();
                return TransPrep.writePath(element) + "/@" + string + node.getLocalName();
            }
        }
        return "";
    }

    private static void testsuite(Document document, Element element, Element element2) throws XPathExpressionException {
        Element element3;
        Node node;
        Object object;
        Node node2;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(countxp);
        String string = "e" + xPathExpression.evaluate(element).toString();
        String string2 = element.getAttribute("itsTva");
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node2 = (Attr)namedNodeMap.item(i);
            object = node2.getName();
            String string3 = "#".concat((String)object).concat("#");
            if (((String)object).startsWith("xmlns:") || ((String)object).compareTo("itsTve") == 0 || ((String)object).compareTo("itsTva") == 0) continue;
            node = document.createElement("o:node");
            node.setAttribute("path", TransPrep.writePath(node2));
            element3 = document.createElement("o:output");
            if (string2.contains(string3)) {
                element3.setAttribute("o:translate", "yes");
            } else {
                element3.setAttribute("o:translate", "no");
            }
            node.appendChild(element3);
            element2.appendChild(node);
        }
        Element element4 = document.createElement("o:node");
        element4.setAttribute("path", TransPrep.writePath(element));
        node2 = document.createElement("o:output");
        if (element.getAttribute("itsTve").compareTo("yes") == 0) {
            node2.setAttribute("o:translate", "yes");
        } else {
            node2.setAttribute("o:translate", "no");
        }
        element4.appendChild(node2);
        element2.appendChild(element4);
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            node = object.item(i);
            if (!(node instanceof Element)) continue;
            element3 = node;
            TransPrep.testsuite(document, element3, element2);
        }
    }

    public void createOutput(Document document, String string) throws TransformerConfigurationException, FileNotFoundException, TransformerException, SAXParseException, SAXException, ParserConfigurationException, IOException, XPathExpressionException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        switch (this.outputFormat) {
            case 1: {
                DOMSource dOMSource = new DOMSource(document);
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                StreamResult streamResult = new StreamResult(fileOutputStream);
                transformer.transform(dOMSource, streamResult);
                break;
            }
            case 2: {
                TransPrep.pseudoTranslate(document.getDocumentElement());
                DOMSource dOMSource = new DOMSource(document);
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                StreamResult streamResult = new StreamResult(fileOutputStream);
                transformer.transform(dOMSource, streamResult);
                break;
            }
            case 3: {
                Document document2 = this.parseDoc("template-testsuite.xml");
                Element element = (Element)document2.getElementsByTagName("o:nodeList").item(1);
                TransPrep.testsuite(document2, document.getDocumentElement(), element);
                DOMSource dOMSource = new DOMSource(document2);
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                StreamResult streamResult = new StreamResult(fileOutputStream);
                transformer.transform(dOMSource, streamResult);
                break;
            }
            default: {
                System.out.println("Unknown output format: " + this.outputFormat);
            }
        }
    }

    private Document parseDoc(String string) throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        return document;
    }

    public TransPrep(String string, String string2, int n) {
        this.inputDocName = string;
        this.outputDoc = string2;
        this.outputFormat = n;
    }

    public TransPrep(String string, String string2, int n, String string3) {
        this.inputDocName = string;
        this.outputDoc = string2;
        this.externalRules = string3;
        this.outputFormat = n;
    }

    public static void main(String[] stringArray) throws Exception {
        TransPrep.printUsage();
        TransPrep transPrep = new TransPrep("inputdoc-ns.xml", "output.xml", 1, "externalRules.xml");
        Document document = transPrep.decorateDom();
        transPrep.createOutput(document, transPrep.outputDoc);
    }

    static {
        xlinknsuri = new String("http://www.w3.org/1999/xlink");
        translate = new String("translate");
        yes = new String("yes");
        no = new String("no");
        tve = new String("itsTve");
        tva = new String("itsTva");
        nsxp = new String("namespace::*[not(.='http://www.w3.org/XML/1998/namespace')]");
        xpathWrongMatch = new String("Warning! Match of XPath expression is different than 'element node' or 'attribute node' and will be ignored: ");
        countxp = new String("count(preceding::* | ancestor::*)");
    }
}

