<?xml version="1.0" encoding="UTF-8"?>
<!--
    W3C® SOFTWARE NOTICE AND LICENSE
    http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231

    This work (and included software, documentation such as READMEs, or other related items) is being provided by the copyright holders under the following license. By obtaining, using and/or copying this work, you (the licensee) agree that you have read, understood, and will comply with the following terms and conditions.

    Permission to copy, modify, and distribute this software and its documentation, with or without modification, for any purpose and without fee or royalty is hereby granted, provided that you include the following on ALL copies of the software and documentation or portions thereof, including modifications:

    1. The full text of this NOTICE in a location viewable to users of the redistributed or derivative work.
    2. Any pre-existing intellectual property disclaimers, notices, or terms and conditions. If none exist, the W3C Software Short Notice should be included (hypertext is preferred, text is permitted) within the body of any redistributed or derivative code.
    3. Notice of any changes or modifications to the files, including the date changes were made. (We recommend you provide URIs to the location from which the code is derived.)

    THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

    COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE OR DOCUMENTATION.

    The name and trademarks of copyright holders may NOT be used in advertising or publicity pertaining to the software without specific, written prior permission. Title to copyright in this software and any associated documentation will at all times remain with copyright holders.

    ____________________________________

    This formulation of W3C's notice and license became active on December 31 2002. This version removes the copyright ownership notice such that this license can be used with materials other than those owned by the W3C, reflects that ERCIM is now a host of the W3C, includes references to this specific dated version of the license, and removes the ambiguous grant of "use". Otherwise, this version is the same as the previous version and is written so as to preserve the Free Software Foundation's assessment of GPL compatibility and OSI's certification under the Open Source Definition. Please see our Copyright FAQ for common questions about using materials from our site, including specific terms and conditions for packages like libwww, Amaya, and Jigsaw. Other questions about this notice can be directed to site-policy@w3.org.
    
  -->

<!-- Language Tag Analyzer (LTA) - version 0.2. html-output.xsl
     For documentation, see http://www.w3.org/2008/05/lta/
  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
		xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/"
		xmlns:my="http://example.com/myns" xmlns:lta="http://www.w3.org/2008/05/lta/"
		xmlns="http://www.w3.org/1999/xhtml" xmlns:h="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="my saxon xs h lta">
<xsl:template name="html-output">
<xsl:param name="constrainedCheckedLanguagetag"/>
          <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
              <title><xsl:apply-templates mode="writeMessage" select="$messages[@id='m1']/lta:unit[@xml:lang=$hl]"/></title>
              <style type="text/css"> *.element { color: #800080; font-weight: bold;} *.attribute {
                color: black; font-weight: bold;} *.aval { color: #0080FF; font-weight: normal;}
              </style>
            </head>
            <body>
              <h1>
		<xsl:apply-templates mode="writeMessage" select="$messages[@id='m1']/lta:unit[@xml:lang=$hl]"/>
	      </h1>
              <p>
		<xsl:apply-templates mode="writeMessage" select="$messages[@id='m2']/lta:unit[@xml:lang=$hl]">
		  <xsl:with-param name="variables">
		    <lta:var no="m2v1"><xsl:value-of  select="$inputlangtag"/></lta:var>
		  </xsl:with-param>
		</xsl:apply-templates>
	      </p>
              <p><xsl:apply-templates mode="writeMessage" select="$messages[@id='m3']/lta:unit[@xml:lang=$hl]"/></p>
	      <p>
		<xsl:apply-templates mode="writeMessage" select="$messages[@id='m4']/lta:unit[@xml:lang=$hl]">
		  <xsl:with-param name="variables">
		    <lta:var no="m4v1"><xsl:value-of  select="count($constrainedCheckedLanguagetag/*/*[not(name()='lta:notWellformed')])"/></lta:var>
		  </xsl:with-param>
		</xsl:apply-templates>
	      </p>
	      <ul>
		<xsl:apply-templates select="$constrainedCheckedLanguagetag/*/*" mode="xhtmloutput"/>
	      </ul>
	      <p>
	      	<a href="{concat('http://www.w3.org/2008/05/lta/language-tags/q?input=',$inputlangtag,'&amp;output=xml')}"><xsl:apply-templates mode="writeMessage" select="$messages[@id='m10']/lta:unit[@xml:lang=$hl]"/></a>
		<xsl:text> </xsl:text>
	      	<a href="{concat('http://www.w3.org/2008/05/lta/language-tags/q?input=',$inputlangtag,'&amp;output=rdf')}"><xsl:apply-templates mode="writeMessage" select="$messages[@id='m11']/lta:unit[@xml:lang=$hl]"/></a>
	      </p>
	      <p>
		<a href="http://www.w3.org/2008/05/lta/">
		  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m5']/lta:unit[@xml:lang=$hl]"/>
		</a>
	      </p>
            </body>
          </html>
  </xsl:template>
  <xsl:template match="lta:notWellformed" mode="xhtmloutput">
    <li>
      <xsl:apply-templates mode="writeMessage" select="$messages[@id='m6']/lta:unit[@xml:lang=$hl]">
	<xsl:with-param name="variables">
	  <lta:var no="m6v1"><xsl:value-of select="@restTag"/></lta:var>
	  <lta:var no="m6v2"><xsl:value-of select="@potentialSubtags"/></lta:var>
	</xsl:with-param>
      </xsl:apply-templates>
    </li>
  </xsl:template>
  <xsl:template match="lta:*[not(name()='lta:notWellformed')]" mode="xhtmloutput">
    <li>
      <xsl:choose>
	<xsl:when test="not(*)">
	  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m9']/lta:unit[@xml:lang=$hl]">
	    <xsl:with-param name="variables">
	      <lta:var no="m9v1"><xsl:value-of select="."/></lta:var>
	      <lta:var no="m9v2"><xsl:value-of select="local-name(.)"/></lta:var>
	    </xsl:with-param>
	  </xsl:apply-templates>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m7']/lta:unit[@xml:lang=$hl]">
	    <xsl:with-param name="variables">
	      <lta:var no="m7v1"><xsl:value-of select="*/@su | */@ta"/></lta:var>
	      <lta:var no="m7v2"><xsl:value-of select="*/@ty"/></lta:var>
	      <lta:var no="m7v3"><xsl:value-of select="*/@ad"/></lta:var>
	    </xsl:with-param>
	  </xsl:apply-templates>
	  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m8']/lta:unit[@xml:lang=$hl]"/>
	  <ul>
	    <xsl:for-each select="*/lta:ds">
	      <li>
		<xsl:value-of select="."/>
	      </li>
	    </xsl:for-each>
	  </ul>
	</xsl:otherwise>
      </xsl:choose>
    </li>
  </xsl:template>
  <xsl:template match="h:*| @*" mode="writeMessage">
    <xsl:copy>
      <xsl:apply-templates select ="node() | @*" mode="writeMessage"/>
    </xsl:copy>
  </xsl:template>
  <!-- Template for variables in HTML output -->
  <xsl:template match="lta:var" mode="writeMessage">
    <xsl:param name="variables"/>
    <xsl:variable name="no" select="./@no"/>
    <xsl:value-of select="$variables/lta:var[@no=$no]"/>
  </xsl:template>
</xsl:stylesheet>
