<?xml version="1.0" encoding="UTF-8"?>
<!--
    W3C® SOFTWARE NOTICE AND LICENSE
    http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231

    This work (and included software, documentation such as READMEs, or other related items) is being provided by the copyright holders under the following license. By obtaining, using and/or copying this work, you (the licensee) agree that you have read, understood, and will comply with the following terms and conditions.

    Permission to copy, modify, and distribute this software and its documentation, with or without modification, for any purpose and without fee or royalty is hereby granted, provided that you include the following on ALL copies of the software and documentation or portions thereof, including modifications:

    1. The full text of this NOTICE in a location viewable to users of the redistributed or derivative work.
    2. Any pre-existing intellectual property disclaimers, notices, or terms and conditions. If none exist, the W3C Software Short Notice should be included (hypertext is preferred, text is permitted) within the body of any redistributed or derivative code.
    3. Notice of any changes or modifications to the files, including the date changes were made. (We recommend you provide URIs to the location from which the code is derived.)

    THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

    COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE OR DOCUMENTATION.

    The name and trademarks of copyright holders may NOT be used in advertising or publicity pertaining to the software without specific, written prior permission. Title to copyright in this software and any associated documentation will at all times remain with copyright holders.

    ____________________________________

    This formulation of W3C's notice and license became active on December 31 2002. This version removes the copyright ownership notice such that this license can be used with materials other than those owned by the W3C, reflects that ERCIM is now a host of the W3C, includes references to this specific dated version of the license, and removes the ambiguous grant of "use". Otherwise, this version is the same as the previous version and is written so as to preserve the Free Software Foundation's assessment of GPL compatibility and OSI's certification under the Open Source Definition. Please see our Copyright FAQ for common questions about using materials from our site, including specific terms and conditions for packages like libwww, Amaya, and Jigsaw. Other questions about this notice can be directed to site-policy@w3.org.
    
  -->

<!-- Language Tag Analyzer (LTA) - version 0.2. constraint-check.xsl
     For documentation, see http://www.w3.org/2008/05/lta/
  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
		xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/"
		xmlns:my="http://example.com/myns" xmlns:lta="http://www.w3.org/2008/05/lta/"
		xmlns="http://www.w3.org/1999/xhtml" xmlns:h="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="my saxon xs h lta">
  <!-- The subtag registry. Subtags: language, script, region, variant, 
       grandfathered, redundant-->
  <xsl:variable name="st-language" select="doc('lsr.xml')/lta:lsr/lta:lan"/>
  <xsl:variable name="st-extlang" select="doc('lsr.xml')/lta:lsr/lta:ext"/>
  <xsl:variable name="st-script" select="doc('lsr.xml')/lta:lsr/lta:scr"/>
  <xsl:variable name="st-region" select="doc('lsr.xml')/lta:lsr/lta:reg"/>
  <xsl:variable name="st-variant" select="doc('lsr.xml')/lta:lsr/lta:var"/>
  <xsl:variable name="st-grandfathered" select="
						doc('lsr.xml')/lta:lsr/lta:gra"/>
  <xsl:variable name="st-redundant" select="
					    doc('lsr.xml')/lta:lsr/lta:red"/>
  <!-- To copy everything to the output during constraints check -->
  <xsl:template match="node() | @*" mode="someConstraintsCheck">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="someConstraintsCheck">
        <xsl:with-param name="abnfCheckedLangtag" select="$abnfCheckedLangtag"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <!-- Language sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:language">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-language[@su[matches(.,concat('^',$st,'$'),'i')]]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Extlang part constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:extlang">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-extlang[@su[matches(.,concat('^',$st,'$'),'i')]]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Script sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:script">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-script[@su[matches(.,concat('^',$st,'$'),'i')]]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Region sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:region">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match" select="$st-region[@su[matches(.,concat('^',$st,'$'),'i')]]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Variant sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:variant">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match" select="$st-variant[@su[matches(.,concat('^',$st,'$'),'i')]]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Check for grandfathered and redundant tags -->
  <xsl:template mode="someConstraintsCheck" match="lta:irregular | lta:regular">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-grandfathered[@ta[matches(.,concat('^',$st,'$'),'i')] | $st-redundant/lta:tag[matches(.,concat('^',$st,'$'),'i')]]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template mode="someConstraintsCheck" match="lta:extension">
    <!--  Each singleton subtag MUST appear at most one time in each tag
          (other than as a private use subtag).  That is, singleton
          subtags MUST NOT be repeated.  For example, the tag "en-a-bbb-a-
          ccc" is invalid because the subtag 'a' appears twice.  Note that
          the tag "en-a-bbb-x-a-ccc" is valid because the second
          appearance of the singleton 'a' is in a private use sequence. -->
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:variable name="prefix" select="substring-before(.,'-')"/>
    <xsl:copy>
      <xsl:if
         test="
               count
               (
               $abnfCheckedLangtag//lta:extension[substring-before(.,'-') = $prefix]
               )		  
	       != 1
	       ">
        <xsl:attribute name="error">singleton-repetition '<xsl:value-of select="$prefix"/>'</xsl:attribute>
      </xsl:if>
      <xsl:value-of select="."/>
    </xsl:copy>
    <!-- tbd: more constraints -->
  </xsl:template>
</xsl:stylesheet>
