<?xml version="1.0" encoding="UTF-8"?>
<!--
    W3C® SOFTWARE NOTICE AND LICENSE
    http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231

    This work (and included software, documentation such as READMEs, or other related items) is being provided by the copyright holders under the following license. By obtaining, using and/or copying this work, you (the licensee) agree that you have read, understood, and will comply with the following terms and conditions.

    Permission to copy, modify, and distribute this software and its documentation, with or without modification, for any purpose and without fee or royalty is hereby granted, provided that you include the following on ALL copies of the software and documentation or portions thereof, including modifications:

    1. The full text of this NOTICE in a location viewable to users of the redistributed or derivative work.
    2. Any pre-existing intellectual property disclaimers, notices, or terms and conditions. If none exist, the W3C Software Short Notice should be included (hypertext is preferred, text is permitted) within the body of any redistributed or derivative code.
    3. Notice of any changes or modifications to the files, including the date changes were made. (We recommend you provide URIs to the location from which the code is derived.)

    THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

    COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE OR DOCUMENTATION.

    The name and trademarks of copyright holders may NOT be used in advertising or publicity pertaining to the software without specific, written prior permission. Title to copyright in this software and any associated documentation will at all times remain with copyright holders.

    ____________________________________

    This formulation of W3C's notice and license became active on December 31 2002. This version removes the copyright ownership notice such that this license can be used with materials other than those owned by the W3C, reflects that ERCIM is now a host of the W3C, includes references to this specific dated version of the license, and removes the ambiguous grant of "use". Otherwise, this version is the same as the previous version and is written so as to preserve the Free Software Foundation's assessment of GPL compatibility and OSI's certification under the Open Source Definition. Please see our Copyright FAQ for common questions about using materials from our site, including specific terms and conditions for packages like libwww, Amaya, and Jigsaw. Other questions about this notice can be directed to site-policy@w3.org.
    
  -->

<!-- Language Tag Analyzer (LTA) - version 0.2. abnf-check.xsl
     For documentation, see http://www.w3.org/2008/05/lta/
  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
		xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/"
		xmlns:my="http://example.com/myns" xmlns:lta="http://www.w3.org/2008/05/lta/"
		xmlns="http://www.w3.org/1999/xhtml" xmlns:h="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="my saxon xs h lta">
  <xsl:include href="abnf.xsl"/>
  <xsl:template name="abnf-check">
    <xsl:param name="inputlangtag"/>
    <!-- check wellformed-ness -->
    <lta:Language-Tag input="{$inputlangtag}">
      <xsl:choose>
        <!-- Testing irregular tags -->
        <xsl:when test="saxon:evaluate(my:constructTest($irregular,$langtag))">
          <lta:irregular>
            <xsl:value-of select="$langtag"/>
          </lta:irregular>
        </xsl:when>
        <!-- Testing regular tags -->
        <xsl:when test="saxon:evaluate(my:constructTest($regular,$langtag))">
          <lta:regular>
            <xsl:value-of select="$langtag"/>
          </lta:regular>
        </xsl:when>
        <!-- Testing privateuse tags -->
        <xsl:when test="saxon:evaluate(my:constructTest($privateuse,$langtag))">
          <lta:privateuse>
            <xsl:value-of select="$langtag"/>
          </lta:privateuse>
        </xsl:when>
        <xsl:otherwise>
          <!-- Call test of language sub tag -->
          <xsl:call-template name="languageTest">
            <xsl:with-param name="restTag" select="$langtag"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </lta:Language-Tag>
  </xsl:template>
  <!-- Template for test of language sub tag -->
  <xsl:template name="languageTest">
    <xsl:param name="restTag"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <!-- Testing registered language subtag -->
    <xsl:choose>
      <xsl:when test="saxon:evaluate(my:constructTest($registeredLanguageSubtag,$subTag))">
        <lta:language type="registered language subtag">
          <xsl:value-of select="$subTag"/>
        </lta:language>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="privateuse irregular regular"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="scriptTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
            </xsl:call-template>
          </xsl:when>
	</xsl:choose>
      </xsl:when>
      <!-- Testing reserved for future use -->
      <xsl:when test="saxon:evaluate(my:constructTest($reservedForFutureUse,$subTag))">
        <lta:language type="reserved for future use">
          <xsl:value-of select="$subTag"/>
        </lta:language>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="privateuse irregular regular"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="scriptTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
            </xsl:call-template>
          </xsl:when>
	</xsl:choose>
      </xsl:when>
      <!--  Testing language shortest ISO 639 code  -->
      <xsl:when test="saxon:evaluate(my:constructTest($languageShortestIso639,$subTag))">
        <lta:language type="shortest ISO 639 code">
          <xsl:value-of select="$subTag"/>
	</lta:language>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="privateuse irregular regular"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="extlangTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
            </xsl:call-template>  
	  </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <lta:notWellformed restTag="{$restTag}" potentialSubtags="langtag privateuse irregular regular"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="extlangTest">
    <xsl:param name="restTag"/>
    <!-- 1) check for extlang = 3ALPHA *2("-" 3ALPHA), 1)a) create @extlang="." and remove it (if present), apply script template with new rest ..., 2) apply script template with old rest. -->
    <xsl:choose>
      <xsl:when test="matches($restTag,concat('^',$extlang1,'$')) or matches($restTag,concat('^',$extlang1,'-.*'))">
	<xsl:variable name="extlangValue">
	  <xsl:choose>
	    <xsl:when test="matches($restTag,concat('^',$extlang3,'$')) or matches($restTag,concat('^',$extlang3,'-.*'))">
	      <xsl:value-of select="substring($restTag,1,11)"/>
	    </xsl:when>
	    <xsl:when test="matches($restTag,concat('^',$extlang2,'$')) or matches($restTag,concat('^',$extlang2,'-.*'))">
	      <xsl:value-of select="substring($restTag,1,7)"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="substring($restTag,1,3)"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:variable>
	<xsl:element name="lta:extlang">
	  <xsl:value-of select="$extlangValue"/>
	</xsl:element>
	<xsl:variable name="newRestTag" select="substring-after($restTag,concat($extlangValue,'-'))"/>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$extlangValue)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="script region variant extension privatuse"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
	    <xsl:call-template name="scriptTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
	    </xsl:call-template>       
	  </xsl:when>
	</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="scriptTest">
          <xsl:with-param name="restTag" select="$restTag"/>
	</xsl:call-template>       
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="scriptTest">
    <xsl:param name="restTag"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <!-- If a script is given, create output and call a template for region checking with
	 new rest. If no script is recognized, call a template for
	 region checking with same rest. 
      -->
    <xsl:choose>
      <xsl:when test="saxon:evaluate(my:constructTest($script,$subTag))">
        <lta:script>
          <xsl:value-of select="$subTag"/>
        </lta:script>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="region variant extension privatuse"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="regionTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
              <xsl:with-param name="potentialSubtags" select="''"/>
            </xsl:call-template>
          </xsl:when>
	</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="regionTest">
          <xsl:with-param name="restTag" select="$restTag"/>
          <xsl:with-param name="potentialSubtags" select="'script'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="regionTest">
    <xsl:param name="restTag"/>
    <xsl:param name="potentialSubtags"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <!-- If a region is given, create output and call a template for variant checking with
	 new rest. If no region is recognized, call a template for
	 variant checking with same rest.
      -->
    <xsl:choose>
      <xsl:when test="saxon:evaluate(my:constructTest($regionIso3166-1Code,$subTag))">
        <lta:region type="ISO 3166-1 code">
          <xsl:value-of select="$subTag"/>
        </lta:region>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="variant extension privatuse"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="variantTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
              <xsl:with-param name="potentialSubtags" select="''"/>
            </xsl:call-template>
          </xsl:when>
	</xsl:choose>
      </xsl:when>
      <xsl:when test="saxon:evaluate(my:constructTest($regionUnM49Code,$subTag))">
        <lta:region type="UN M.49 code">
          <xsl:value-of select="$subTag"/>
        </lta:region>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="variant extension privatuse"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="variantTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
              <xsl:with-param name="potentialSubtags" select="''"/>
            </xsl:call-template>
          </xsl:when>
	</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="variantTest">
          <xsl:with-param name="restTag" select="$restTag"/>
          <xsl:with-param name="potentialSubtags" select="concat($potentialSubtags, ' region')"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="variantTest">
    <xsl:param name="restTag"/>
    <xsl:param name="potentialSubtags"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <!-- If a variant is given, create output and call a template for another variant checking with
	 new rest. If no variant is recognized, call a template for
	 extension checking with same rest.
      -->
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <xsl:choose>
      <xsl:when
         test="saxon:evaluate(my:constructTest($variantType1,$subTag)) or saxon:evaluate(my:constructTest($variantType2,$subTag))">
        <lta:variant>
          <xsl:value-of select="$subTag"/>
        </lta:variant>
	<xsl:choose>
	  <xsl:when test="substring-after($restTag,$subTag)='-'">
	    <lta:notWellformed restTag="-" potentialSubtags="variant extension privatuse"/>
	  </xsl:when>
          <xsl:when test="$newRestTag!=''">
            <xsl:call-template name="variantTest">
              <xsl:with-param name="restTag" select="$newRestTag"/>
              <xsl:with-param name="potentialSubtags" select="''"/>
            </xsl:call-template>
          </xsl:when>
	</xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="extensionTest">
          <xsl:with-param name="restTag" select="$restTag"/>
          <xsl:with-param name="potentialSubtags" select="concat($potentialSubtags,' variant')"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="extensionTest">
    <xsl:param name="restTag"/>
    <xsl:param name="potentialSubtags"/>
    <xsl:variable name="subTag"
		  select="
			  substring-before($restTag,
			  replace($restTag,'^(([a-w]|[y-z]|[A-W]|[Y-Z]|[0-9])(-(([a-z]|[A-Z])|(\d)){2,8})+)','')
			  )"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <xsl:choose>
      <!-- Extension tag and some rest -->
      <xsl:when test="matches($subTag,'^([a-w]|[y-z]|[A-W]|[Y-Z]|[0-9])(-([a-z]|[A-Z]|\d){2,8})*')">
        <lta:extension>
          <xsl:value-of select="$subTag"/>
        </lta:extension>
        <xsl:call-template name="extensionTest">
          <xsl:with-param name="restTag" select="$newRestTag"/>
          <xsl:with-param name="potentialSubtags" select="''"/>
        </xsl:call-template>
      </xsl:when>
      <!-- Only one extension tag -->
      <xsl:when
         test="$subTag='' and matches($restTag,'^(([a-w]|[y-z]|[A-W]|[Y-Z]|[0-9])(-(([a-z]|[A-Z])|(\d)){2,8})+)')">
        <lta:extension>
          <xsl:value-of select="$restTag"/>
        </lta:extension>
      </xsl:when>
      <!-- No extension tag, check for private use -->
      <xsl:when test="saxon:evaluate(my:constructTest($privateuse,$restTag))">
        <lta:privateuse>
          <xsl:value-of select="$restTag"/>
        </lta:privateuse>
      </xsl:when>
      <xsl:otherwise>
        <lta:notWellformed restTag="{$restTag}">
          <xsl:attribute name="potentialSubtags"
			 select="concat($potentialSubtags,' extension privatuse ')"/>
        </lta:notWellformed>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
