<?xml version="1.0" encoding="UTF-8"?>
<!--
    W3C® SOFTWARE NOTICE AND LICENSE
    http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231

    This work (and included software, documentation such as READMEs, or other related items) is being provided by the copyright holders under the following license. By obtaining, using and/or copying this work, you (the licensee) agree that you have read, understood, and will comply with the following terms and conditions.

    Permission to copy, modify, and distribute this software and its documentation, with or without modification, for any purpose and without fee or royalty is hereby granted, provided that you include the following on ALL copies of the software and documentation or portions thereof, including modifications:

    1. The full text of this NOTICE in a location viewable to users of the redistributed or derivative work.
    2. Any pre-existing intellectual property disclaimers, notices, or terms and conditions. If none exist, the W3C Software Short Notice should be included (hypertext is preferred, text is permitted) within the body of any redistributed or derivative code.
    3. Notice of any changes or modifications to the files, including the date changes were made. (We recommend you provide URIs to the location from which the code is derived.)

    THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

    COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE OR DOCUMENTATION.

    The name and trademarks of copyright holders may NOT be used in advertising or publicity pertaining to the software without specific, written prior permission. Title to copyright in this software and any associated documentation will at all times remain with copyright holders.

    ____________________________________

    This formulation of W3C's notice and license became active on December 31 2002. This version removes the copyright ownership notice such that this license can be used with materials other than those owned by the W3C, reflects that ERCIM is now a host of the W3C, includes references to this specific dated version of the license, and removes the ambiguous grant of "use". Otherwise, this version is the same as the previous version and is written so as to preserve the Free Software Foundation's assessment of GPL compatibility and OSI's certification under the Open Source Definition. Please see our Copyright FAQ for common questions about using materials from our site, including specific terms and conditions for packages like libwww, Amaya, and Jigsaw. Other questions about this notice can be directed to site-policy@w3.org.
    
  -->

<!-- Language Tag Analyzer (LTA) - version 0.1
     For documentation, see http://www.w3.org/2008/05/lta/
  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
		xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/"
		xmlns:my="http://example.com/myns" xmlns:lta="http://www.w3.org/2008/05/lta/"
		xmlns="http://www.w3.org/1999/xhtml" xmlns:h="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="my saxon xs h lta">
  <xsl:import href="verbatim.xsl"/>
  <!--  tbd: <xsl:import href="rdfoutput.xsl"/>
	<xsl:import href="htmloutput.xsl"/>-->
  <!-- The input language tag to be analyzed -->
  <xsl:param name="inputlangtag"/>
  <xsl:param name="output">html</xsl:param>
  <xsl:param name="langtag" select="lower-case($inputlangtag)"/>
  <xsl:param name="uiLanguage">en</xsl:param>
  <xsl:output indent="yes" method="xhtml" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	      doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" name="xhtmloutput"
	      encoding="UTF-8"/>
  <xsl:output indent="yes" method="xml" name="xmloutput" encoding="UTF-8"/>
  <xsl:output indent="yes" encoding="UTF-8" method="text" name="rdf"/>
  <!-- The file with localized messages for HTML output -->
  <xsl:variable name="messages" select="doc('messages.xml')/lta:messages/lta:message"/>
  <!-- The subtag registry. Subtags: language, script, region, variant, 
       grandfathered, redundant-->
  <xsl:variable name="st-language" select="doc('lsr.xml')/lta:lsr/lta:language"/>
  <xsl:variable name="st-script" select="doc('lsr.xml')/lta:lsr/lta:script"/>
  <xsl:variable name="st-region" select="doc('lsr.xml')/lta:lsr/lta:region"/>
  <xsl:variable name="st-variant" select="doc('lsr.xml')/lta:lsr/lta:variant"/>
  <xsl:variable name="st-grandfathered" select="
						doc('lsr.xml')/lta:lsr/lta:grandfathered"/>
  <xsl:variable name="st-redundant" select="
					    doc('lsr.xml')/lta:lsr/lta:redundant"/>
  <!-- The ABNF from the revision of RFC 4646 - to be updated! -->
  <xsl:variable name="ALPHA" select="'([a-z]|[A-Z])'"/>
  <xsl:variable name="DIGIT" select="'(\d)'"/>
  <xsl:variable name="alphanum" select="concat('(',$ALPHA,'|',$DIGIT,')')"/>
  <xsl:variable name="privateuse" select="concat('x(-',$alphanum,'{1,8})+')"/>
  <!-- tbd: depending on happens with RFC 4646bis we use this: ...
       <xsl:variable name="irregularAbnf" select="concat(
						  $ALPHA,'{1,8}','(-',$alphanum,'{2,8}){1,2}')"/>
       <xsl:variable name="irregular"
		     select="concat('((en-GB-oed)|(i-ami)|(i-bnn)|(i-default)|(i-enochian)|(i-hak)|(i-klingon)|(i-lux)|(i-mingo)|(i-navajo)|(i-pwn)|(i-tao)|(i-tay)|(i-tsu)|(no-bok)|(no-nyn)|(sgn-BE-FR)|(sgn-BE-NL)|(sgn-CH-DE)|(zh-cmn)|(zh-cmn-Hans)|(zh-cmn-Hant)|(zh-gan)|(zh-min)|(zh-min-nan)|(zh-wuu)|(zh-yue)|(',$irregularAbnf,'))')"/>
       or this: -->
  <xsl:variable name="irregular"
		select="lower-case('((en-GB-oed)|(i-ami)|(i-bnn)|(i-default)|(i-enochian)|(i-hak)|(i-klingon)|(i-lux)|(i-mingo)|(i-navajo)|(i-pwn)|(i-tao)|(i-tay)|(i-tsu)|(no-bok)|(no-nyn)|(sgn-BE-FR)|(sgn-BE-NL)|(sgn-CH-DE)|(zh-cmn)|(zh-cmn-Hans)|(zh-cmn-Hant)|(zh-gan)|(zh-min)|(zh-min-nan)|(zh-wuu)|(zh-yue))')"/>
  <xsl:variable name="languageShortestIso639" select="concat($ALPHA,'{2,3}')"/>
  <xsl:variable name="reservedForFutureUse" select="concat($ALPHA,'{4}')"/>
  <xsl:variable name="registeredLanguageSubtag" select="concat($ALPHA,'{5,8}')"/>
  <xsl:variable name="script" select="concat($ALPHA,'{4}')"/>
  <xsl:variable name="regionIso3166-1Code" select="concat($ALPHA,'{2}')"/>
  <xsl:variable name="regionUnM49Code" select="concat($DIGIT,'{3}')"/>
  <xsl:variable name="variantType1" select="concat($alphanum,'{5,8}')"/>
  <xsl:variable name="variantType2" select="concat($DIGIT,'(',$alphanum,'){3}')"/>
  <xsl:variable name="singleton" select="'[a-w]|[y-z]|[A-W]|[Y-Z]|[0-9]'"/>
  <xsl:variable name="extension" select="concat('(',$singleton,'(-',$alphanum,'{2,8})+)+')"/>
  <!-- Function to construct subtag test. Input is a regex from the ABNF and the actual subtag (or complete tag in case of privateuse and irregular) to be tested. -->
  <xsl:function name="my:constructTest">
    <xsl:param name="regex"/>
    <xsl:param name="subtag"/>
    <xsl:variable name="part1">matches('</xsl:variable>
    <xsl:variable name="part2">','^</xsl:variable>
    <xsl:variable name="part3">$')</xsl:variable>
    <xsl:value-of select="concat($part1,$subtag,$part2,$regex,$part3)"/>
  </xsl:function>
  <!-- Function to get a subtag, used not for irregular or privateuse tags -->
  <xsl:function name="my:getSubtag">
    <xsl:param name="restTag"/>
    <xsl:choose>
      <xsl:when test="contains($restTag,'-')">
        <xsl:value-of select="substring-before($restTag,'-')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$restTag"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:template match="/">
    <!-- Step 1: check wellformed-ness -->
    <xsl:variable name="abnfCheckedLangtag">
      <lta:Language-Tag input="{$inputlangtag}">
        <xsl:choose>
          <!-- Testing irregular tags -->
          <xsl:when test="saxon:evaluate(my:constructTest($irregular,$langtag))">
            <lta:irregular>
              <xsl:value-of select="$langtag"/>
            </lta:irregular>
          </xsl:when>
          <!-- Testing privateuse tags -->
          <xsl:when test="saxon:evaluate(my:constructTest($privateuse,$langtag))">
            <lta:privateuse>
              <xsl:value-of select="$langtag"/>
            </lta:privateuse>
          </xsl:when>
          <xsl:otherwise>
            <!-- Call test of language sub tag -->
            <xsl:call-template name="languageTest">
              <xsl:with-param name="restTag" select="$langtag"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </lta:Language-Tag>
    </xsl:variable>
    <!-- Step 2: check registry and other constraints on wellformed language tag -->
    <xsl:variable name="constrainedCheckedLanguagetag">
      <xsl:apply-templates select="$abnfCheckedLangtag" mode="someConstraintsCheck">
        <xsl:with-param name="abnfCheckedLangtag" select="$abnfCheckedLangtag"/>
      </xsl:apply-templates>
    </xsl:variable>
    <!-- Step 3: choose output format: HTML, XML or RDF -->
    <xsl:choose>
      <xsl:when test="$output='xml'">
        <xsl:result-document format="xmloutput">
          <xsl:copy-of select="$constrainedCheckedLanguagetag"/>
        </xsl:result-document>
      </xsl:when>
      <xsl:when test="$output='rdf'">
        <xsl:result-document format="rdf">
          <xsl:apply-templates select="$constrainedCheckedLanguagetag" mode="rdf"/>
        </xsl:result-document>
      </xsl:when>
      <xsl:otherwise>
        <xsl:result-document format="xhtmloutput" exclude-result-prefixes="h lta">
          <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
              <title>Language Tag Analyzer (LTA) - Result</title>
              <style type="text/css"> *.element { color: #800080; font-weight: bold;} *.attribute {
                color: black; font-weight: bold;} *.aval { color: #0080FF; font-weight: normal;}
              </style>
            </head>
            <body>
              <h1>
		<xsl:apply-templates mode="writeMessage" select="$messages[@id='m1']/lta:unit[@xml:lang=$uiLanguage]"/>
	      </h1>
              <p>
		<xsl:apply-templates mode="writeMessage" select="$messages[@id='m2']/lta:unit[@xml:lang=$uiLanguage]">
		  <xsl:with-param name="variables">
		    <lta:var no="m2v1"><xsl:value-of  select="$inputlangtag"/></lta:var>
		  </xsl:with-param>
		</xsl:apply-templates>
	      </p>
              <p><xsl:apply-templates mode="writeMessage" select="$messages[@id='m3']/lta:unit[@xml:lang=$uiLanguage]"/></p>
	      <p>
		<xsl:apply-templates mode="writeMessage" select="$messages[@id='m4']/lta:unit[@xml:lang=$uiLanguage]">
		  <xsl:with-param name="variables">
		    <lta:var no="m4v1"><xsl:value-of  select="count($constrainedCheckedLanguagetag/*/*)"/></lta:var>
		  </xsl:with-param>
		</xsl:apply-templates>
	      </p>
	      <ul>
		<xsl:apply-templates select="$constrainedCheckedLanguagetag/*/*" mode="xhtmloutput"/>
	      </ul>
	      <!-- Not used anymore ... :
		   <pre>
                     <xsl:apply-templates select="$constrainedCheckedLanguagetag" mode="verbatim"/>
		   </pre>
		   -->
	      <p>
		<a href="{concat('http://www.w3.org/2008/05/lta/language-tags/xml/',$inputlangtag)}"><xsl:apply-templates mode="writeMessage" select="$messages[@id='m10']/lta:unit[@xml:lang=$uiLanguage]"/></a>
		<xsl:text> </xsl:text>
		<a href="{concat('http://www.w3.org/2008/05/lta/language-tags/rdf/',$inputlangtag)}"><xsl:apply-templates mode="writeMessage" select="$messages[@id='m11']/lta:unit[@xml:lang=$uiLanguage]"/></a>
	      </p>
	      <p>
		<a href="http://www.w3.org/2008/05/lta/">
		  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m5']/lta:unit[@xml:lang=$uiLanguage]"/>
		</a>
	      </p>
            </body>
          </html>
        </xsl:result-document>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="lta:notWellformed" mode="xhtmloutput">
    <li>
      <xsl:apply-templates mode="writeMessage" select="$messages[@id='m6']/lta:unit[@xml:lang=$uiLanguage]">
	<xsl:with-param name="variables">
	  <lta:var no="m6v1"><xsl:value-of select="@restTag"/></lta:var>
	  <lta:var no="m6v2"><xsl:value-of select="@potentialSubtags"/></lta:var>
	</xsl:with-param>
      </xsl:apply-templates>
    </li>
  </xsl:template>
  <xsl:template match="lta:*[not(name()='lta:notWellformed')]" mode="xhtmloutput">
    <li>
      <xsl:choose>
	<xsl:when test="not(*)">
	  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m9']/lta:unit[@xml:lang=$uiLanguage]">
	    <xsl:with-param name="variables">
	      <lta:var no="m9v1"><xsl:value-of select="."/></lta:var>
	      <lta:var no="m9v2"><xsl:value-of select="local-name(.)"/></lta:var>
	    </xsl:with-param>
	  </xsl:apply-templates>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m7']/lta:unit[@xml:lang=$uiLanguage]">
	    <xsl:with-param name="variables">
	      <lta:var no="m7v1"><xsl:value-of select="lta:tag | lta:subtag"/></lta:var>
	      <lta:var no="m7v2"><xsl:value-of select="lta:type"/></lta:var>
	      <lta:var no="m7v3"><xsl:value-of select="lta:added"/></lta:var>
	    </xsl:with-param>
	  </xsl:apply-templates>
	  <xsl:apply-templates mode="writeMessage" select="$messages[@id='m8']/lta:unit[@xml:lang=$uiLanguage]"/>
	  <ul>
	    <xsl:for-each select="lta:desc">
	      <li>
		<xsl:value-of select="."/>
	      </li>
	    </xsl:for-each>
	  </ul>
	</xsl:otherwise>
      </xsl:choose>
    </li>
  </xsl:template>
  <!-- 
       <lta:language type="shortest ISO 639 code">
	 <lta:type>language</lta:type>
	 <lta:subtag>de</lta:subtag>
	 <lta:desc>German</lta:desc>
	 <lta:added>2005-10-16</lta:added>
	 <lta:suppressScript>Latn</lta:suppressScript>
       </lta:language>
       <lta:region type="ISO 3166-1 code">
	 <lta:type>region</lta:type>
	 <lta:subtag>DE</lta:subtag>
	 <lta:desc>Germany</lta:desc>
	 <lta:added>2005-10-16</lta:added>
       </lta:region>
       <lta:variant>
	 <lta:type>variant</lta:type>
	 <lta:subtag>1901</lta:subtag>
	 <lta:desc>Traditional German orthography</lta:desc>
	 <lta:added>2005-10-16</lta:added>
	 <lta:deprecated>de</lta:deprecated>
       </lta:variant>
       </lta:Language-Tag>
    -->
  <xsl:template match="h:*| @*" mode="writeMessage">
    <xsl:copy>
      <xsl:apply-templates select ="node() | @*" mode="writeMessage"/>
    </xsl:copy>
  </xsl:template>
  <!-- Template for variables in HTML output -->
  <xsl:template match="lta:var" mode="writeMessage">
    <xsl:param name="variables"/>
    <xsl:variable name="no" select="./@no"/>
    <xsl:value-of select="$variables/lta:var[@no=$no]"/>
  </xsl:template>
  <!-- Template for test of language sub tag -->
  <xsl:template name="languageTest">
    <xsl:param name="restTag"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <xsl:choose>
      <!-- Testing registered language subtag -->
      <xsl:when test="saxon:evaluate(my:constructTest($registeredLanguageSubtag,$subTag))">
        <lta:language type="registered language subtag">
          <xsl:value-of select="$subTag"/>
        </lta:language>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="scriptTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <!-- Testing reserved for future use -->
      <xsl:when test="saxon:evaluate(my:constructTest($reservedForFutureUse,$subTag))">
        <lta:language type="reserved for future use">
          <xsl:value-of select="$subTag"/>
        </lta:language>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="scriptTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <!--  Testing language shortest ISO 639 code  -->
      <xsl:when test="saxon:evaluate(my:constructTest($languageShortestIso639,$subTag))">
        <lta:language type="shortest ISO 639 code">
          <xsl:value-of select="$subTag"/>
        </lta:language>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="scriptTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <lta:notWellformed restTag="{$restTag}" potentialSubtags="langtag privateuse irregular"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="scriptTest">
    <xsl:param name="restTag"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <!-- If a script is given, create output and call a template for region checking with
	 new rest. If no script is recognized, call a template for
	 region checking with same rest. 
      -->
    <xsl:choose>
      <xsl:when test="saxon:evaluate(my:constructTest($script,$subTag))">
        <lta:script>
          <xsl:value-of select="$subTag"/>
        </lta:script>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="regionTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
            <xsl:with-param name="potentialSubtags" select="''"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="regionTest">
          <xsl:with-param name="restTag" select="$restTag"/>
          <xsl:with-param name="potentialSubtags" select="'script'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="regionTest">
    <xsl:param name="restTag"/>
    <xsl:param name="potentialSubtags"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <!-- If a region is given, create output and call a template for variant checking with
	 new rest. If no region is recognized, call a template for
	 variant checking with same rest.
      -->
    <xsl:choose>
      <xsl:when test="saxon:evaluate(my:constructTest($regionIso3166-1Code,$subTag))">
        <lta:region type="ISO 3166-1 code">
          <xsl:value-of select="$subTag"/>
        </lta:region>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="variantTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
            <xsl:with-param name="potentialSubtags" select="''"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:when test="saxon:evaluate(my:constructTest($regionUnM49Code,$subTag))">
        <lta:region type="UN M.49 code">
          <xsl:value-of select="$subTag"/>
        </lta:region>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="variantTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
            <xsl:with-param name="potentialSubtags" select="''"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="variantTest">
          <xsl:with-param name="restTag" select="$restTag"/>
          <xsl:with-param name="potentialSubtags" select="concat($potentialSubtags, ' region')"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="variantTest">
    <xsl:param name="restTag"/>
    <xsl:param name="potentialSubtags"/>
    <xsl:variable name="subTag" select="my:getSubtag($restTag)"/>
    <!-- If a variant is given, create output and call a template for another variant checking with
	 new rest. If no variant is recognized, call a template for
	 extension checking with same rest.
      -->
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <xsl:choose>
      <xsl:when
         test="saxon:evaluate(my:constructTest($variantType1,$subTag)) or saxon:evaluate(my:constructTest($variantType2,$subTag))">
        <lta:variant>
          <xsl:value-of select="$subTag"/>
        </lta:variant>
        <xsl:if test="$newRestTag!=''">
          <xsl:call-template name="variantTest">
            <xsl:with-param name="restTag" select="$newRestTag"/>
            <xsl:with-param name="potentialSubtags" select="''"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="extensionTest">
          <xsl:with-param name="restTag" select="$restTag"/>
          <xsl:with-param name="potentialSubtags" select="concat($potentialSubtags,' variant')"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="extensionTest">
    <xsl:param name="restTag"/>
    <xsl:param name="potentialSubtags"/>
    <xsl:variable name="subTag"
		  select="
			  substring-before($restTag,
			  replace($restTag,'^(([a-w]|[y-z]|[A-W]|[Y-Z]|[0-9])(-(([a-z]|[A-Z])|(\d)){2,8})+)','')
			  )"/>
    <xsl:variable name="newRestTag" select="substring-after($restTag,concat($subTag,'-'))"/>
    <xsl:choose>
      <!-- Extension tag and some rest -->
      <xsl:when test="matches($subTag,'^([a-w]|[y-z]|[A-W]|[Y-Z]|[0-9])(-([a-z]|[A-Z]|\d){2,8})*')">
        <lta:extension>
          <xsl:value-of select="$subTag"/>
        </lta:extension>
        <xsl:call-template name="extensionTest">
          <xsl:with-param name="restTag" select="$newRestTag"/>
          <xsl:with-param name="potentialSubtags" select="''"/>
        </xsl:call-template>
      </xsl:when>
      <!-- Only one extension tag -->
      <xsl:when
         test="$subTag='' and matches($restTag,'^(([a-w]|[y-z]|[A-W]|[Y-Z]|[0-9])(-(([a-z]|[A-Z])|(\d)){2,8})+)')">
        <lta:extension>
          <xsl:value-of select="$restTag"/>
        </lta:extension>
      </xsl:when>
      <!-- No extension tag, check for private use -->
      <xsl:when test="saxon:evaluate(my:constructTest($privateuse,$restTag))">
        <lta:privateuse>
          <xsl:value-of select="$restTag"/>
        </lta:privateuse>
      </xsl:when>
      <xsl:otherwise>
        <lta:notWellformed restTag="{$restTag}">
          <xsl:attribute name="potentialSubtags"
			 select="concat($potentialSubtags,' extension privatuse ')"/>
        </lta:notWellformed>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- To copy everything to the output during constraints check -->
  <xsl:template match="node() | @*" mode="someConstraintsCheck">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="someConstraintsCheck">
        <xsl:with-param name="abnfCheckedLangtag" select="$abnfCheckedLangtag"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <!-- Language sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:language">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-language/lta:subtag[matches(.,concat('^',$st,'$'),'i')]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match/../*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Script sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:script">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-script/lta:subtag[matches(.,concat('^',$st,'$'),'i')]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match/../*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Region sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:region">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match" select="$st-region/lta:subtag[matches(.,concat('^',$st,'$'),'i')]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match/../*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Variant sub tag constraints check -->
  <xsl:template mode="someConstraintsCheck" match="lta:variant">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match" select="$st-variant/lta:subtag[matches(.,concat('^',$st,'$'),'i')]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match/../*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="error">Sub tag not in registry.</xsl:attribute>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <!-- Check for grandfathered and redundant tags -->
  <xsl:template mode="someConstraintsCheck" match="lta:irregular">
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:copy>
      <xsl:copy-of select="@type"/>
      <xsl:variable name="st" select="."/>
      <xsl:variable name="match"
		    select="
			    $st-grandfathered/lta:tag[matches(.,concat('^',$st,'$'),'i')] | $st-redundant/lta:tag[matches(.,concat('^',$st,'$'),'i')]"/>
      <xsl:choose>
        <xsl:when test="$match">
          <xsl:copy-of select="$match/../*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template mode="someConstraintsCheck" match="lta:extension">
    <!--  Each singleton subtag MUST appear at most one time in each tag
          (other than as a private use subtag).  That is, singleton
          subtags MUST NOT be repeated.  For example, the tag "en-a-bbb-a-
          ccc" is invalid because the subtag 'a' appears twice.  Note that
          the tag "en-a-bbb-x-a-ccc" is valid because the second
          appearance of the singleton 'a' is in a private use sequence. -->
    <xsl:param name="abnfCheckedLangtag"/>
    <xsl:variable name="prefix" select="substring-before(.,'-')"/>
    <xsl:copy>
      <xsl:if
         test="
               count
               (
               $abnfCheckedLangtag//lta:extension[substring-before(.,'-') = $prefix]
               )		  
	       != 1
	       ">
        <xsl:attribute name="error">Repetition of singleton for extensions not
          allowed.</xsl:attribute>
      </xsl:if>
      <xsl:value-of select="."/>
    </xsl:copy>
    <!-- tbd: more constraints -->
  </xsl:template>
  <!-- RDF output -->
  <xsl:template mode="rdf" match="lta:Language-Tag">
    <xsl:text>@prefix lta: &lt;http://www.w3.org/2008/05/lta/&gt; .&#xA;@prefix ltainstance: &lt;http://www.w3.org/2008/05/lta/instance&gt; .&#xA;@prefix rdf: &lt;http://www.w3.org/1999/02/22-rdf-syntax-ns#&gt; .&#xA;</xsl:text>
    <xsl:value-of select="concat('ltainstance:',$inputlangtag)"/>
    <xsl:text>&#x20;rdf:type lta:languagetag.&#xA;</xsl:text>
    <xsl:apply-templates mode="rdf"/>
  </xsl:template>
  <xsl:template mode="rdf" match="*">
    <xsl:value-of
       select="concat('ltalinstance:',lta:subtag,'&#x20;','rdf:type&#x20;',name(),'_subtag.&#xA;')"/>
    <xsl:for-each select="*[not(name()='lta:subtag' or name()='lta:type')]">
      <xsl:value-of select="concat('ltainstance:',parent::*/lta:subtag,'&#x20;')"/>
      <xsl:value-of select="concat
			    (name(),'&#x20;','&#x22;',.,'&#x22;.')"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="lta:notWellformed" mode="rdf">
    <xsl:value-of
       select="concat
	       ('ltainstance:',@restTag,'&#x20;rdf:type&#x20;lta:notWellformed.')"/>
  </xsl:template>
</xsl:stylesheet>
