import java.io.StringReader;

public class XPathSample {

    public static void main(String[] args) throws ParseException {
        // There's also API's for a InputStream, but you're better off
        // using a reader, since the reader should deliver properly
        // decoded characters.
        StringReader sr = new StringReader("foo/baz[3]");
        XPath parser = new XPath(sr);
        SimpleNode root = parser.XPath2();

        recursiveProcessingIllustration(root);
        System.out.println();
        System.out.println("=========");

        // Diagnostics dump.
        root.dump("->  ");
    }

    /**
     * Generally show how to process the tree.
     * @param node
     */
    static void recursiveProcessingIllustration(SimpleNode node) {
        switch (node.id) {
        case XPathTreeConstants.JJTQNAME:
            System.out.print("qname: ");
            System.out.print(node.getValue());
            break;

        case XPathTreeConstants.JJTABBREVFORWARDSTEP:
            System.out.print("child::");
            break;

        // etc.

        default:
            System.out.print(XPathTreeConstants.jjtNodeName[node.id]);
        }

        for (int i = 0; i < node.jjtGetNumChildren(); i++) {
            SimpleNode child = (SimpleNode) node.jjtGetChild(i);
            System.out.print(", ");
            recursiveProcessingIllustration(child);
        }
    }
}
