do insert <year>2005</year>
    after fn:doc("bib.xml")/books/book[1]/publisher %%%

do insert $new-police-report
   as last into fn:doc("insurance.xml")/policies
      /policy[id = $pid]
      /driver[license = $license]
      /accident[date = $accdate]
      /police-reports %%%

do delete fn:doc("bib.xml")/books/book[1]/author[last()] %%%

do delete /email/message
     [fn:currentDate() - date > xdt:dayTimeDuration("P365D")] %%%

do replace fn:doc("bib.xml")/books/book[1]/publisher
with fn:doc("bib.xml")/books/book[2]/publisher %%%

do replace value of fn:doc("bib.xml")/books/book[1]/price
with fn:doc("bib.xml")/books/book[1]/price * 1.1 %%%

do rename fn:doc("bib.xml")/books/book[1]/author[1]
as "principal-author" %%%

do rename fn:doc("bib.xml")/books/book[1]/author[1]
as $newname %%%

for $e in //employee[skill = "Java"]
return
   transform 
      copy $je := $e
      modify $je/salary
      return $je %%%

for $p in /inventory/part
let $deltap := $changes/part[partno eq $p/partno]
return do replace value of $p/quantity
      with $p/quantity + $deltap/quantity %%%

if ($e/@last-updated)
then do replace value of $e/last-updated with fn:currentDate()
else do insert attribute last-updated {fn:currentDate()} into $e %%%

let $q := /inventory/item[serialno = "123456"]/quantity
return do
   replace value of $q with ( ),
   do insert attribute xsi:nil {"true"} into $q %%%

for $e in //employee
return 
   if ($e/sales > $e/quota
       and fn:currentDate() - $e/last-raise 
                > xdt:dayTimeDuration("P365D"))
   then 
      (do replace value of $e/salary with $e/salary * 1.1,
       do replace value of $e/last-raise with fn:currentDate(),
       $e/name)
   else ( ) %%%

declare updating function 
   upsert($e as element(), 
          $an as xs:QName, 
          $av as xdt:anyAtomicType) 
      as element()
   {
   let $ea := $e/attribute()[fn:node-name(.) = $an]
   return
      if (fn:empty($ea))
      then do insert attribute {$an} {$av} into $e
      else do replace value of $ea with $av
   };
   foo





