(: parse tests :)

for $b in /books/book
where $b/title ftcontains ("dog" with stemming) && "cat" 
return $b/author
%%%

/books/book[title ftcontains ("dog" with stemming) && "cat"]/author
%%%
for $b score $s 
    in /books/book[content ftcontains "web site" && "usability" 
                   and .//chapter/title ftcontains "testing"]
return $s

%%%
for $b score $s 
    in /books/book[content ftcontains "web site" && "usability"]
where $s > 0.5
order by $s descending
return <result>  
          <title> {$b//title} </title> 
          <score> {$s} </score> 
       </result>

%%%
for $b in /books/book[.//chapter/title ftcontains "testing"]
let score $s := $b/content ftcontains "web site" && "usability" 
order by $s descending
return <result score="{$s}">{$b}</result>

%%%
for $b in /books/book
let score $s := $b/content ftcontains ("web site" weight 0.2)
                                  && ("usability" weight 0.8)
return <result score="{$s}">{$b}</result>

%%%/book[@number="1" and ./title ftcontains "Expert"]
%%%/book[@number="1" and ./title ftcontains "Expert Reviews"]
%%%/book[@number="1" and ./title ftcontains {"Expert",
"Reviews"} all]
%%%/book[@number="1"]//p ftcontains "Web Site Usability"
%%%for $book in /book[.//author ftcontains "Marigold"] 
let score $score := $book/title ftcontains "Web Site Usability" 
where $score > 0.8 
order by $score descending
return $book/@number
%%% /book[.//author ftcontains "Millicent" ||
"Voltaire"] 
%%%/book[@number="1"]/title ftcontains ("usability" && "testing")
%%%/book/author ftcontains "Millicent" && "Montana"
%%%/book ftcontains "usability" not in "usability
testing"
%%%/book[. ftcontains ! "usability"]
%%%/book ftcontains "information" &&
"retrieval" && ! "information retrieval"
%%%/book[. ftcontains "web site usability" && 
!"usability testing"]
%%%/book/title ftcontains ("web site" && "usability")
ordered 
%%%/book[@number="1"]/title ftcontains ("Montana" &&
"Millicent") ordered 
%%%/book ftcontains "usability"
&& "Marigold" same sentence
%%%/book ftcontains "usability"
&& "Marigold" different sentence
%%%/book[. ftcontains "usability" && "testing"
same paragraph] 
%%%/book[. ftcontains "site" && "errors"
same sentence] 
%%%/book ftcontains ("information" &&
"retrieval") not in ("information" && "retrieval" 
distance at least 11 words)

%%%/book ftcontains "web" && "site" &&
"usability" distance at most 2 words
%%%/book[. ftcontains "web site"
&& "usability" distance at most 1 words]/title 
%%%/book/title ftcontains "web" && "site"
&& "usability" window 5 words
%%%/book ftcontains ("web" && "site" ordered)
&& ("usability" || "testing") window 10 words
%%%/book//title ftcontains "web site" &&
"usability" window 3 words
%%%/book[@number="1" and . ftcontains "efficient" 
&& ! "and" window 3 words]
%%%/book[. ftcontains "usability" occurs at least 2 times]/@number
%%%/book[@number="1" and title ftcontains "usability" ||
"testing" occurs at most 3 times] 
%%%/book ftcontains "usability" occurs at least 2 times

%%%/books//title[. ftcontains "improving the usability
of a web site" at start]
%%%/books//p[. ftcontains "propagat*" && "few
errors" distance at most 2 words at end]
%%%/books//note[. ftcontains "this site has been
approved by the web site users association" entire content]
%%%/book/title ftcontains "usability" 
%%%/book/title ftcontains "usability" case insensitive 
    diacritics insensitive 
    without stemming without thesaurus  
    without stop words language "none" without wildcards
%%%/book[@number="1"]/title ftcontains "Usability" lowercase 
%%%/book[@number="1"]/title ftcontains "usability" 
case insensitive

%%%/book[@number="1"]//editor ftcontains "Vera" with diacritics 
%%%/book[@number="1"]/editors ftcontains "Vra" without diacritics 
%%%/book[@number="1"]/title ftcontains "improve" with stemming 
%%%count(.//book/content ftcontains "duties" with
thesaurus at "http://bstore1.example.com/UsabilityThesaurus.xml"
relationship "synonyms")>0
%%%doc("http://bstore1.example.com/full-text.xml")
/books/book[count(./content ftcontains "web site components" with
thesaurus at "http://bstore1.example.com/UsabilityThesaurus.xml"
relationship "narrower terms" at most 2 levels)>0]
%%%doc("http://bstore1.example.com/full-text.xml")
/books/book[count(. ftcontains "Merrygould" with thesaurus at
"http://bstore1.example.com/UsabilitySoundex.xml" relationship
"sounds like")>0]
%%%/book[@number="1"]//p ftcontains "propagation of errors"
with stemming with stop words ("a", "the", "of") 
%%%/book[@number="1"]//p ftcontains "propagation of errors" 
with stemming without stop words
%%%
doc("http://bstore1.example.com/full-text.xml")
/books/book[count(.//content ftcontains "planning then 
conducting" with stop words at 
"http://bstore1.example.com/StopWordList.xml")>0]

%%%
doc("http://bstore1.example.com/full-text.xml")
/books/book[count(.//content ftcontains "planning then conducting"
with stop words at "http://bstore1.example.com/StopWordList.xml"
except ("the then"))>0]

%%%/book[@number="1"]//editor ftcontains "salon de the"
with default stop words language "fr"
%%%/book[@number="1"]/title ftcontains "improv.*" with
wildcards
%%%/book[@number="1"]/title ftcontains ".?site" with
wildcards
%%%/book[@number="1"]/p ftcontains "w.ll" with
wildcards
%%%