<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:g="http://www.w3.org/2001/03/XPath/grammar">
	<xsl:output method="text" indent="yes" xmlns:xalan="http://xml.apache.org/xalan" xalan:indent-amount="2"
		doctype-system="grammar.dtd"/>
		
	<!-- xsl:output method="xml"/ -->
	<xsl:strip-space elements="*"/>
	<!-- workaround for Xalan bug. -->
	<xsl:preserve-space elements="g:char"/>
	<xsl:key name="ref" match="g:token|g:production" use="@name"/>
	<xsl:key name="singleTokens" match="g:token//g:string" use="."/>
	<xsl:param name="LLM" select="false()"/>
	
	<xsl:template match="@*|node()">
		<xsl:apply-templates select="@*|node()"/>
	</xsl:template>

	<xsl:template match="g:grammar">
		<out>
			<!-- and contains('AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz', substring(., 1, 1)) -->
			<xsl:call-template name="makeQNameKeywordList">
					<xsl:with-param name="nodelist" select="//g:string[not(ancestor::g:token)
						and contains('AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz', substring(., 1, 1))]"/>
			</xsl:call-template>
		</out>		
	</xsl:template>
		
	<xsl:template name="makeQNameKeywordList">
		<xsl:param name="nodelist"/>
		<xsl:param name="index" select="1"/>
		<xsl:param name="string-list" select="''"/>
			
		<xsl:for-each select="$nodelist[$index]">				
			
			<xsl:variable name="str" select="string(.)"/>
			<xsl:if test="not(contains($string-list, concat('::', $str, '::')))">
				<!-- g:string process-value="yes" -->
							<!-- xsl:for-each select="ancestor::*/@if | @*[not(name()='lookahead')]|node()">
								<xsl:value-of select="."/>
							</xsl:for-each -->	
				<xsl:if test="ancestor::g:production[@name='ValueComp' or @name='GeneralComp' or @name='NodeComp']">
					<xsl:text>(</xsl:text>
				</xsl:if>
				<xsl:value-of select="$str"/>
				<xsl:choose>
					<xsl:when test="ancestor::g:binary[not(@if='fulltext')] or ancestor::g:production[@is-binary='yes' and not(@if='fulltext')]">
						<xsl:text> </xsl:text>
						<xsl:value-of select="$str"/>
						<xsl:text> </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text> div </xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				
				<xsl:value-of select="$str"/>
				
				<xsl:if test="ancestor::g:production[@name='ValueComp' or @name='GeneralComp' or @name='NodeComp']">
					<xsl:text>)</xsl:text>
				</xsl:if>
				<xsl:text> &lt; </xsl:text>
				<xsl:text>&lt;</xsl:text>
				<xsl:value-of select="$str"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$str"/>
				<xsl:text>="</xsl:text>
				<xsl:value-of select="$str"/>
				<xsl:text>"</xsl:text>
				<xsl:text>&gt;</xsl:text>
				<xsl:text>{</xsl:text>
				<xsl:value-of select="$str"/>
				<xsl:text>}</xsl:text>
				<xsl:text>&lt;/</xsl:text>
				<xsl:value-of select="$str"/>
				<xsl:text>&gt;</xsl:text>
				<xsl:text>&#10;%%%&#10;</xsl:text>					
				<!-- /g:string -->
			</xsl:if>
			<xsl:call-template name="makeQNameKeywordList">
				<xsl:with-param name="nodelist" select="$nodelist"/>
				<xsl:with-param name="index" select="$index+1"/>
				<xsl:with-param name="string-list" select="concat($string-list, '::', $str, '::')"/>
			</xsl:call-template>
					
				
							
		</xsl:for-each>
		
	</xsl:template>

	
</xsl:stylesheet>
