/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;

public final class Diagnostics {
    static /* synthetic */ Class class$org$apache$tools$ant$Main;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$String;

    private Diagnostics() {
    }

    public static boolean isOptionalAvailable() {
        try {
            Class.forName("org.apache.tools.ant.taskdefs.optional.Test");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static void validateVersion() throws BuildException {
        try {
            Class<?> optional = Class.forName("org.apache.tools.ant.taskdefs.optional.Test");
            String coreVersion = Diagnostics.getImplementationVersion(class$org$apache$tools$ant$Main == null ? (class$org$apache$tools$ant$Main = Diagnostics.class$("org.apache.tools.ant.Main")) : class$org$apache$tools$ant$Main);
            String optionalVersion = Diagnostics.getImplementationVersion(optional);
            if (coreVersion != null && !coreVersion.equals(optionalVersion)) {
                throw new BuildException("Invalid implementation version between Ant core and Ant optional tasks.\n core    : " + coreVersion + "\n" + " optional: " + optionalVersion);
            }
        }
        catch (ClassNotFoundException e) {}
    }

    public static File[] listLibraries() {
        String home = System.getProperty("ant.home");
        if (home == null) {
            return null;
        }
        File libDir = new File(home, "lib");
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        String[] filenames = libDir.list(filter);
        if (filenames == null) {
            return null;
        }
        File[] files = new File[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            files[i] = new File(libDir, filenames[i]);
            ++i;
        }
        return files;
    }

    public static void main(String[] args) {
        Diagnostics.doReport(System.out);
    }

    private static String getImplementationVersion(Class clazz) {
        try {
            Method method = (class$java$lang$Class == null ? (class$java$lang$Class = Diagnostics.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getPackage", new Class[0]);
            Object pkg = method.invoke((Object)clazz, null);
            if (pkg != null) {
                method = pkg.getClass().getMethod("getImplementationVersion", new Class[0]);
                Object version = method.invoke(pkg, null);
                return (String)version;
            }
        }
        catch (Exception e) {
            return "?.?";
        }
        return null;
    }

    public static void doReport(PrintStream out) {
        out.println("------- Ant diagnostics report -------");
        out.println(Main.getAntVersion());
        out.println();
        out.println("-------------------------------------------");
        out.println(" Implementation Version (JDK1.2+ only)");
        out.println("-------------------------------------------");
        out.println("core tasks     : " + Diagnostics.getImplementationVersion(class$org$apache$tools$ant$Main == null ? (class$org$apache$tools$ant$Main = Diagnostics.class$("org.apache.tools.ant.Main")) : class$org$apache$tools$ant$Main));
        Class<?> optional = null;
        try {
            optional = Class.forName("org.apache.tools.ant.taskdefs.optional.Test");
            out.println("optional tasks : " + Diagnostics.getImplementationVersion(optional));
        }
        catch (ClassNotFoundException e) {
            out.println("optional tasks : not available");
        }
        out.println();
        out.println("-------------------------------------------");
        out.println(" ANT_HOME/lib jar listing");
        out.println("-------------------------------------------");
        Diagnostics.doReportLibraries(out);
        out.println();
        out.println("-------------------------------------------");
        out.println(" Tasks availability");
        out.println("-------------------------------------------");
        Diagnostics.doReportTasksAvailability(out);
        out.println();
        out.println("-------------------------------------------");
        out.println(" org.apache.env.Which diagnostics");
        out.println("-------------------------------------------");
        Diagnostics.doReportWhich(out);
        out.println();
        out.println("-------------------------------------------");
        out.println(" System properties");
        out.println("-------------------------------------------");
        Diagnostics.doReportSystemProperties(out);
        out.println();
    }

    private static void doReportSystemProperties(PrintStream out) {
        Enumeration keys = ((Hashtable)System.getProperties()).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            out.println(key + " : " + System.getProperty(key));
        }
    }

    private static void doReportLibraries(PrintStream out) {
        out.println("ant.home: " + System.getProperty("ant.home"));
        File[] libs = Diagnostics.listLibraries();
        if (libs == null) {
            out.println("Unable to list libraries.");
            return;
        }
        int i = 0;
        while (i < libs.length) {
            out.println(libs[i].getName() + " (" + libs[i].length() + " bytes)");
            ++i;
        }
    }

    private static void doReportWhich(PrintStream out) {
        Throwable error = null;
        try {
            Class<?> which = Class.forName("org.apache.env.Which");
            Method method = which.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Diagnostics.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            method.invoke(null, new Object[]{new String[0]});
        }
        catch (ClassNotFoundException e) {
            out.println("Not available.");
            out.println("Download it at http://xml.apache.org/commons/");
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException() == null ? e : e.getTargetException();
        }
        catch (Throwable e) {
            error = e;
        }
        if (error != null) {
            out.println("Error while running org.apache.env.Which");
            error.printStackTrace();
        }
    }

    private static void doReportTasksAvailability(PrintStream out) {
        InputStream is = (class$org$apache$tools$ant$Main == null ? (class$org$apache$tools$ant$Main = Diagnostics.class$("org.apache.tools.ant.Main")) : class$org$apache$tools$ant$Main).getResourceAsStream("/org/apache/tools/ant/taskdefs/defaults.properties");
        if (is == null) {
            out.println("None available");
        } else {
            Properties props = new Properties();
            try {
                props.load(is);
                Enumeration keys = ((Hashtable)props).keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String classname = props.getProperty(key);
                    try {
                        Class.forName(classname);
                        ((Hashtable)props).remove(key);
                    }
                    catch (ClassNotFoundException e) {
                        out.println(key + " : Not Available");
                    }
                    catch (NoClassDefFoundError e) {
                        String pkg = e.getMessage().replace('/', '.');
                        out.println(key + " : Missing dependency " + pkg);
                    }
                    catch (Error e) {
                        out.println(key + " : Initialization error");
                    }
                }
                if (((Hashtable)props).size() == 0) {
                    out.println("All defined tasks are available");
                }
            }
            catch (IOException e) {
                out.println(e.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

