/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends Writer {
    private static final int buf_length = 16384;
    private final OutputStream m_os;
    private final byte[] buf;
    private int count;

    public WriterToUTF8Buffered(OutputStream out) throws UnsupportedEncodingException {
        this.m_os = out;
        this.buf = new byte[16387];
        this.count = 0;
    }

    public void write(int c) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (c < 128) {
            this.buf[this.count++] = (byte)c;
        } else if (c < 2048) {
            this.buf[this.count++] = (byte)(192 + (c >> 6));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (c >> 12));
            this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    private final void writeDirect(char[] chars, int start, int length) throws IOException {
        OutputStream os = this.m_os;
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    private final void writeDirect(String s) throws IOException {
        int n = s.length();
        OutputStream os = this.m_os;
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= 16384) {
            this.flushBuffer();
            this.writeDirect(chars, start, length);
            return;
        }
        if (lengthx3 > 16384 - this.count) {
            this.flushBuffer();
        }
        OutputStream os = this.m_os;
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void write(String s) throws IOException {
        int length = s.length();
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= 16384) {
            this.flushBuffer();
            this.writeDirect(s);
            return;
        }
        if (lengthx3 > 16384 - this.count) {
            this.flushBuffer();
        }
        OutputStream os = this.m_os;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }
}

