/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.apache.xalan.xsltc.trax.TransformerImpl;

public final class TemplatesImpl
implements Templates,
Serializable {
    private static String ABSTRACT_TRANSLET = "org.apache.xalan.xsltc.runtime.AbstractTranslet";
    private String _name = null;
    private byte[][] _bytecodes = null;
    private Translet _translet = null;
    private Class[] _class = null;
    private int _transletIndex = -1;
    private Properties _outputProperties;
    private int _indentNumber;
    private URIResolver _uriResolver = null;
    private transient TransformerFactoryImpl _tfactory = null;

    protected TemplatesImpl(byte[][] bytecodes, String transletName, Properties outputProperties, int indentNumber, TransformerFactoryImpl tfactory) {
        this._bytecodes = bytecodes;
        this._name = transletName;
        this._outputProperties = outputProperties;
        this._indentNumber = indentNumber;
        this._tfactory = tfactory;
    }

    protected TemplatesImpl(Translet translet, String transletName, Properties outputProperties, int indentNumber, TransformerFactoryImpl tfactory) {
        this._translet = translet;
        this._name = transletName;
        this._outputProperties = outputProperties;
        this._indentNumber = indentNumber;
        this._tfactory = tfactory;
    }

    public TemplatesImpl() {
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this._tfactory = new TransformerFactoryImpl();
    }

    public synchronized void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    protected synchronized void setTransletBytecodes(byte[][] bytecodes) {
        this._bytecodes = bytecodes;
    }

    public synchronized byte[][] getTransletBytecodes() {
        return this._bytecodes;
    }

    public synchronized Class[] getTransletClasses() {
        try {
            if (this._class == null) {
                this.defineTransletClasses();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return this._class;
    }

    public synchronized int getTransletIndex() {
        try {
            if (this._class == null) {
                this.defineTransletClasses();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return this._transletIndex;
    }

    protected synchronized void setTransletName(String name) {
        this._name = name;
    }

    protected synchronized String getTransletName() {
        return this._name;
    }

    private void defineTransletClasses() throws TransformerConfigurationException {
        if (this._bytecodes == null) {
            ErrorMsg err = new ErrorMsg("NO_TRANSLET_CLASS_ERR");
            throw new TransformerConfigurationException(err.toString());
        }
        TransletClassLoader loader = (TransletClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new TransletClassLoader(Thread.currentThread().getContextClassLoader());
            }
        });
        try {
            int classCount = this._bytecodes.length;
            this._class = new Class[classCount];
            int i = 0;
            while (i < classCount) {
                this._class[i] = loader.defineClass(this._bytecodes[i]);
                Class superClass = this._class[i].getSuperclass();
                if (superClass.getName().equals(ABSTRACT_TRANSLET)) {
                    this._transletIndex = i;
                }
                ++i;
            }
            if (this._transletIndex < 0) {
                ErrorMsg err = new ErrorMsg("NO_MAIN_TRANSLET_ERR", this._name);
                throw new TransformerConfigurationException(err.toString());
            }
        }
        catch (ClassFormatError e) {
            ErrorMsg err = new ErrorMsg("TRANSLET_CLASS_ERR", this._name);
            throw new TransformerConfigurationException(err.toString());
        }
        catch (LinkageError e) {
            ErrorMsg err = new ErrorMsg("TRANSLET_OBJECT_ERR", this._name);
            throw new TransformerConfigurationException(err.toString());
        }
    }

    private Translet getTransletInstance() throws TransformerConfigurationException {
        try {
            if (this._name == null) {
                return null;
            }
            if (this._class == null) {
                this.defineTransletClasses();
            }
            Translet translet = (Translet)this._class[this._transletIndex].newInstance();
            int classCount = this._bytecodes.length;
            int i = 0;
            while (i < classCount) {
                if (i != this._transletIndex) {
                    translet.addAuxiliaryClass(this._class[i]);
                }
                ++i;
            }
            return translet;
        }
        catch (InstantiationException e) {
            ErrorMsg err = new ErrorMsg("TRANSLET_OBJECT_ERR", this._name);
            throw new TransformerConfigurationException(err.toString());
        }
        catch (IllegalAccessException e) {
            ErrorMsg err = new ErrorMsg("TRANSLET_OBJECT_ERR", this._name);
            throw new TransformerConfigurationException(err.toString());
        }
    }

    public synchronized Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl transformer = this._translet != null ? new TransformerImpl(this._translet, this._outputProperties, this._indentNumber, this._tfactory) : new TransformerImpl(this.getTransletInstance(), this._outputProperties, this._indentNumber, this._tfactory);
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return transformer;
    }

    public synchronized Properties getOutputProperties() {
        try {
            return this.newTransformer().getOutputProperties();
        }
        catch (TransformerConfigurationException e) {
            return null;
        }
    }

    private class TransletClassLoader
    extends ClassLoader {
        protected TransletClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(byte[] b) {
            return super.defineClass(null, b, 0, b.length);
        }
    }
}

