/**
 * (c) COPYRIGHT 2000 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 */

package org.w3c.app.xsl;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.xml.sax.*;
import com.jclark.xsl.sax.*;
import org.w3c.app.util.*;

/* based from James Clark's XSLServlet */ 
public class XSLtransformer extends HttpServlet {

    Log log;

  public void init(ServletConfig config) throws ServletException {
      super.init();
      log = new Log(((config.getInitParameter("logfile") != null)? config.getInitParameter("logfile"):"/usr/local/Jigsaw/Jigsaw/logs/xslog"));
  }

  public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
      doGet(req, res);
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
      String xslfile = null;
      String xmlfile = null;
      try {	  
	  XSLProcessor processor = new XSLProcessorImpl();
	  processor.setParser(new com.jclark.xml.sax.Driver());
  	  xslfile = req.getParameter("xslfile");
	  xmlfile = req.getParameter("xmlfile");
	  processor.loadStylesheet(new InputSource(xslfile));
	  for (Enumeration e = req.getParameterNames(); e.hasMoreElements();) {
	      String name = (String)e.nextElement();
	      // What to do about multiple values?
	      processor.setParameter(name, req.getParameter(name));
	  }
	  OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl(processor);
	  processor.setOutputMethodHandler(outputMethodHandler);
	  outputMethodHandler.setDestination(new ServletDestination(res));	  
	  //I only saw org.xml.sax.InputSource's that use streams not urls but this was being done in a file based one
	  processor.parse(new InputSource(xmlfile));
      }
      catch (Exception e) {
	  StringBuffer params = new StringBuffer();
	  log.writeLog("Choked processing " + xslfile + " transforming " + xmlfile );
	  for (Enumeration en = req.getParameterNames(); en.hasMoreElements();) {	   
	      String name = (String)en.nextElement();
	      params.append(name + " - " + req.getParameter(name) + "\r\n");
	  }
	  if (params.length() > 0) {
	      log.writeLog("With these parameters:\r\n" + params.toString());
	  }
	  log.logException(e);	  
	  //rework so we can provide more info to user, but how to know if the ServletResponse object was written to already or not - for status code, etc.
	  //no readily avail way even to tell if the [Servlet]OutputStream was written to in the API, extend [Servlet]OutputStream is an option
	  //throw new ServletException(e);
	  try {
	      ServletOutputStream out = res.getOutputStream();
	      out.println("Are you <a href='http://www.w3.org/2001/05/xslt'>using</a> this properly?<br>Choked processing " + xslfile + " transforming " + xmlfile + "<br>");
	      if (params.length() > 0) {
		  out.print("With these parameters:<pre>" + params.toString() + "</pre>");
	      }
	      out.println("<pre>");
	      e.printStackTrace(new PrintStream((OutputStream)out));
	      out.println("</pre>");
	  }
	  catch (Exception ex) {}

      }
  }

}
