/**
 * Author: Ted Guild <ted@w3.org> 
 * (c) COPYRIGHT W3C http://www.w3.org/Consortium/Legal/copyright-software
 * $Id: ServletAuthReader.java,v 1.18 2010/04/26 12:53:53 ted Exp $
 */

package org.w3c.app.xsl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;
import org.w3c.app.util.BlacklistChecker;
import org.w3c.tools.codec.Base64Decoder;

public class ServletAuthReader {
	private HttpServletRequest req;
	private HttpServletResponse res;
	private BlacklistChecker blc;
	private StringBuffer sb;
	private HashMap urlConns = new HashMap();
        private Boolean check_uri = new Boolean(true);

	public ServletAuthReader(HttpServletRequest req, HttpServletResponse res,
			BlacklistChecker blc, StringBuffer sb) {
		this.req = req;
		this.res = res;
		this.blc = blc;
		this.sb = sb;
	}


    //Check domain for both xml source and xslt URIs 
	public Reader initAuthInputStreamReader(String uri, String altUri)
			throws java.net.MalformedURLException, java.io.IOException {
	    check_uri = this.checkUri(altUri);
	    return initAuthInputStreamReader(uri);
	}

	public Reader initAuthInputStreamReader(String uri)
			throws java.net.MalformedURLException, java.io.IOException {
	        if (check_uri == true) {
		    check_uri = this.checkUri(uri);
		}
		String blisted = blc.checkURI(uri);
		if (blisted != null) {
			res.sendError(403, blisted);
			throw new IOException(blisted);
		}
		if (req.getParameter("debug") != null) {
			sb.append("Loading resource: "
					+ uri
					+ " at "
					+ new SimpleDateFormat("yyyyMMdd HH:mm:ss.SS")
							.format(Calendar.getInstance().getTime()) + "\n");
		}
		Reader authISReader;
		URL url = new URL(uri);
		HttpURLConnection urlConn;
		String encoding = null;
		urlConn = (HttpURLConnection) url.openConnection();
		urlConns.put(uri, urlConn);
		setReaderRequestHeaders(urlConn);
		// add auth header, but only in case of failure
		// to avoid disclosing auth information
		if (urlConn.getResponseCode() == 401) {
		        if (check_uri != true) {
			    res.sendError(403,
					"Authentication proxying not allowed in this situation");
			    throw new IOException(
					"Authentication proxying not allowed in this situation");
			}
			String authString = req.getHeader("Authorization");
			if (authString != null) {
				// random koalie hazer
				try {
					String debase = new Base64Decoder(authString.substring(6))
							.processString();
					String login = debase.substring(0, debase.indexOf(":"));
					if (login != null && login.equals("coralie")) {
						int random = new Random().nextInt(10);
						if (random <= 1) {
							res
									.sendRedirect("http://www.w3.org/Team/Coralie/,rigo");
							throw new RuntimeException("koalie hazer");
						} else if (random >= 9) {
							res
									.sendRedirect("http://www.theregister.co.uk/odds/bofh/");
							throw new RuntimeException("koalie hazer");
						}
					}
				} catch (Exception ex) {
					sb.append("Exception " + ex + " \n" + ex.getMessage()
							+ "\n");
				}

				urlConn.disconnect();
				urlConn = (HttpURLConnection) url.openConnection();
				setReaderRequestHeaders(urlConn);
				urlConn.setRequestProperty("Authorization", authString);
			}
			// then test again with auth, if it fails, bail in inform the user
			// that he needs to authenticate again.
			if (urlConn.getResponseCode() == 401) {
				String authenticateString = urlConn
						.getHeaderField("WWW-Authenticate");
				res.setHeader("WWW-Authenticate", authenticateString);
				res.sendError(401, "Authorization Required");
				throw new RuntimeException("auth failed, ending processing");
			}
		}
		String ctype = urlConn.getContentType();
		if (ctype != null) {
			try {
				MimeType repmime = new MimeType(ctype);
				if (repmime.hasParameter("charset"))
					encoding = repmime.getParameterValue("charset");

			} catch (Exception ex) {
				sb.append("Exception " + ex + " \n" + ex.getMessage() + "\n");
			}
		}
		String ContentEncoding = urlConn.getContentEncoding();
		if (ContentEncoding != null && ContentEncoding.indexOf("gzip") != -1) {
			if (encoding != null) {
				authISReader = (Reader) new InputStreamReader(
						new GZIPInputStream((InputStream) urlConn.getContent()),
						encoding);
			} else {
				authISReader = (Reader) new InputStreamReader(
						new GZIPInputStream((InputStream) urlConn.getContent()));
			}
		} else if (encoding != null) {
			authISReader = (Reader) new InputStreamReader((InputStream) urlConn
					.getContent(), encoding);
		} else {
			authISReader = (Reader) new InputStreamReader((InputStream) urlConn
					.getContent());
		}
		return authISReader;
	}

	private void setReaderRequestHeaders(HttpURLConnection urlConn) {
		if (req.getParameter("forward-accept") != null) {
			for (Enumeration e = req.getHeaderNames(); e.hasMoreElements();) {
				String headerName = (String) e.nextElement();
				if (headerName.toLowerCase().startsWith("accept")) {
					// clients may send multiple eg Accept-Language headers
					// instead of one with comma delimited values
					for (Enumeration h = req.getHeaders(headerName); h
							.hasMoreElements();) {
						String headerValue = (String) h.nextElement();
						urlConn.setRequestProperty(headerName, headerValue);
					}
				}
			}
		}
	}

	private boolean checkUri(String uri) {
		Pattern w3_uri_pattern = Pattern
				.compile("^http[s]?://.+\\.w3\\.org/.*");
		Matcher matcher = w3_uri_pattern.matcher(uri);
		return matcher.matches();
	}
}
