/**
 * (c) COPYRIGHT 2000 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 */

package org.w3c.app.xsl;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.xml.sax.*;
import com.jclark.xsl.sax.*;
import org.w3c.app.util.*;
import org.w3c.app.servlet.*;


/* based from James Clark's XSLServlet */ 
public class ProxyAuthXSLtransformer extends HttpServlet {

    Log log;
    //    private static AuthXSLServletState state;
    private static Hashtable ipState;

  public void init(ServletConfig config) throws ServletException {
      super.init();
      //state = AuthXSLServletState.getInstance();
      log = new Log(((config.getInitParameter("logfile") != null)? config.getInitParameter("logfile"):"/usr/local/Jigsaw/Jigsaw/logs/proxyauthxsltlog"));
  }

  public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
      doGet(req, res);
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
      log.writeLog("doGet");      
      //Hashtable ipState = (Hashtable)state.getHash().get(req.getRemoteAddr());
      String xmlfile = null;
      String xslfile = null;
      StringBuffer message = new StringBuffer("<pre>");
      URL xslURL, xmlURL;      
      URLConnection xslURLConnection, xmlURLConnection;
      try {
	  XSLProcessor processor = new XSLProcessorImpl();
	  String authString = req.getHeader("Authorization");
	  processor.setParser(new com.jclark.xml.sax.Driver());
	  xslfile = req.getParameter("xslfile");
	  xmlfile = req.getParameter("xmlfile");
  	  log.writeLog("xmlfile:xslfile - " + xmlfile +":" + xslfile);
	  xslURL = new URL(xslfile);
	  xmlURL = new URL(xmlfile);
	  if (ipState == null) {
	      //state.getHash().put(req.getRemoteAddr(), new Hashtable());
	      //ipState = (Hashtable)state.getHash().get(req.getRemoteAddr());
	      ipState = new Hashtable();
	      log.writeLog("init session");
	      ipState.put("authRequired", new Boolean(false));
	      ipState.put("authorized", new Boolean(false));
	      ipState.put("stage", "init");
	  }
	  else {
	      log.writeLog("our state exists and this doGet we're at - " + (String)ipState.get("stage"));
	  }
	  xslURLConnection = xslURL.openConnection();
	  xmlURLConnection = xmlURL.openConnection();
	  log.writeLog("got connected");
	  // does this persist beyond connections?? seemed like it did when testing
	  //	  Authenticator.setDefault(null);
	  if (authString != null) {
	      ipState.put("authString", authString);
	  }
	  //don't want to check unless we need to
	  if( ((String)ipState.get("stage")).equals("init") ) {
	      String xslWWWAuth = xslURLConnection.getHeaderField("WWW-Authenticate");
	      String xmlWWWAuth = xmlURLConnection.getHeaderField("WWW-Authenticate");
	      if ((xslWWWAuth != null || xmlWWWAuth != null)) {
		  ipState.put("authRequired", new Boolean(true));
		  log.writeLog("WWW-Auth[s] " + xslWWWAuth + "  --  " + xmlWWWAuth);
		  //if it fails it's because of index out of bounds type error and we're not the same
		  //		  try { 
		  //besides just the header being the same the hostname & protocol should be the same or at least the domain name		  
		  //if (xslWWWAuth.equals(xmlWWWAuth) && xmlfile.startsWith(xslfile.substring(xslfile.indexOf("/",6)))) {
		  //we're not going to bother with this scenario for now although in the unlikely event of this, the user will not 
		  //be prompted for a second auth string 
		  if (xslWWWAuth.equals(xmlWWWAuth)) {
			  ipState.put("sameWWWAuth", new Boolean(true));			  
			  log.writeLog("WWW-Authenticate headers match but haven't checked and uri protocol/host");
		  }
		  if (xslWWWAuth != null) {
		      ipState.put("xslWWWAuth", xslWWWAuth);
		  }
		  if (xmlWWWAuth != null) {
		      ipState.put("xmlWWWAuth", xmlWWWAuth);
		  }
	      }
	      ipState.put("stage", "auth checked");
	  }	  
	  /* perhaps some explanation of thoughts are required here:

	  authorization is required and we don't have our auth string yet or we need 2 different authorizations and
	  our current user supplied auth string is the same as the xsl (as that would be first prompted for) one 
	  ***which may in fact be valid as people may use same username/passwd for multiple web accounts so we need to check what we sent 
	  last time was not the xml one as we'd loop endlessly otherwise - it is fair to prompt them twice though
 
	  if xml auth needed and xsl one is not needed - sameWWAuth would be null and we prompted if we were lacking an auth string already
	  so this contingency is taken care of and doesn't need a separate test
	  BTW, the case where we don't need a xslAuthString but only a xmlAuthString will be covered herein

	  seesh what a [intitialy] poorly thought out approachy
	  */
	  if(((Boolean)ipState.get("authRequired")).booleanValue() && 
	     (authString == null || 
	      (ipState.get("sameWWWAuth") == null && authString.equals(ipState.get("xslAuthString")) && ipState.get("xmlWWWAuth") != null &&
	       ! ((String)ipState.get("xmlWWWAuth")).equals((String)ipState.get("WWWAuthSent"))))) {
	      //someone gave us something
	      if (authString != null) {
		  if (ipState.get("xslWWWAuth") != null && ipState.get("xslAuthString") == null) {
		      log.writeLog("xslAuthString set and presumably xmlAuthString may need it " + authString.substring(8)); 
		      ipState.put("xslAuthString", authString); 
		  }
		  else {
		      log.writeLog("xslAuthString was set and/or we don't need it but we have an auth string and sending a promp t" + authString.substring(8));
		      ipState.put("xmlAuthString", authString); 
		  } 
	      }
	      //hmm which one is this for? well is xslAuth not needed or already set? in which case we're after the one for our xml resource 
	      String wwwAuthSent = ((ipState.get("xslWWWAuth") == null || ipState.get("xslAuthString") != null)?
				    (String)ipState.get("xmlWWWAuth"):(String)ipState.get("xslWWWAuth"));
	      res.setHeader("WWW-Authenticate", wwwAuthSent);						 
	      res.sendError(401, "Authorization Required");
	      log.writeLog("prompt user for " + wwwAuthSent);
	      ipState.put("stage", "user prompted");
	      ipState.put("WWWAuthSent", wwwAuthSent);
	  }
	  if (authString != null) {
	      if (ipState.get("xslWWWAuth") != null && ipState.get("xslAuthString") == null) {
		  log.writeLog("#2 xslAuthString set and presumably xmlAuthString may need it " + authString.substring(8)); 
		  ipState.put("xslAuthString", authString);
		  //just set for now #### override
		  ipState.put("xmlAuthString", authString);
		  if (ipState.get("sameWWWAuth") != null) {
		      ipState.put("xmlAuthString", authString);
		  }
	      }
	      else if (ipState.get("xmlWWWAuth") != null && ipState.get("xmlAuthString") == null) {
		  log.writeLog("#2 xslAuthString was set and/or we don't need it but we have an auth string and sending a prompt" + authString.substring(8));
		  ipState.put("xmlAuthString", authString); 
	      } 	      
	  }
	  if (((ipState.get("xmlWWWAuth") != null && ipState.get("xmlAuthString") != null) || (ipState.get("xmlWWWAuth") == null)) &&
	       ((ipState.get("xslWWWAuth") != null && ipState.get("xslAuthString") != null) || (ipState.get("xslWWWAuth") == null))) {
	      ipState.put("authorized", new Boolean(true));  
	      //authorization: Basic dGVkOmZvbw==	 
	      log.writeLog("auth[s] are set");
	      xslURLConnection = xslURL.openConnection();
	      if (ipState.get("xslAuthString") != null) {
		  xslURLConnection.setRequestProperty ("Authorization", (String)ipState.get("xslAuthString"));
	      }
	      xmlURLConnection = xmlURL.openConnection();
	      if (ipState.get("xmlAuthString") != null) {
		  xmlURLConnection.setRequestProperty ("Authorization", (String)ipState.get("xmlAuthString"));
	      }
	      log.writeLog("reestablishing connections with authorization headers set");
	  }	 
	  if( !((Boolean)ipState.get("authRequired")).booleanValue() || 
	      ((Boolean)ipState.get("authorized")).booleanValue()){ 
	      //try { 
	      //  ipState=null;
	      //  //		  state.getHash().remove(req.getRemoteAddr());
	      //  log.writeLog("invalidated session");
	      //} 
	      //catch (Exception ee) {}
	      log.writeLog("pre processor xsl inputsource on stream\n");
	      ipState.put("stage", "xslRead");
	      //	      InputSource xslInputStream = new InputSource((InputStream)xslURLConnection.getContent());
	      InputSource xslInputStream = new InputSource(xslfile);
	      xslInputStream.setByteStream((InputStream)xslURLConnection.getContent());
	      //log.writeLog("xslInputStream sysid " + xslInputStream.getSystemId() + " pubid " + xslInputStream.getPublicId());
	      processor.loadStylesheet(xslInputStream);
	      log.writeLog("post processor xsl inputsource on stream\n");
	      for (Enumeration e = req.getParameterNames(); e.hasMoreElements();) {
		  String name = (String)e.nextElement();
		  // What to do about multiple values?
		  processor.setParameter(name, req.getParameter(name));
	      }
	      message.append("checked params\n");
	      OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl(processor);
	      processor.setOutputMethodHandler(outputMethodHandler);
	      //this might be an issue if we try to send 401 at this point
	      outputMethodHandler.setDestination(new ServletDestination(res));
	      log.writeLog("pre parse xml inputsource on stream\n");  
	      ipState.put("stage", "xmlRead");
	      InputSource xmlInputStream = new InputSource(xmlfile);
	      xmlInputStream.setByteStream((InputStream)xmlURLConnection.getContent());
	      //log.writeLog("xmlInputStream sysid " + xmlInputStream.getSystemId() + " pubid " + xmlInputStream.getPublicId());
	      //	      processor.parse(new InputSource((InputStream)xmlURLConnection.getContent()));
	      processor.parse(xmlInputStream);
	      log.writeLog("post parse xml inputsource on stream\n");
	      ipState=null;
	      log.writeLog("invalidated session, process complete");	      
	  }
	  log.writeLog("end doGet");
      }
      //but how to know which connection choked - will have to keep state on which we've accessed

      /*
	how else to approach should this not work...
	response obj is in use for instance
       */
      catch (FileNotFoundException authEx) {
	  try {
	      log.writeLog("BAD AUTH");	      
	      //hopefully this will be the right one depending on where we choked
	      if ("xslRead".equals(ipState.get("stage"))) {
		  ipState.put("WWWAuthSent", ipState.get("xslWWWAuth"));	
		  log.writeLog("were we doing an xsl read");
		  ipState.remove("xslAuthString");
		  log.writeLog("nulled out out xslAuthString");
		  if (ipState.get("sameWWWAuth") != null) {
		      ipState.remove("xmlAuthString");
		      log.writeLog("nulled out out xmlAuthString as it's one auth");
		  }
	      }	  
	      else if ("xmlRead".equals(ipState.get("stage"))) {
		  ipState.put("WWWAuthSent", ipState.get("xmlWWWAuth"));	
		  log.writeLog("were we doing an xml read");	      
		  ipState.remove("xmlAuthString");
		  log.writeLog("nulled out out xmlAuthString");
	      }
	      //shouldn't be the case at all but if so null em both
	      else {	      
		  log.writeLog("try to null out our strings");
		  ipState.remove("xslAuthString");
		  ipState.remove("xmlAuthString");
	      }
	      res.setHeader("WWW-Authenticate", (String)ipState.get("WWWAuthSent"));
	      res.sendError(401, "Authorization Required");
	      log.writeLog("prompt user for " + (String)ipState.get("WWWAuthSent"));	      
	      log.writeLog("set the stage to badAuth");
	      ipState.put("stage", "badAuth");
	  }
	  catch (Exception ee) {
	      log.logException(ee);	  
	  }
      }
      catch (Exception e) {	       
	  StringBuffer params = new StringBuffer();
	  log.writeLog("Choked processing " + xslfile + " transforming " + xmlfile );
	  for (Enumeration en = req.getParameterNames(); en.hasMoreElements();) {	   
	      String name = (String)en.nextElement();
	      params.append(name + " - " + req.getParameter(name) + "\r\n");
	  }
	  if (params.length() > 0) {
	      log.writeLog("With these parameters:\r\n" + params.toString());
	  }
	  log.logException(e);	  
	  //rework so we can provide more info to user, but how to know if the ServletResponse object was written to already or not - for status code, etc.
	  //no readily avail way even to tell if the [Servlet]OutputStream was written to in the API, extend [Servlet]OutputStream is an option
	  //throw new ServletException(e);
	  try {
	      ServletOutputStream out = res.getOutputStream();
	      out.println("Choked processing " + xslfile + " transforming " + xmlfile + "<br>");
	      out.println(message.toString() + "</pre>");
	      if (params.length() > 0) {
		  out.print("With these parameters:<pre>" + params.toString() + "</pre>");
	      }
	      out.println("<pre>");
	      e.printStackTrace(new PrintStream((OutputStream)out));
	      out.println("</pre>");
	  }
	  catch (Exception ex) {}

      }
  }

}


