/**
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 */

package org.w3c.app.util;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.text.*;

/**
 * handles error and exception logging also will duplicate to a second iostream
 * Using RandomAccessFile instead of streams and writers as a certain JDK 
 * implementation doesn't append properly, it clobbers. 
 */
public class Log {
       
    String filename; 
    private PrintWriter pw = null;
    private boolean stdout = false;
    private boolean asHtml = false;
    private static int level = 0;


    public Log (String filename, int level) {
	this.level = level;
	this.filename = filename;      
    }

    
    public Log (String filename) {
	this(filename, 0);
    }

    /** Use this to get all the log messages sent to writeLog to an OutputStream in addition to the logfile.  
     * Setting this to System.out, ServletOutputStream, FileOutputStream, etc. will send anything being logged to that stream as well.  
     * @param out OutputStream to send caught exception and other logged messages to.
     * @param htmlComment boolean whether or not to wrap HTML comment tags around output <!-- -->
    */

    public void setOutStream(OutputStream out, boolean htmlComment) {
	asHtml = htmlComment;
	stdout = true;
	pw = new PrintWriter(out);
    }

    /** This will disable setOutStream.  
     * Messages sent to writeLog will no longer go to OutputStream 
     */
    public void unsetOutStream () {
	pw.flush();
	pw.close();
	stdout = false;
    }
  
    public void setLevel(int level) {
	this.level = level;
    }

    public synchronized void writeLog (String s, int level) {
	if (level >= this.level) {
	    writeLog(s);
	}
    }

    /** Appends a String in the standard log format (Date-time --- message\r\n ) 
     * to this objects' instance Log file, usually a caught Exception.
     * @param s String to write to log file
     */
    public synchronized void writeLog (String s) {

	try {
	    RandomAccessFile raf = new RandomAccessFile(filename, "rw");
	    Calendar rightNow = Calendar.getInstance();
	    java.util.Date dt = rightNow.getTime();
	    raf.seek( raf.length() );	
	    raf.writeBytes(dt.toString() + " --- " + s + "\r\n");
	    raf.close();
	} 
	catch (Exception e) {}
	if (stdout) {
	    try {
		if (asHtml) {
		    pw.println("<!--" + s + "-->");
		    pw.flush();
		} 
		else {
		    pw.println(s);
		    pw.flush();
		}
	    } 
	    catch (Exception e) {}
	}
	return;
    }

    /**
     * logException, in default manner with full stack trace
     *
     * @param e a value of type 'Exception'
     */
    
    public synchronized void logException (Exception ex) {
	logException(ex, true);
	return; 
    }

    public synchronized void logException (Exception ex, boolean showStack) {
	try {
	    StringWriter strw = new StringWriter();
	    ex.printStackTrace(new PrintWriter((Writer)strw));
	    strw.flush();
	    writeLog(strw.toString());
	    strw.close();
	} 
	catch (Exception e) {}
	if (stdout) {
	    try {
		if (asHtml) {
		    pw.println("<!-- EXCEPTION CAUGHT " + ex);
		    if (showStack) {
			pw.println("\nStack trace:\n");
			ex.printStackTrace(pw);
			pw.println("\n");		     
		    } 
		    pw.println("-->\n");
		} 
		else {
		    pw.println("Exception" + ex);
		    if (showStack) {
			pw.println("\nStack trace:\n");
			ex.printStackTrace(pw);
			pw.println("\n");		     
		    } 
		}
		pw.flush();
	    }
	    catch (Exception e) {}
	}
	return;
    }
}











