// ONLY EDIT THIS FILE IN THE GRAMMAR ROOT DIRECTORY!
// THE ONE IN THE ${spec}-src DIRECTORY IS A COPY!!!

import java.io.*;
import java.util.Vector;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

/**
 * Title: Description: Copyright: Copyright (c) 2001 Company:
 * 
 * @author
 * @version 1.0
 */

public class Test {

    public Test() {
    }

    public static void main(String[] args) {
        int numberArgsLeft = args.length;
        int argsStart = 0;
        boolean isMatchParser = false;
        boolean dumpTree = false;
        while (numberArgsLeft > 0) {
            try {

                if (args[argsStart].equals("-dumptree")) {
                    dumpTree = true;
                    argsStart++;
                    numberArgsLeft--;
                }
                if (args[argsStart].equals("-match")) {
                    isMatchParser = true;
                    System.out.println("Match Pattern Parser");
                    argsStart++;
                    numberArgsLeft--;
                } else if ("-file".equalsIgnoreCase(args[argsStart])) {
                    argsStart++;
                    numberArgsLeft--;
                    System.out.println("Running test for: " + args[argsStart]);
                    File file = new File(args[argsStart]);
                    argsStart++;
                    numberArgsLeft--;
                    FileInputStream fis = new FileInputStream(file);
                    XPath parser = new XPath(fis);
                    SimpleNode tree = parser.XPath2();
                    if (dumpTree)
                        tree.dump("|");
                } else if (args[argsStart].endsWith(".xquery")) {
                    System.out.println("Running test for: " + args[argsStart]);
                    File file = new File(args[argsStart]);
                    argsStart++;
                    numberArgsLeft--;
                    FileInputStream fis = new FileInputStream(file);
                    XPath parser = new XPath(fis);
                    SimpleNode tree = parser.XPath2();
                    if (dumpTree)
                        tree.dump("|");
                }         else if ("-catalog".equalsIgnoreCase(args[argsStart])) {
                    argsStart++;
                    numberArgsLeft--;
                    String catalogFileName = args[argsStart];
                    argsStart++;
                    numberArgsLeft--;
                    System.out.println("Running catalog for: "
                            + catalogFileName);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory
                            .newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(catalogFileName);

                    NodeIterator testCases = ((DocumentTraversal) doc)
                            .createNodeIterator(doc, NodeFilter.SHOW_ELEMENT,
                                    new NodeFilter() {
                                        public short acceptNode(
                                                org.w3c.dom.Node node) {
                                            String nm = node.getNodeName();
                                            return (nm.equals("test-case")) ? NodeFilter.FILTER_ACCEPT
                                                    : NodeFilter.FILTER_SKIP;
                                        }
                                    }, true);
                    org.w3c.dom.Element testCase;
                    int totalCount = 0;
                    Vector failedList = new Vector();
                    while ((testCase = (org.w3c.dom.Element) testCases
                            .nextNode()) != null) {
                        NodeIterator queryies = ((DocumentTraversal) doc)
                                .createNodeIterator(testCase,
                                        NodeFilter.SHOW_ELEMENT,
                                        new NodeFilter() {
                                            public short acceptNode(
                                                    org.w3c.dom.Node node) {
                                                String nm = node.getNodeName();
                                                return (nm.equals("query")) ? NodeFilter.FILTER_ACCEPT
                                                        : NodeFilter.FILTER_SKIP;
                                            }
                                        }, true);
                        org.w3c.dom.Element query;
                        while ((query = (org.w3c.dom.Element) queryies
                                .nextNode()) != null) {
                            String fileString = query.getAttribute("name");
                            String locString = testCase
                                    .getAttribute("FilePath").replace('/',
                                            File.separatorChar);
                            File catFile = new File(catalogFileName);
                            String locCatFile = catFile.getParent();
                            String absFileName = locCatFile + File.separator
                                    + "Queries" + File.separator + "XQuery"
                                    + File.separator + locString + fileString;

                            if (dumpTree) {
                                System.out.print("== ");
                                System.out.print(absFileName);
                                System.out.println(" ==");
                            } else
                                System.out.print(".");

                            boolean isParseError = false;
                            String scenario = testCase.getAttribute("scenario");
                            if (scenario.equals("parse-error"))
                                isParseError = true;

                            totalCount++;

                            try {
                                File file = new File(absFileName);
                                FileInputStream fis = new FileInputStream(file);
                                XPath parser = new XPath(fis);
                                SimpleNode tree = parser.XPath2();
                                if(isParseError)
                                    failedList.addElement(fileString);
                                if (dumpTree)
                                    tree.dump("|");
                            } catch (Exception e) {
                                if(!isParseError)
                                    failedList.addElement(fileString);
                            } catch (Error e2) {
                                if(!isParseError)
                                    failedList.addElement(fileString);
                            }

                        }

                    }
                    System.out.println();
                    if(failedList.size() > 0)
                    {
                        System.out.print("FAILED: ");
                        for(int i = 0; i != failedList.size(); i++)
                        {
                            String fname = (String)failedList.elementAt(i);
                            System.out.print(fname);
                            if((i+1) != failedList.size())
                                System.out.print(", ");
                        }
                        System.out.println();
                        System.out.print("Failed "+failedList.size()+" out of ");
                    }
                    else
                    {
                        System.out.print("Total Success!! ");
                    }
                    System.out.println(totalCount+" cases");

                } else {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory
                            .newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(args[0]);
                    Element tests = doc.getDocumentElement();
                    NodeList testElems = tests.getChildNodes();
                    int nChildren = testElems.getLength();
                    int testid = 0;
                    for (int i = 0; i < nChildren; i++) {
                        org.w3c.dom.Node node = testElems.item(i);
                        if (org.w3c.dom.Node.ELEMENT_NODE == node.getNodeType()) {
                            testid++;
                            String xpathString = ((Element) node)
                                    .getAttribute("value");
                            if (dumpTree)
                                System.err.println("Test[" + testid + "]: "
                                        + xpathString);
                            XPath parser = new XPath(
                                    new java.io.StringBufferInputStream(
                                            xpathString));
                            SimpleNode tree = parser.XPath2();
                            if (dumpTree)
                                tree.dump("|");
                        }
                    }
                    break;
                }

                System.out.println("Test successful!!!");
             } catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}