/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import org.apache.xalan.xsltc.trax.TransformerHandlerImpl;
import org.apache.xalan.xsltc.trax.TransformerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class TrAXFilter
extends XMLFilterImpl {
    private Templates _templates;
    private TransformerHandlerImpl _transformer;

    public TrAXFilter(Templates templates) throws TransformerConfigurationException {
        this._templates = templates;
        this._transformer = new TransformerHandlerImpl((TransformerImpl)templates.newTransformer());
    }

    private void createParent() throws SAXException {
        XMLReader parent = null;
        try {
            SAXParserFactory pfactory = SAXParserFactory.newInstance();
            pfactory.setNamespaceAware(true);
            SAXParser saxparser = pfactory.newSAXParser();
            parent = saxparser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new SAXException(e.toString());
        }
        if (parent == null) {
            parent = XMLReaderFactory.createXMLReader();
        }
        this.setParent(parent);
    }

    public void parse(InputSource input) throws SAXException, IOException {
        if (this.getParent() == null) {
            try {
                this.createParent();
            }
            catch (SAXException e) {
                throw new SAXException(e.toString());
            }
        }
        this.getParent().parse(input);
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    public void setContentHandler(ContentHandler handler) {
        this._transformer.setResult(new SAXResult(handler));
        if (this.getParent() == null) {
            try {
                this.createParent();
            }
            catch (SAXException e) {
                return;
            }
        }
        this.getParent().setContentHandler(this._transformer);
    }

    public void setErrorListener(ErrorListener handler) {
    }
}

