/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.DOMCache;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.dom.DOMAdapter;
import org.apache.xalan.xsltc.dom.MultiDOM;
import org.apache.xalan.xsltc.dom.SAXImpl;
import org.apache.xalan.xsltc.dom.SingletonIterator;
import org.apache.xalan.xsltc.dom.UnionIterator;
import org.apache.xalan.xsltc.dom.XSLTCDTMManager;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.EmptyIterator;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class LoadDocument {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";

    public static DTMAxisIterator documentF(Object arg1, DTMAxisIterator arg2, String xslURI, AbstractTranslet translet, DOM dom) throws TransletException {
        String baseURI = null;
        int arg2FirstNode = arg2.next();
        if (arg2FirstNode == -1) {
            return EmptyIterator.getInstance();
        }
        baseURI = LoadDocument.getBaseFromURI(dom.getDocumentURI(arg2FirstNode));
        try {
            if (arg1 instanceof String) {
                if (((String)arg1).length() == 0) {
                    return LoadDocument.document(xslURI, "", translet, dom);
                }
                return LoadDocument.document((String)arg1, baseURI, translet, dom);
            }
            if (arg1 instanceof DTMAxisIterator) {
                return LoadDocument.document((DTMAxisIterator)arg1, baseURI, translet, dom);
            }
            String err = "document(" + arg1.toString() + ")";
            throw new IllegalArgumentException(err);
        }
        catch (Exception e) {
            throw new TransletException(e);
        }
    }

    public static DTMAxisIterator documentF(Object arg, String xslURI, AbstractTranslet translet, DOM dom) throws TransletException {
        try {
            if (arg instanceof String) {
                if (((String)arg).length() == 0) {
                    return LoadDocument.document(xslURI, "", translet, dom);
                }
                return LoadDocument.document((String)arg, LoadDocument.getBaseFromURI(xslURI), translet, dom);
            }
            if (arg instanceof DTMAxisIterator) {
                return LoadDocument.document((DTMAxisIterator)arg, null, translet, dom);
            }
            String err = "document(" + arg.toString() + ")";
            throw new IllegalArgumentException(err);
        }
        catch (Exception e) {
            throw new TransletException(e);
        }
    }

    private static DTMAxisIterator document(String uri, String base, AbstractTranslet translet, DOM dom) throws Exception {
        DOM newdom;
        DOM newDom;
        int mask;
        File file;
        String originalUri = uri;
        MultiDOM multiplexer = (MultiDOM)dom;
        if (uri == null || uri.equals("")) {
            return EmptyIterator.getInstance();
        }
        if (!(base == null || base.equals("") || uri.startsWith(base) || uri.startsWith("/") || uri.startsWith("http:/") || uri.startsWith("file:/"))) {
            uri = base + uri;
        }
        if ((file = new File(uri)).exists()) {
            uri = file.toURL().toExternalForm();
        }
        if ((mask = multiplexer.getDocumentMask(uri)) != -1 && (newDom = ((DOMAdapter)multiplexer.getDOMAdapter(uri)).getDOMImpl()) instanceof SAXImpl) {
            return new SingletonIterator(((SAXImpl)newDom).getDocument(), true);
        }
        DOMCache cache = translet.getDOMCache();
        mask = multiplexer.nextMask();
        if (cache != null) {
            newdom = cache.retrieveDocument(uri, mask, translet);
            if (newdom == null) {
                FileNotFoundException e = new FileNotFoundException(originalUri);
                throw new TransletException(e);
            }
        } else {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser2 = factory.newSAXParser();
            XMLReader reader = parser2.getXMLReader();
            try {
                reader.setFeature(NAMESPACE_FEATURE, true);
            }
            catch (Exception e) {
                throw new TransletException(e);
            }
            XSLTCDTMManager dtmManager = (XSLTCDTMManager)((DTMDefaultBase)((Object)((DOMAdapter)multiplexer.getMain()).getDOMImpl())).m_mgr;
            newdom = (SAXImpl)dtmManager.getDTM(new SAXSource(reader, new InputSource(uri)), false, null, true, false, translet.hasIdCall());
            translet.prepassDocument(newdom);
            ((SAXImpl)newdom).setDocumentURI(uri);
        }
        DOMAdapter domAdapter = translet.makeDOMAdapter(newdom);
        multiplexer.addDOMAdapter(domAdapter);
        translet.buildKeys(domAdapter, null, null, ((SAXImpl)newdom).getDocument());
        return new SingletonIterator(((SAXImpl)newdom).getDocument(), true);
    }

    private static DTMAxisIterator document(DTMAxisIterator arg1, String baseURI, AbstractTranslet translet, DOM dom) throws Exception {
        UnionIterator union = new UnionIterator(dom);
        int node = -1;
        while ((node = arg1.next()) != -1) {
            String uri = dom.getStringValueX(node);
            if (baseURI == null) {
                baseURI = LoadDocument.getBaseFromURI(dom.getDocumentURI(node));
            }
            union.addIterator(LoadDocument.document(uri, baseURI, translet, dom));
        }
        return union;
    }

    private static String getBaseFromURI(String uri) {
        int backwardSep = uri.lastIndexOf(92) + 1;
        int forwardSep = uri.lastIndexOf(47) + 1;
        return uri.substring(0, Math.max(backwardSep, forwardSep));
    }
}

