<Module> ::=
      <OptionalVersionDecl> <MainModule> 
    |
      <OptionalVersionDecl> <LibraryModule> 


<OptionalVersionDecl> ::=
      !empty 
    |
      xquery version StringLiteral <OptionalEncodingDeclaration> SemiColon 

<OptionalEncodingDeclaration> ::= !empty 
    |
      encoding StringLiteral  

<LibraryModule> ::=
      <ModuleDecl> <Prolog> 

<ModuleDecl> ::=
      module namespace <NCName> Equals StringLiteral SemiColon 

-- MAIN RULE

<MainModule> ::= <Prolog> <QueryBody> 
 
-- PROLOG

<Prolog> ::= <Setters> <NamespaceAndImports> <Declarations> 

<Setters> ::= !empty 
 |
   <Setters> <Setter> SemiColon 

<Setter> ::=  <XMLSpaceDecl> 
    |
      <DefaultCollationDecl>   
    |
      <BaseURIDecl> 
    |
      <ConstructionDecl> 
    |
      <OrderingModeDecl> 
    |
      <EmptyOrderingDecl> 
    |
      <InheritNamespacesDecl> 
  |
      <DefaultNamespaceDecl>   

<NamespaceAndImports> ::=  !empty 
   |
     <NamespaceAndImports> <NamespaceOrImport> SemiColon 

<NamespaceOrImport> ::=  <NamespaceDecl> 
    |
      <SchemaImport> 
    |
      <ModuleImport> 
  

<Declarations> ::= !empty
    |
     <Declarations> <Decl> SemiColon 

<Decl> ::=  <VarDecl> 
    |
      <FunctionDecl> 

<NCName> ::= QName  

<NamespaceDecl> ::= declare namespace <NCName> Equals StringLiteral

<XMLSpaceDecl> ::= declare xmlspace preserve
    | declare xmlspace strip

<DefaultNamespaceDecl> ::= declare default element namespace StringLiteral 
    | declare default function namespace StringLiteral 

<OrderingModeDecl> ::= declare ordering ordered
    | declare ordering unordered

<EmptyOrderingDecl> ::= declare default order <EmptyOrderingVal> 

<EmptyOrderingVal> ::= empty greatest
    | empty least

<InheritNamespacesDecl> ::= declare inherit_namespaces no
     /. !sem_act_head
	sem_number = SQLNP_XQA_INHERITNS_NO;
	!sem_action ./
    | declare inherit_namespaces yes
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
   
<DefaultCollationDecl> ::= declare default collation StringLiteral 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<BaseURIDecl> ::= declare base_uri StringLiteral 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<ConstructionDecl> ::= declare construction preserve
      /. !sem_act_head	
      sem_number = SQLNP_XQA_CONSTRUCTION_PRESERVE;
      !sem_action ./
    | declare construction strip
      /. !sem_act_head	
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<SchemaImport> ::= import schema StringLiteral <At_optional> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | import schema namespace <NCName> Equals StringLiteral <At_optional> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | import schema default element namespace StringLiteral <At_optional> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<At_optional> ::= !empty 
    | at <StringLiteralList>  

<StringLiteralList> ::= StringLiteral 
    | <StringLiteralList> Comma StringLiteral 

<ModuleImport> ::= import module StringLiteral <At_optional> 
    | import module namespace <NCName> Equals StringLiteral <At_optional> 

<VarDecl> ::= declare variable <Variable> <OptionalTypeDeclaration> external 
    | declare variable <Variable> <OptionalTypeDeclaration> ColonEquals <ExprSingle>

<FunctionDecl> ::=
      declare function QName Lpar <ParamList_optional> Rpar <OptionalTypeDeclaration> <EnclosedExpr> 
    | declare function QName Lpar <ParamList_optional> Rpar <OptionalTypeDeclaration> external 

<ParamList_optional> ::= !empty 
    | <ParamList> 

<ParamList> ::= <Param> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | <ParamList> Comma <Param> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<Param> ::=
      <Variable> <OptionalTypeDeclaration> 

<EnclosedExpr> ::= Lbrace <Expr> Rbrace                      
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ENCLOSED_EXPR;
                        !sem_action ./
-- QUERY BODY

<QueryBody> ::= <Expr> 
    /. !sem_act_head
    sem_number = SQLNP_XQA_QUERY_TOP;
    !sem_action ./

<Expr> ::= <ExprSingle> 
          /. !sem_act_head
          sem_number = SQLNP_XQA_EXPR_SEQUENCE_ONE;
          !sem_action ./
    | <Expr> Comma <ExprSingle> 
          /. !sem_act_head
          sem_number = SQLNP_XQA_EXPR_SEQUENCE;
          !sem_action ./

<ExprSingle> ::= <FLWORExpr> 
      | <QuantifiedExpr> 
      | <TypeswitchExpr> 
      | <IfExpr> 
      | <OrExpr> 

-- FLWORExpr EXPRESSION

<FLWORExpr> ::= <ForLetClause_list_top> <WhereClause_optional>
    <OrderBy_optional> <ReturnClause> 
             /. !sem_act_head                
             sem_number = SQLNP_XQA_EXPR_END;
             !sem_action ./

<ReturnClause> ::= return <ExprSingle> 
             /. !sem_act_head  
             sem_number = SQLNP_XQA_RETURN;
             !sem_action ./

<ForLetClause_list_top> ::= <ForLetClause_list> 
            /. !sem_act_head
            sem_number = SQLNP_XQA_FORLET_END;
            !sem_action ./

<ForLetClause_list> ::= <ForLetClause> 
    | <ForLetClause_list> <ForLetClause> 

<ForLetClause> ::= <ForClause> 
    | <LetClause> 

<ForClause> ::= <for_keyword> <ForClause_list> 

<for_keyword> ::= for 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FORLET_BEGIN;
       !sem_action ./

<ForClause_list> ::= <ForClauseBinding> 
    | <ForClause_list> Comma <ForClauseBinding> 

<ForClauseBinding> ::= <Variable> <OptionalTypeDeclaration> <OptionalPositionalVar>
        <in_keyword> <ExprSingle> 
              /. !sem_act_head
              sem_number = SQLNP_XQA_FOR_BINDING;
              !sem_action ./

<OptionalTypeDeclaration> ::= !empty 
    | as <SequenceType> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<OptionalPositionalVar> ::= !empty 
    | at <Variable> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_POS_VAR;
      !sem_action ./

<in_keyword> ::= in 
     /. !sem_act_head
     sem_number = SQLNP_XQA_IN;
     !sem_action ./

<LetClause> ::= <let_keyword> <LetClause_list> 

<let_keyword> ::= let
     /. !sem_act_head
     sem_number = SQLNP_XQA_FORLET_BEGIN;
     !sem_action ./

<LetClause_list> ::= <LetClauseBinding> 
    | <LetClause_list> Comma <LetClauseBinding> 

<LetClauseBinding> ::= <Variable>  <OptionalTypeDeclaration> <var_asgnmnt> <ExprSingle>  
       /. !sem_act_head
       sem_number = SQLNP_XQA_LET_BINDING;
       !sem_action ./

<var_asgnmnt> ::= ColonEquals
            /. !sem_act_head
            sem_number = SQLNP_XQA_LET_ASGNMNT;
            !sem_action ./

<WhereClause_optional> ::= !empty                      -- @Bd040906foz
	/. !sem_act_head
            sem_number = SQLNP_XQA_FORLETWHERE_END;
            !sem_action ./
    | <WhereClause> 
	/. !sem_act_head
            sem_number = SQLNP_XQA_FORLETWHERE_END;
            !sem_action ./                              -- @Ed040906foz

<WhereClause> ::= where <ExprSingle>
            /. !sem_act_head
            sem_number = SQLNP_XQA_WHERE;
            !sem_action ./

                                           -- @Bd040906foz
<OrderBy_optional> ::= !empty 
    | <OrderByClause> 

<OrderByClause> ::= <OrderKeywords> <OrderBySpecList>
	     /. !sem_act_head
            sem_number = SQLNP_XQA_ORDERBY;
            !sem_action ./ 

<OrderKeywords> ::= order by
	     /. !sem_act_head
	     sem_number = SQLNP_XQA_ORDERBY_KEYWORD;
            !sem_action ./            
         |  stable order by 
	     /. !sem_act_head
	     sem_number = SQLNP_XQA_UNSUPPORTED_ORDER_OPT;
            !sem_action ./

<OrderBySpecList> ::= <OrderSpec> 
	                                     	
    | <OrderBySpecList> Comma <OrderSpec> 
	                                      

<OrderSpec> ::= <OrderExpr> <OrderModifier> 

<OrderExpr> ::= <ExprSingle> 
             /. !sem_act_head
             sem_number = SQLNP_XQA_ORDER_ASC;
             !sem_action ./
    | <ExprSingle>  ascending 
             /. !sem_act_head
             sem_number = SQLNP_XQA_ORDER_ASC;
             !sem_action ./
    | <ExprSingle>  descending 
             /. !sem_act_head
             sem_number = SQLNP_XQA_ORDER_DESC;
             !sem_action ./

<OrderModifier> ::= <EmptyGreatestOrLeast_optional> <CollationSpec_optional>  

<EmptyGreatestOrLeast_optional> ::= !empty   
    | empty greatest 
              /. !sem_act_head
              sem_number = SQLNP_XQA_UNSUPPORTED_ORDER_OPT;
             !sem_action ./
    | empty least 
              /. !sem_act_head
              sem_number = SQLNP_XQA_UNSUPPORTED_ORDER_OPT;
             !sem_action ./

<CollationSpec_optional> ::=  !empty 
   | collation  StringLiteral 
              /. !sem_act_head
              sem_number = SQLNP_XQA_UNSUPPORTED_ORDER_OPT;
             !sem_action ./        

                                                            --@Ed040906foz

-- QUANTIFIED EXPRESSION

<QuantifiedExpr> ::= <Quantifier> <QuantifiedVariableBindings> <QuantifiedTestExpr> 
            /. !sem_act_head
            sem_number = SQLNP_XQA_QUANTIFIED_EXPRESSION; 
            !sem_action ./

<Quantifier> ::= every 
          /. !sem_act_head
          sem_number = SQLNP_XQA_QUANTIFIED_EVERY;
          !sem_action ./
    | some 
          /. !sem_act_head
         sem_number = SQLNP_XQA_QUANTIFIED_SOME;
         !sem_action ./

<QuantifiedVariableBindings> ::=  <QuantifiedVariableBindingList>  
         /. !sem_act_head
         sem_number = SQLNP_XQA_QUANTIFIED_BINDING_END;
         !sem_action ./

<QuantifiedVariableBindingList> ::= <QuantifiedVariableBinding>  
    | <QuantifiedVariableBindingList> Comma <QuantifiedVariableBinding> 
         /. !sem_act_head
         sem_number = SQLNP_XQA_QUANTIFIED_BINDING_MULTIPLE;
         !sem_action ./

<QuantifiedVariableBinding> ::= <Variable> <OptionalTypeDeclaration> <in_keyword> <ExprSingle> 
        /. !sem_act_head
        sem_number = SQLNP_XQA_QUANTIFIED_BINDING;
        !sem_action ./
      
<QuantifiedTestExpr> ::= satisfies <ExprSingle> 
        /. !sem_act_head
        sem_number = SQLNP_XQA_QUANTIFIED_TEST_EXPR;
        !sem_action ./

-- TYPESWITCH EXPRESSION

<TypeswitchExpr> ::= typeswitch Lpar <Expr> Rpar <CaseClause_list> default <OptionalVariable> return <ExprSingle> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<OptionalVariable> ::= !empty 
    |
      <Variable> 

<CaseClause_list> ::= <CaseClause> 
    | <CaseClause_list> <CaseClause> 

<CaseClause> ::= case <Variable> as <SequenceType> return <ExprSingle> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | case <SequenceType> return <ExprSingle> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

-- IF EXPRESSION

<IfExpr> ::= if Lpar <Expr> Rpar then <ExprSingle> else <ExprSingle> 
         /. !sem_act_head
         sem_number = SQLNP_XQA_IF_EXPR;
         !sem_action ./

-- OR EXPRESSION AND HIGHER PRECEDENCE OPERATORS

<OrExpr> ::= <AndExpr>  
    | <OrExpr> or <AndExpr> 
         /. !sem_act_head
         sem_number = SQLNP_XQA_OR_EXPR;
         !sem_action ./

<AndExpr> ::= <AndExpr> and <ComparisonExpr> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_AND_EXPR;
      !sem_action ./
    | <ComparisonExpr> 

<ComparisonExpr> ::=                                -- @db040206mmj
      <RangeExpr> <ValueComp> <RangeExpr>   /. !sem_act_head
            sem_number = SQLNP_XQA_VALUE_COMPARISON;
            !sem_action ./                          -- @de040206mmj
    | <RangeExpr> <GeneralComp> <RangeExpr> 
        /. !sem_act_head
            sem_number = SQLNP_XQA_GEN_COMP;
            !sem_action ./
    | <RangeExpr> <NodeComp> <RangeExpr> 
        /. !sem_act_head
            sem_number = SQLNP_XQA_NODE_COMP;
           !sem_action ./
    | <RangeExpr> 

<RangeExpr> ::=
      <AdditiveExpr> to <AdditiveExpr> 
      /. !sem_act_head
       sem_number = SQLNP_XQA_RANGE_EXPR;
      !sem_action ./
    | <AdditiveExpr> 

<AdditiveExpr> ::= <AdditiveExpr> Plus <MultiplicativeExpr> 
        /. !sem_act_head
        sem_number = SQLNP_XQA_Addition;
        !sem_action ./
    | <AdditiveExpr> Minus <MultiplicativeExpr> 
        /. !sem_act_head
        sem_number = SQLNP_XQA_Subtraction;
        !sem_action ./
    | <MultiplicativeExpr> 

<MultiplicativeExpr> ::= <MultiplicativeExpr> <MultiplicativeOpr> <UnionExpr> 
         /. !sem_act_head
         sem_number = SQLNP_XQA_MultiplicativeExpr;
         !sem_action ./
    | <UnionExpr> 

<MultiplicativeOpr> ::= Mul 
        /. !sem_act_head
        sem_number = SQLNP_XQA_Multiplication;
        !sem_action ./
    | div 
        /. !sem_act_head
        sem_number = SQLNP_XQA_Division;
        !sem_action ./
    | idiv 
        /. !sem_act_head
        sem_number = SQLNP_XQA_IntDivision;
        !sem_action ./         
    | mod 
        /. !sem_act_head
        sem_number = SQLNP_XQA_Mod;
        !sem_action ./

<UnionExpr> ::= <UnionExpr> union <IntersectExceptExpr>  
       /. !sem_act_head	
       sem_number = SQLNP_XQA_UNION;
       !sem_action ./   
    | <UnionExpr> Vbar <IntersectExceptExpr> 
       /. !sem_act_head	
       sem_number = SQLNP_XQA_UNION;
       !sem_action ./   
    | <IntersectExceptExpr> 

<IntersectExceptExpr> ::= <IntersectExceptExpr> intersect <InstanceofExpr>
      /. !sem_act_head
      sem_number = SQLNP_XQA_INTERSECT;
      !sem_action ./
    | <IntersectExceptExpr> except <InstanceofExpr>
      /. !sem_act_head
      sem_number = SQLNP_XQA_EXCEPT;
      !sem_action ./
    | <InstanceofExpr> 

<InstanceofExpr> ::= <TreatExpr> instance of <SequenceType> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | <TreatExpr> 

<TreatExpr> ::= <CastableExpr> treat as <SequenceType> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | <CastableExpr> 

<CastableExpr> ::= <CastExpr> castable as <SingleType> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./
    | <CastExpr> 
      
<CastExpr> ::= <UnaryExpr> cast as <AtomicType> <OptionalQuestionMark> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_CAST_EXPR;
      !sem_action ./
    | <UnaryExpr> 

<SingleType> ::= <AtomicType> <OptionalQuestionMark> 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<OptionalQuestionMark> ::= !empty 
    | QMark 

<UnaryExpr> ::= Minus <ValueExpr>
        /. !sem_act_head
        sem_number = SQLNP_XQA_UNARY_MINUS;
        !sem_action ./
    | Plus  <ValueExpr>
        /. !sem_act_head
        sem_number = SQLNP_XQA_UNARY_PLUS;
        !sem_action ./
    | <ValueExpr> 

<ValueExpr> ::= <ValidateExpr> 
    | <PathExpr> 
        /.!sem_act_head
        sem_number = SQLNP_XPA_ROOTEDPATHEXPR;
        !sem_action ./

<GeneralComp> ::= Equals 
       /. !sem_act_head
       sem_number = SQLNP_XQA_GenEQ_OPERATOR;
       !sem_action ./
    | NotEquals 
       /. !sem_act_head
       sem_number = SQLNP_XQA_GenNEQ_OPERATOR;
       !sem_action ./
    | LessThan 
       /. !sem_act_head
       sem_number = SQLNP_XQA_GenLT_OPERATOR;
       !sem_action ./
    | LtEquals 
       /. !sem_act_head
       sem_number = SQLNP_XQA_GenLTE_OPERATOR;
       !sem_action ./
    | GreaterThan 
       /. !sem_act_head
       sem_number = SQLNP_XQA_GenGT_OPERATOR;
       !sem_action ./
    | GtEquals  
       /. !sem_act_head
       sem_number = SQLNP_XQA_GenGTE_OPERATOR;
       !sem_action ./
                                                  -- @db040303mmj
<ValueComp> ::= eq /. !sem_act_head
       sem_number = SQLNP_XQA_ValEQ_OPERATOR;
       !sem_action ./
    | ne /. !sem_act_head
       sem_number = SQLNP_XQA_ValNEQ_OPERATOR;
       !sem_action ./
    | lt /. !sem_act_head
       sem_number = SQLNP_XQA_ValLT_OPERATOR;
       !sem_action ./
    | le /. !sem_act_head
       sem_number = SQLNP_XQA_ValLTE_OPERATOR;
       !sem_action ./
    | gt /. !sem_act_head
       sem_number = SQLNP_XQA_ValGT_OPERATOR;
       !sem_action ./
    | ge /. !sem_act_head
       sem_number = SQLNP_XQA_ValGTE_OPERATOR;
       !sem_action ./
                                                 -- @de040303mmj
<NodeComp> ::= is 
      /. !sem_act_head
      sem_number = SQLNP_XQA_NODE_IS_OPERATOR;
      !sem_action ./
    | LtLt 
      /. !sem_act_head
      sem_number = SQLNP_XQA_NODE_BEFORE_OPERATOR;
      !sem_action ./
    | GtGt 
      /. !sem_act_head
      sem_number = SQLNP_XQA_NODE_AFTER_OPERATOR;
      !sem_action ./

-- VALIDATE EXPRESSION

<ValidateExpr> ::= validate <OptionalValidationMode> Lbrace <Expr> Rbrace 
      /. !sem_act_head
      sem_number = SQLNP_XQA_FUTURE_RELEASE;
      !sem_action ./

<OptionalValidationMode> ::= !empty 
    | lax 
    | strict 

-- PATH EXPRESSION

<PathExpr> ::= <SlashSlash> <RelativePathExpr>
      /. !sem_act_head
      sem_number = SQLNP_XPA_ABSDESLOCPATH;
      !sem_action ./
    | <Slash> <RelativePathExpr> 
      /. !sem_act_head
      sem_number = SQLNP_XPA_ABSLOCPATH;
      !sem_action ./
    | <Slash>
      /. !sem_act_head
      sem_number = SQLNP_XPA_ABSROOTONLY;
      !sem_action ./
    | <RelativePathExpr> 

<Slash> ::= Slash
    /. !sem_act_head
       sem_number = SQLNP_XPA_SLASH;
       !sem_action ./

<SlashSlash> ::= SlashSlash
    /. !sem_act_head
       sem_number = SQLNP_XPA_SLASHSLASH;
       !sem_action ./

<RelativePathExpr> ::=  <RelativePathExpr> <Slash> <StepExpr> 
       /. !sem_act_head
       sem_number = SQLNP_XPA_MULTIPLE_STEP_CHILD;
       !sem_action ./
    | <RelativePathExpr> <SlashSlash> <StepExpr> 
       /. !sem_act_head
       sem_number = SQLNP_XPA_MULTIPLE_STEP_DESC;
       !sem_action ./
    | <StepExpr>  

<StepExpr> ::= <StepExpr> <Predicate>
       /. !sem_act_head
       sem_number = SQLNP_XPA_MULTIPLE_STEP_PRED;
       !sem_action ./
    | <AxisOrFilterStepNoPredicates>
       /. !sem_act_head
       sem_number = SQLNP_XPA_AXIS_FILTER_STEP_EXPR;
       !sem_action ./

<AxisOrFilterStepNoPredicates> ::= <AxisStepNoPredicates> 
    | <FilterStepNoPredicates> 

<AxisStepNoPredicates> ::= <ForwardStep>
       /. !sem_act_head
       sem_number = SQLNP_XPA_STEP_EXPR1;
       !sem_action ./       
     | <ReverseStep>
       /. !sem_act_head
       sem_number = SQLNP_XPA_STEP_EXPR1;
       !sem_action ./

<ForwardStep> ::= <ForwardAxis> <NodeTest> 
       /. !sem_act_head
       sem_number = SQLNP_XPA_STEP;
       !sem_action ./ 
    | <AbbreviatedForwardStep> 

<ReverseStep> ::= <ReverseAxis> <NodeTest> 
       /. !sem_act_head
       sem_number = SQLNP_XPA_STEP;
       !sem_action ./ 
    | <AbbreviatedReverseStep> 

<ForwardAxis> ::= child ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XPA_CHILD_AXIS;
        !sem_action ./
    | descendant ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XPA_DESCENDANT_AXIS;
        !sem_action ./
    | attribute ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XPA_ATTRIBUTE_AXIS;
        !sem_action ./
    | self ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XPA_SELF_AXIS;
        !sem_action ./
    | descendant_or_self ColonColon     
        /. !sem_act_head
        sem_number = SQLNP_XPA_DESCENDANTORSELF_AXIS;
        !sem_action ./
    | following_sibling ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./
    | following ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./

<ReverseAxis> ::= parent ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_PARENT_RELEASE;
        !sem_action ./
    | ancestor ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./
    | preceding_sibling ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./
    | preceding ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./
    | ancestor_or_self ColonColon 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./

<AbbreviatedForwardStep> ::=
      AtSymbol <NodeTest>  /. !sem_act_head
         sem_number = SQLNP_XPA_ABR_ATTR_STEP;
         !sem_action ./
    |
      <NodeTest>  /. !sem_act_head
         sem_number = SQLNP_XPA_ABR_CHILD_STEP;
         !sem_action ./

<AbbreviatedReverseStep> ::= DotDot    /. !sem_act_head
         sem_number = SQLNP_XPA_ABR_PARENT_STEP;
         !sem_action ./

<NodeTest> ::= <NameTest> 
    | <KindTest> 


<FilterStepNoPredicates> ::= <PrimaryExpr> 

<PrimaryExpr> ::= <Literal>  
    | <Variable>
          /. !sem_act_head
          sem_number = SQLNP_XQA_VAR_REF;
          !sem_action ./
    | <ParenthesizedExpr>  
    | <ContextItemExpr>
          /. !sem_act_head
          sem_number = SQLNP_XPA_CONTEXT_ITEM_EXPR;
          !sem_action ./
    | <FunctionCall>
          /. !sem_act_head
          sem_number = SQLNP_XQA_FUNC_CALL;
          !sem_action ./
    | <Constructor>  
    | <OrderedExpr>
          /. !sem_act_head
          sem_number = SQLNP_XQA_FUTURE_RELEASE;
          !sem_action ./
    | <UnorderedExpr>
          /. !sem_act_head
          sem_number = SQLNP_XQA_FUTURE_RELEASE;
          !sem_action ./

<Literal> ::= <NumericLiteral> 
    | StringLiteral /. !sem_act_head_id
        sem_number = SQLNP_XQA_STR_LITERAL;
       !sem_action ./

<NumericLiteral> ::=
      IntegerLiteral /. !sem_act_head_id
                     sem_number = SQLNP_XQA_INT_LITERAL;
                     !sem_action ./
    |
      DecimalLiteral /. !sem_act_head_id
                     sem_number = SQLNP_XQA_DEC_LITERAL;
                     !sem_action ./   
    |
      DoubleLiteral /. !sem_act_head_id
                    sem_number = SQLNP_XQA_DOUBLE_LITERAL;
                    !sem_action ./

<Variable> ::=
      XQVariable /. !sem_act_head_id
          sem_number = SQLNP_XQA_VAR;
          !sem_action ./

<ParenthesizedExpr> ::= Lpar <Expr_optional> Rpar
         /. !sem_act_head
         sem_number = SQLNP_XQA_PARENTHESIZED_EXPR;
         !sem_action ./

<OrderedExpr> ::= ordered Lbrace <Expr> Rbrace
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./

<UnorderedExpr> ::= unordered Lbrace <Expr> Rbrace
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
        !sem_action ./

<FunctionCall> ::= QName Lpar <FuncCallParams_optional> Rpar
        /. !sem_act_head
        sem_number = SQLNP_XQA_QNAME_FUNC_CALL;
        !sem_action ./

<FuncCallParams_optional> ::= !empty 
    | <FuncCallParams>  

<FuncCallParams> ::= <ExprSingle> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUNC_CALL_PARAMS_ONE;
       !sem_action ./
    | <FuncCallParams> Comma <ExprSingle> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUNC_CALL_PARAMS;
       !sem_action ./

<Expr_optional> ::= !empty 
    | <Expr> 

<ContextItemExpr> ::= Dot  

<Predicate> ::= <LeftBracket> <Expr> Rbrack
      /. !sem_act_head
      sem_number = SQLNP_XQA_QUALIFIER;
      !sem_action ./

<LeftBracket> ::= Lbrack
      /. !sem_act_head
      sem_number = SQLNP_XPA_LEFT;
      !sem_action ./

<NameTest> ::= QName   
      /. !sem_act_head
      sem_number = SQLNP_XPA_NAME_TEST;
      !sem_action ./
    | <Wildcard> 

<Wildcard> ::= Star 
       /. !sem_act_head
       sem_number = SQLNP_XPA_WILDCARD_TEST;
       !sem_action ./
    | NCNameColonStar                                     --@d040108ns
     /. !sem_act_head
        sem_number = SQLNP_XPA_NCNAME_COLON_STAR;
        !sem_action ./
    | StarColonNCName
     /. !sem_act_head
        sem_number = SQLNP_XPA_STAR_COLON_NCNAME;
        !sem_action ./

-- SEQUENCE TYPE

<SequenceType> ::= <ItemType> <OccurrenceIndicator> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./
    | <ItemType> 
    | empty Lpar Rpar 

<ItemType> ::= <AtomicType> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./
    | <KindTest> 
    | item Lpar Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./

<AtomicType> ::= QName  
    /. !sem_act_head
       sem_number = SQLNP_XQA_QNAME;
       !sem_action ./

<OccurrenceIndicator> ::= Star 
--   | Plus 
    | QMark 

<KindTest> ::= <PITest> 
    | <CommentTest> 
    | <TextTest> 
    | <AnyKindTest> 
    | <DocumentTest> 
    | <ElementTest> 
    | <AttributeTest> 
    | <SchemaElementTest> 
    | <SchemaAttributeTest> 

<PITest> ::= processing_instruction Lpar <PIValue_optional> Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XPA_PI_TEST;      
       !sem_action ./   -- @d040330foz

<PIValue_optional> ::= !empty 
    | <NCName> 
    | StringLiteral 

<CommentTest> ::= comment Lpar Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XPA_COMMENT_TEST;  
       !sem_action ./ -- @d040330foz

<TextTest> ::= text Lpar Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XPA_TEXT_TEST;
       !sem_action ./

<AnyKindTest> ::= node Lpar Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XPA_NODE_TEST;
       !sem_action ./

<DocumentTest> ::= document_node Lpar Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XPA_DOC_TEST;      
       !sem_action ./  -- @d040330foz
    | document_node Lpar <ElementTest> Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./
    | document_node Lpar <SchemaElementTest> Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./

<ElementTest> ::= element Lpar Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XPA_ELEM_TEST;       
       !sem_action ./   -- @d040330foz
    | element Lpar <ElementNameOrWildcard> Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XPA_ELEM_NAME_TEST;
       !sem_action ./
    | element Lpar <ElementNameOrWildcard> Comma <TypeNameAndOptQMark> Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./


<AttributeTest> ::= attribute Lpar Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XPA_ATTR_TEST;      
       !sem_action ./ -- @d040330foz
    | attribute Lpar <AttribNameOrWildcard> Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XPA_ATTR_NAME_TEST;
       !sem_action ./
    | attribute Lpar <AttribNameOrWildcard> Comma <TypeNameAndOptQMark> Rpar 
       /. !sem_act_head
       sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./

<SchemaElementTest> ::= schema_element Lpar QName Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XQA_FUTURE_RELEASE;      
       !sem_action ./

<SchemaAttributeTest> ::= schema_attribute Lpar QName Rpar 
       /. !sem_act_head
	sem_number = SQLNP_XQA_FUTURE_RELEASE;      
       !sem_action ./

<ElementNameOrWildcard> ::= QName 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./
    | Star  
        /. !sem_act_head
        sem_number = SQLNP_XPA_WILDCARD_TEST;
       !sem_action ./

<AttribNameOrWildcard> ::= QName 
        /. !sem_act_head
        sem_number = SQLNP_XQA_FUTURE_RELEASE;
       !sem_action ./
    | Star  
        /. !sem_act_head
        sem_number = SQLNP_XPA_WILDCARD_TEST;
       !sem_action ./

<TypeNameAndOptQMark> ::= QName 
    | QName QMark  

-- CONSTRUCTORS

<Constructor> ::= <DirectConstructor> 
    | <ComputedConstructor> 

<DirectConstructor> ::= <DirElementConstructor> 
    | <DirCommentConstructor> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_COMMENT;
       !sem_action ./
    | <DirProcessingInstructionConstructor> 


<ComputedConstructor> ::= <ComputedElementConstructor> 
    | <ComputedAttributeConstructor> 
    | <ComputedPI> 
    | <ComputedComment> 
    | <ComputedText> 
    | <ComputedDocument> 

<DirElementConstructor> ::= <StartTag> <AttributeList_opt>  EmptyTagClose 
         /. !sem_act_head
         sem_number = SQLNP_XQA_ELEMENT_EMPTY;
         !sem_action ./
      | <StartTag> <AttributeList_opt> StartTagClose <ElementContent_optionalList> EndTagOpen <TagQName> EndTagClose 
         /. !sem_act_head
         sem_number = SQLNP_XQA_ELEMENT;
         !sem_action ./

<StartTag> ::= StartTagOpen <TagQName> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_ELEMENT_START_TAG;
       !sem_action ./

<TagQName> ::= QName 
       /. !sem_act_head
       sem_number = SQLNP_XQA_QNAME;
       !sem_action ./

<ElementContent_optionalList> ::= !empty 
    | <ElementContent_list> 

<ElementContent_list> ::= <ElementContent> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_ELEMENT_CONTENT_ONE;
       !sem_action ./
    | <ElementContent_list> <ElementContent> 
       /. !sem_act_head
       sem_number = SQLNP_XQA_ELEMENT_CONTENT_LIST;
       !sem_action ./

<ElementContent> ::= ElementContent
       /. !sem_act_head
       sem_number = SQLNP_XQA_CHAR;
       !sem_action ./
    | WhitespaceContent
       /. !sem_act_head
       sem_number = SQLNP_XQA_WHITESPACE_CONTENT;
       !sem_action ./
    | CdataSection 
       /. !sem_act_head
       sem_number = SQLNP_XQA_CDATA;
       !sem_action ./
    | <DirectConstructor> 
    | <EnclosedExpr> 

<AttributeList_opt> ::= !empty 
    | <AttributeList> /. !sem_act_head
                          sem_number = SQLNP_XQA_XML_ATTRIBUTES;
                         !sem_action ./

<AttributeList> ::= <AttributeConstructor> 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTRIBUTE_ONE;
                        !sem_action ./
    | <AttributeList> <AttributeConstructor>
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTRIBUTE_LIST;
                        !sem_action ./

<AttributeConstructor> ::= <TagQName> Equals <AttributeValue> 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTRIBUTE_CONS;
                        !sem_action ./

<AttributeValue> ::= Quote <AttributeValueContent_optionalList> Quote 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTRIBUTE_VALUE;
                        !sem_action ./
    | Apos <AttributeValueContent_optionalList> Apos 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTRIBUTE_VALUE;
                        !sem_action ./

<AttributeValueContent_optionalList> ::= !empty 
    | <AttributeValueContent_list> 

<AttributeValueContent_list> ::= <AttributeValueContent> 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTR_VALUE_CONTENT_ONE;
                        !sem_action ./
    | <AttributeValueContent_list> <AttributeValueContent> 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_ATTR_VALUE_CONTENT_LIST;
                        !sem_action ./

<AttributeValueContent> ::= AttributeContent
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_CHAR;
                        !sem_action ./
    | <EnclosedExpr> 

<ComputedElementConstructor> ::= <ComputedElementName> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ELEM_EMPTY;
                        !sem_action ./
    | <ComputedElementName> <CompElemExpr> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ELEM;
                        !sem_action ./

<CompElemExpr> ::= <Expr>
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ELEM_EXPR;
                        !sem_action ./

<ComputedElementName> ::= element <TagQName> Lbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ELEM_START;
                        !sem_action ./
    | element Lbrace <ExprSingle> Rbrace Lbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_FUTURE_RELEASE;
                        !sem_action ./

<DirProcessingInstructionConstructor> ::= <PIStart> ProcessingInstructionEnd
       /. !sem_act_head
       sem_number = SQLNP_XQA_PI_EMPTY;
       !sem_action ./
     | <PIStart> <PIContent> ProcessingInstructionEnd
       /. !sem_act_head
       sem_number = SQLNP_XQA_PI;
       !sem_action ./

<PIContent> ::= ElementContent
       /. !sem_act_head
       sem_number = SQLNP_XQA_CHAR;
       !sem_action ./

<PIStart> ::= ProcessingInstructionStart <TagQName>
       /. !sem_act_head
       sem_number = SQLNP_XQA_PI_START;
       !sem_action ./

<ComputedAttributeConstructor> ::= <ComputedAttributeStart> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ATTRIBUTE_EMPTY;
                        !sem_action ./
    | <ComputedAttributeStart> <Expr> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ATTRIBUTE;
                        !sem_action ./

<ComputedAttributeStart> ::= attribute <TagQName> Lbrace 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_ATTRIBUTE_START;
                        !sem_action ./
    | attribute Lbrace <ExprSingle> Rbrace Lbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_FUTURE_RELEASE;
                        !sem_action ./

<ComputedPI> ::= <ComputedPIStart> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_PI_EMPTY;
                        !sem_action ./
    | <ComputedPIStart> <Expr> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_PI;
                        !sem_action ./

<ComputedPIStart> ::= processing_instruction <NCName> Lbrace 
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_PI_START;
                        !sem_action ./

<DirCommentConstructor> ::= XmlComment
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_CHAR;
                        !sem_action ./

<ComputedComment> ::= comment Lbrace <Expr> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_COMMENT;
                        !sem_action ./

<ComputedText> ::= text Lbrace <Expr> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_TEXT;
                        !sem_action ./

<ComputedDocument> ::= document Lbrace <Expr> Rbrace
                     /. !sem_act_head
                         sem_number = SQLNP_XQA_COMP_DOCUMENT;
                        !sem_action ./
