/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.DOM2SAX;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class Util {
    public static String baseName(String name) {
        return org.apache.xalan.xsltc.compiler.util.Util.baseName(name);
    }

    public static String noExtName(String name) {
        return org.apache.xalan.xsltc.compiler.util.Util.noExtName(name);
    }

    public static String toJavaName(String name) {
        return org.apache.xalan.xsltc.compiler.util.Util.toJavaName(name);
    }

    public static InputSource getInputSource(XSLTC xsltc, Source source) throws TransformerConfigurationException {
        InputSource input = null;
        String systemId = source.getSystemId();
        if (systemId == null) {
            systemId = "";
        }
        try {
            try {
                if (source instanceof SAXSource) {
                    SAXSource sax = (SAXSource)source;
                    input = sax.getInputSource();
                    xsltc.setXMLReader(sax.getXMLReader());
                } else if (source instanceof DOMSource) {
                    DOMSource domsrc = (DOMSource)source;
                    Document dom = (Document)domsrc.getNode();
                    DOM2SAX dom2sax = new DOM2SAX(dom);
                    xsltc.setXMLReader(dom2sax);
                    input = SAXSource.sourceToInputSource(source);
                    if (input == null) {
                        input = new InputSource(domsrc.getSystemId());
                    }
                } else if (source instanceof StreamSource) {
                    StreamSource stream = (StreamSource)source;
                    InputStream istream = stream.getInputStream();
                    Reader reader = stream.getReader();
                    input = istream != null ? new InputSource(istream) : (reader != null ? new InputSource(reader) : new InputSource(systemId));
                } else {
                    ErrorMsg err = new ErrorMsg("JAXP_UNKNOWN_SOURCE_ERR");
                    throw new TransformerConfigurationException(err.toString());
                }
                input.setSystemId(systemId);
            }
            catch (NullPointerException e) {
                ErrorMsg err = new ErrorMsg("JAXP_NO_SOURCE_ERR", "TransformerFactory.newTemplates()");
                throw new TransformerConfigurationException(err.toString());
            }
            catch (SecurityException e) {
                ErrorMsg err = new ErrorMsg("FILE_ACCESS_ERR", systemId);
                throw new TransformerConfigurationException(err.toString());
            }
            Object var8_16 = null;
            return input;
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            return input;
        }
    }
}

