/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.j2ee;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.j2ee.AbstractHotDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.j2ee.HotDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.j2ee.ServerDeploy;

public class WebLogicHotDeploymentTool
extends AbstractHotDeploymentTool
implements HotDeploymentTool {
    private static final String WEBLOGIC_DEPLOY_CLASS_NAME = "weblogic.deploy";
    private static final String[] VALID_ACTIONS = new String[]{"delete", "deploy", "list", "undeploy", "update"};
    private boolean debug;
    private String application;
    private String component;

    public void deploy() {
        Java java = (Java)this.getTask().getProject().createTask("java");
        java.setFork(true);
        java.setFailonerror(true);
        java.setClasspath(this.getClasspath());
        java.setClassname(WEBLOGIC_DEPLOY_CLASS_NAME);
        java.createArg().setLine(this.getArguments());
        java.execute();
    }

    public void validateAttributes() throws BuildException {
        super.validateAttributes();
        String action = this.getTask().getAction();
        if (this.getPassword() == null) {
            throw new BuildException("The password attribute must be set.");
        }
        if ((action.equals("deploy") || action.equals("update")) && this.application == null) {
            throw new BuildException("The application attribute must be set if action = " + action);
        }
        if ((action.equals("deploy") || action.equals("update")) && this.getTask().getSource() == null) {
            throw new BuildException("The source attribute must be set if action = " + action);
        }
        if ((action.equals("delete") || action.equals("undeploy")) && this.application == null) {
            throw new BuildException("The application attribute must be set if action = " + action);
        }
    }

    public String getArguments() throws BuildException {
        String action = this.getTask().getAction();
        String args = null;
        if (action.equals("deploy") || action.equals("update")) {
            args = this.buildDeployArgs();
        } else if (action.equals("delete") || action.equals("undeploy")) {
            args = this.buildUndeployArgs();
        } else if (action.equals("list")) {
            args = this.buildListArgs();
        }
        return args;
    }

    protected boolean isActionValid() {
        boolean valid = false;
        String action = this.getTask().getAction();
        int i = 0;
        while (i < VALID_ACTIONS.length) {
            if (action.equals(VALID_ACTIONS[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        return valid;
    }

    protected StringBuffer buildArgsPrefix() {
        ServerDeploy task = this.getTask();
        return new StringBuffer(1024).append(this.getServer() != null ? "-url " + this.getServer() : "").append(" ").append(this.debug ? "-debug " : "").append(this.getUserName() != null ? "-username " + this.getUserName() : "").append(" ").append(task.getAction()).append(" ").append(this.getPassword()).append(" ");
    }

    protected String buildDeployArgs() {
        String args = this.buildArgsPrefix().append(this.application).append(" ").append(this.getTask().getSource()).toString();
        if (this.component != null) {
            args = "-component " + this.component + " " + args;
        }
        return args;
    }

    protected String buildUndeployArgs() {
        return this.buildArgsPrefix().append(this.application).append(" ").toString();
    }

    protected String buildListArgs() {
        return this.buildArgsPrefix().toString();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setComponent(String component) {
        this.component = component;
    }
}

