/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jdom;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class NodeWrapper
implements NodeInfo {
    protected Object node;
    protected short nodeType;
    protected NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    public NodeWrapper(Object object, NodeWrapper nodeWrapper, int n) {
        this.node = object;
        this.parent = nodeWrapper;
        this.index = n;
    }

    public NodeWrapper makeWrapper(Object object, NodeWrapper nodeWrapper, int n) {
        NodeWrapper nodeWrapper2;
        if (object instanceof Document) {
            return this.docWrapper;
        }
        if (object instanceof Element) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = 1;
        } else if (object instanceof Attribute) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)2;
        } else if (object instanceof String || object instanceof Text) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)3;
        } else if (object instanceof CDATA) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)3;
        } else if (object instanceof Comment) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)8;
        } else if (object instanceof ProcessingInstruction) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)7;
        } else {
            throw new IllegalArgumentException("Bad node type in JDOM! " + object.getClass() + " instance " + object.toString());
        }
        nodeWrapper2.docWrapper = nodeWrapper.docWrapper;
        return nodeWrapper2;
    }

    public Object getNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getItemType() {
        return this.nodeType;
    }

    public Value getTypedValue() {
        return new UntypedAtomicValue((CharSequence)this.getStringValue());
    }

    public int getTypeAnnotation() {
        return 0;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        if (this.nodeType != nodeWrapper.getItemType()) {
            return false;
        }
        if (this.index != nodeWrapper.index) {
            return false;
        }
        if (this.node instanceof String) {
            return this.parent.isSameNode(nodeWrapper.parent);
        }
        return this.node.equals(nodeWrapper.node);
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        if (this.isSameNode(nodeInfo)) {
            return 0;
        }
        if (this.getParent().isSameNode(nodeInfo.getParent())) {
            return this.index - nodeWrapper.index;
        }
        int n = 0;
        int n2 = 0;
        NodeWrapper nodeWrapper2 = this;
        NodeInfo nodeInfo2 = nodeInfo;
        while (nodeWrapper2 != null) {
            ++n;
            nodeWrapper2 = nodeWrapper2.getParent();
        }
        while (nodeInfo2 != null) {
            ++n2;
            nodeInfo2 = nodeInfo2.getParent();
        }
        nodeWrapper2 = this;
        while (n > n2) {
            if ((nodeWrapper2 = nodeWrapper2.getParent()).isSameNode(nodeWrapper)) {
                return 1;
            }
            --n;
        }
        nodeInfo2 = nodeWrapper;
        while (n2 > n) {
            if ((nodeInfo2 = nodeInfo2.getParent()).isSameNode((NodeInfo)this)) {
                return -1;
            }
            --n2;
        }
        while (true) {
            NodeInfo nodeInfo3 = nodeWrapper2.getParent();
            NodeInfo nodeInfo4 = nodeInfo2.getParent();
            if (nodeInfo3 == null || nodeInfo4 == null) {
                throw new NullPointerException("JDOM tree compare - internal error");
            }
            if (nodeInfo3.isSameNode(nodeInfo4)) {
                return nodeWrapper2.index - ((NodeWrapper)nodeInfo2).index;
            }
            nodeWrapper2 = nodeInfo3;
            nodeInfo2 = nodeInfo4;
        }
    }

    public String getStringValue() {
        switch (this.nodeType) {
            case 9: {
                List list = ((Document)this.node).getContent();
                StringBuffer stringBuffer = new StringBuffer();
                this.expandStringValue(list, stringBuffer);
                return stringBuffer.toString();
            }
            case 1: {
                List list = ((Element)this.node).getContent();
                StringBuffer stringBuffer = new StringBuffer();
                this.expandStringValue(list, stringBuffer);
                return stringBuffer.toString();
            }
            case 2: {
                return ((Attribute)this.node).getValue();
            }
            case 3: {
                if (this.node instanceof String) {
                    return (String)this.node;
                }
                if (this.node instanceof Text) {
                    return ((Text)this.node).getText();
                }
                if (this.node instanceof CDATA) {
                    return ((CDATA)this.node).getText();
                }
                return "";
            }
            case 8: {
                return ((Comment)this.node).getText();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getData();
            }
            case 13: {
                return ((Namespace)this.node).getURI();
            }
        }
        return "";
    }

    private void expandStringValue(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element) {
                this.expandStringValue(((Element)e).getContent(), stringBuffer);
                continue;
            }
            if (e instanceof String) {
                stringBuffer.append((String)e);
                continue;
            }
            if (e instanceof Text) {
                stringBuffer.append(((Text)e).getText());
                continue;
            }
            if (e instanceof CDATA) {
                stringBuffer.append(((CDATA)e).getText());
                continue;
            }
            if (e instanceof EntityRef) {
                throw new IllegalStateException("Unexpanded entity in JDOM tree");
            }
            throw new AssertionError((Object)"Unknown JDOM node type");
        }
    }

    public int getNameCode() {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 7: {
                return this.docWrapper.namePool.allocate(this.getPrefix(), this.getURI(), this.getLocalName());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalName() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return "";
    }

    public String getPrefix() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalName();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                if (this.nodeType == 9) {
                    return EmptyIterator.getInstance();
                }
                return new FilterEnumeration(new AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeType == 9) {
                    return EmptyIterator.getInstance();
                }
                return new FilterEnumeration(new AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (this.nodeType != 1) {
                    return EmptyIterator.getInstance();
                }
                return new FilterEnumeration(new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new FilterEnumeration(new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new FilterEnumeration(new DescendantEnumeration(this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new FilterEnumeration(new DescendantEnumeration(this, true, true), nodeTest);
            }
            case 6: {
                return new FilterEnumeration(new FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (this.nodeType) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new FilterEnumeration(new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeType != 1) {
                    return EmptyIterator.getInstance();
                }
                throw new UnsupportedOperationException("The namespace axis is not supported with the SAXON JDOM interface");
            }
            case 9: {
                if (this.parent == null) {
                    return EmptyIterator.getInstance();
                }
                if (nodeTest.matches(this.parent.getItemType(), this.parent.getFingerprint(), 88)) {
                    return new SingletonIterator((Item)this.parent);
                }
                return EmptyIterator.getInstance();
            }
            case 10: {
                return new FilterEnumeration(new PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeType) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new FilterEnumeration(new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this.getItemType(), this.getFingerprint(), 88)) {
                    return new SingletonIterator((Item)this);
                }
                return EmptyIterator.getInstance();
            }
            case 13: {
                return new FilterEnumeration(new PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(String string, String string2) {
        if (this.nodeType == 1) {
            Namespace namespace = Namespace.getNamespace((String)string);
            return ((Element)this.node).getAttributeValue(string2, namespace);
        }
        return "";
    }

    public String getAttributeValue(int n) {
        if (this.nodeType == 1) {
            Iterator iterator = ((Element)this.node).getAttributes().iterator();
            NamePool namePool = this.docWrapper.getNamePool();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                int n2 = namePool.allocate(attribute.getNamespacePrefix(), attribute.getNamespaceURI(), attribute.getName());
                if (n != (n2 & 0xFFFFF)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeType) {
            case 9: {
                return true;
            }
            case 1: {
                return !((Element)this.node).getContent().isEmpty();
            }
        }
        return false;
    }

    public String generateId() {
        if (this.node instanceof String || this.node instanceof Text) {
            return this.parent.generateId() + "text" + this.index;
        }
        return "j" + this.node.hashCode();
    }

    public void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, null, (int)n, (boolean)bl);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws TransformerException {
        if (this.nodeType == 1) {
            NamePool namePool = this.docWrapper.getNamePool();
            AxisIterator axisIterator = this.iterateAxis((byte)8);
            while (axisIterator.hasNext()) {
                Namespace namespace = (Namespace)((NodeWrapper)axisIterator.next()).node;
                int n = namePool.allocateNamespaceCode(namespace.getPrefix(), namespace.getURI());
                receiver.namespace(n, 0);
            }
        }
    }

    private final class PrecedingEnumeration
    extends BaseEnumeration {
        private NodeWrapper start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;
        private boolean includeAncestors;

        public PrecedingEnumeration(NodeWrapper nodeWrapper2, boolean bl) {
            this.start = nodeWrapper2;
            this.includeAncestors = bl;
            this.ancestorEnum = new AncestorEnumeration(nodeWrapper2, false);
            switch (nodeWrapper2.getItemType()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = new ChildEnumeration(nodeWrapper2, false, false);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
            this.advance();
        }

        public void advance() {
            if (this.descendEnum != null) {
                if (this.descendEnum.hasNext()) {
                    this.next = (NodeWrapper)this.descendEnum.next();
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                if (this.siblingEnum.hasNext()) {
                    NodeWrapper nodeWrapper = (NodeWrapper)this.siblingEnum.next();
                    if (nodeWrapper.hasChildNodes()) {
                        this.descendEnum = new DescendantEnumeration(nodeWrapper, true, false);
                        this.advance();
                    } else {
                        this.descendEnum = null;
                        this.next = nodeWrapper;
                    }
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if (this.ancestorEnum.hasNext()) {
                this.next = (NodeWrapper)this.ancestorEnum.next();
                this.siblingEnum = this.next.getItemType() == 9 ? EmptyIterator.getInstance() : new ChildEnumeration(this.next, false, false);
                if (!this.includeAncestors) {
                    this.advance();
                }
            } else {
                this.next = null;
            }
        }

        public SequenceIterator getAnother() {
            return new PrecedingEnumeration(this.start, this.includeAncestors);
        }
    }

    private final class FollowingEnumeration
    extends BaseEnumeration {
        private NodeWrapper start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;

        public FollowingEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.ancestorEnum = new AncestorEnumeration(nodeWrapper2, false);
            switch (nodeWrapper2.getItemType()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = new ChildEnumeration(nodeWrapper2, false, true);
                    break;
                }
                case 2: 
                case 13: {
                    this.siblingEnum = new ChildEnumeration((NodeWrapper)nodeWrapper2.getParent(), true, true);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
            this.advance();
        }

        public void advance() {
            if (this.descendEnum != null) {
                if (this.descendEnum.hasNext()) {
                    this.next = (NodeWrapper)this.descendEnum.next();
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                if (this.siblingEnum.hasNext()) {
                    this.next = (NodeWrapper)this.siblingEnum.next();
                    this.descendEnum = this.next.hasChildNodes() ? new DescendantEnumeration(this.next, false, true) : null;
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if (this.ancestorEnum.hasNext()) {
                this.next = (NodeWrapper)this.ancestorEnum.next();
                this.siblingEnum = this.next.getItemType() == 9 ? EmptyIterator.getInstance() : new ChildEnumeration(this.next, false, true);
                this.advance();
            } else {
                this.next = null;
            }
        }

        public SequenceIterator getAnother() {
            return new FollowingEnumeration(this.start);
        }
    }

    private final class DescendantEnumeration
    extends BaseEnumeration {
        private AxisIterator children = null;
        private AxisIterator descendants = null;
        private NodeWrapper start;
        private boolean includeSelf;
        private boolean forwards;
        private boolean atEnd = false;

        public DescendantEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.includeSelf = bl;
            this.forwards = bl2;
            this.advance();
        }

        public void advance() {
            if (this.descendants != null) {
                if (this.descendants.hasNext()) {
                    this.next = (NodeWrapper)this.descendants.next();
                    return;
                }
                this.descendants = null;
            }
            if (this.children != null) {
                if (this.children.hasNext()) {
                    NodeWrapper nodeWrapper = (NodeWrapper)this.children.next();
                    if (nodeWrapper.hasChildNodes()) {
                        if (this.forwards) {
                            this.descendants = new DescendantEnumeration(nodeWrapper, false, this.forwards);
                            this.next = nodeWrapper;
                        } else {
                            this.descendants = new DescendantEnumeration(nodeWrapper, true, this.forwards);
                            this.advance();
                        }
                    } else {
                        this.next = nodeWrapper;
                    }
                } else if (this.forwards || !this.includeSelf) {
                    this.next = null;
                } else {
                    this.atEnd = true;
                    this.children = null;
                    this.next = this.start;
                }
            } else if (this.atEnd) {
                this.next = null;
            } else {
                this.children = this.start.hasChildNodes() ? new ChildEnumeration(this.start, true, this.forwards) : EmptyIterator.getInstance();
                if (this.forwards && this.includeSelf) {
                    this.next = this.start;
                } else {
                    this.advance();
                }
            }
        }

        public SequenceIterator getAnother() {
            return new DescendantEnumeration(this.start, this.includeSelf, this.forwards);
        }
    }

    private final class ChildEnumeration
    extends BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            this.children = this.commonParent.getItemType() == 9 ? ((Document)this.commonParent.node).getContent().listIterator() : ((Element)this.commonParent.node).getContent().listIterator();
            if (bl) {
                if (!bl2) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = nodeWrapper2.index;
                if (bl2) {
                    int n = 0;
                    while (n <= this.ix) {
                        this.children.next();
                        ++n;
                    }
                    ++this.ix;
                } else {
                    int n = 0;
                    while (n < this.ix) {
                        this.children.next();
                        ++n;
                    }
                    --this.ix;
                }
            }
            this.advance();
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object e = this.children.next();
                    if (e instanceof EntityRef) {
                        throw new IllegalStateException("Unexpanded entity in JDOM tree");
                    }
                    this.next = NodeWrapper.this.makeWrapper(e, this.commonParent, this.ix++);
                } else {
                    this.next = null;
                }
            } else if (this.children.hasPrevious()) {
                Object e = this.children.previous();
                if (e instanceof EntityRef) {
                    throw new IllegalStateException("Unexpanded entity in JDOM tree");
                }
                this.next = NodeWrapper.this.makeWrapper(e, this.commonParent, this.ix--);
            } else {
                this.next = null;
            }
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class AttributeEnumeration
    extends BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.atts = ((Element)nodeWrapper2.node).getAttributes().iterator();
            this.advance();
        }

        public void advance() {
            this.next = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), this.start, this.ix++) : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }

    private final class AncestorEnumeration
    extends BaseEnumeration {
        private boolean includeSelf;
        private NodeWrapper start;

        public AncestorEnumeration(NodeWrapper nodeWrapper2, boolean bl) {
            this.start = nodeWrapper2;
            this.includeSelf = bl;
            this.next = nodeWrapper2;
            if (!bl) {
                this.advance();
            }
        }

        public void advance() {
            this.next = (NodeWrapper)this.next.getParent();
        }

        public SequenceIterator getAnother() {
            return new AncestorEnumeration(this.start, this.includeSelf);
        }
    }

    private abstract class BaseEnumeration
    extends AxisIteratorImpl {
        protected NodeWrapper next;

        private BaseEnumeration() {
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final Item next() {
            this.current = this.next;
            this.advance();
            return this.current;
        }

        public abstract void advance();

        public abstract SequenceIterator getAnother();

        public final int getLastPosition() {
            return 1;
        }
    }

    private class FilterEnumeration
    extends AxisIteratorImpl {
        private BaseEnumeration base;
        private NodeTest nodeTest;
        private NodeInfo next;
        private int last = -1;

        public FilterEnumeration(BaseEnumeration baseEnumeration, NodeTest nodeTest) {
            this.base = baseEnumeration;
            this.nodeTest = nodeTest;
            this.position = 0;
            this.advance();
        }

        public void advance() {
            while (this.base.hasNext()) {
                this.next = (NodeInfo)this.base.next();
                if (!this.nodeTest.matches(this.next.getItemType(), this.next.getFingerprint(), 88)) continue;
                return;
            }
            this.next = null;
        }

        public Item next() {
            this.current = this.next;
            this.advance();
            ++this.position;
            return this.current;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public int getLastPosition() {
            if (this.last >= 0) {
                return this.last;
            }
            this.last = 0;
            BaseEnumeration baseEnumeration = (BaseEnumeration)this.base.getAnother();
            while (baseEnumeration.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)baseEnumeration.next();
                if (!this.nodeTest.matches(nodeInfo.getItemType(), nodeInfo.getFingerprint(), 88)) continue;
                ++this.last;
            }
            return this.last;
        }

        public SequenceIterator getAnother() {
            return new FilterEnumeration(this.base, this.nodeTest);
        }
    }
}

