/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathException;
import net.sf.saxon.xpath.XPathExpression;

public class XPathEvaluator {
    private DocumentInfo document = null;
    private NodeInfo contextNode = null;
    private StaticContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
    }

    public XPathEvaluator(Source source) throws XPathException {
        this.setSource(source);
    }

    public void setStripSpace(boolean bl) {
        this.stripSpace = bl;
    }

    public DocumentInfo setSource(Source source) throws XPathException {
        if (source == null) {
            throw new NullPointerException("Source cannot be null");
        }
        if (source instanceof DocumentInfo) {
            this.document = (DocumentInfo)source;
        } else {
            TinyBuilder tinyBuilder = new TinyBuilder();
            NamePool namePool = NamePool.getDefaultNamePool();
            tinyBuilder.setNamePool(namePool);
            Receiver receiver = tinyBuilder;
            if (this.stripSpace) {
                Stripper stripper = new Stripper(null);
                stripper.setStripAll();
                stripper.setUnderlyingReceiver(tinyBuilder);
                receiver = stripper;
            }
            try {
                new Sender(new Configuration()).send(source, receiver, namePool, false);
            }
            catch (TransformerException transformerException) {
                throw new XPathException.Dynamic(transformerException);
            }
            this.document = tinyBuilder.getCurrentDocument();
        }
        this.contextNode = this.document;
        this.staticContext = new StandaloneContext(this.document.getNamePool());
        return this.document;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public XPathExpression createExpression(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext);
        expression = expression.analyze(this.staticContext);
        return new XPathExpression(expression, this.document);
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (this.document == null) {
            try {
                this.setSource(nodeInfo);
            }
            catch (XPathException xPathException) {
                throw new IllegalStateException("Untrapped error");
            }
        } else if (nodeInfo.getDocumentRoot() == this.document) {
            this.contextNode = nodeInfo;
        } else {
            throw new IllegalArgumentException("Supplied node is in wrong document");
        }
    }

    public List evaluate(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext);
        expression = expression.analyze(this.staticContext);
        XPathContext xPathContext = new XPathContext(this.contextNode);
        xPathContext.setLocalVariableFrame(new Object[50]);
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public static Object convert(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            return item;
        }
        switch (item.getItemType()) {
            case 101: {
                return item.getStringValue();
            }
            case 102: {
                return ((BooleanValue)item).getValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 103: {
                return ((DecimalValue)item).getValue();
            }
            case 200: {
                return new Long(((IntegerValue)item).getValue());
            }
            case 105: {
                return new Double(((DoubleValue)item).getValue());
            }
            case 104: {
                return new Float(((FloatValue)item).getValue());
            }
            case 107: {
                return ((DateTimeValue)item).getUTCDate();
            }
        }
        throw new XPathException.Dynamic("Unrecognized data type: " + Type.getTypeName(item.getItemType()));
    }

    public Object evaluateSingle(String string) throws XPathException {
        Expression expression = ExpressionTool.make(string, this.staticContext);
        XPathContext xPathContext = new XPathContext(this.contextNode);
        xPathContext.setLocalVariableFrame(new Object[50]);
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        if (sequenceIterator.hasNext()) {
            return XPathEvaluator.convert(sequenceIterator.next());
        }
        return null;
    }
}

