/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class RestrictedStringValue
extends StringValue {
    private int type;

    public RestrictedStringValue(CharSequence charSequence, int n) throws XPathException {
        this.type = n;
        if (charSequence == null) {
            this.value = "";
        } else if (n == 220) {
            this.value = Value.normalizeWhitespace(charSequence).toString();
        } else {
            this.value = Value.collapseWhitespace(charSequence).toString();
            this.validate();
        }
    }

    private void validate() throws XPathException {
        switch (this.type) {
            case 221: {
                return;
            }
            case 220: {
                return;
            }
            case 222: {
                String string = "(([a-z]|[A-Z])([a-z]|[A-Z])|([iI]-([a-z]|[A-Z])+)|([xX]-([a-z]|[A-Z])+))(-([a-z]|[A-Z])+)*";
                if (!Pattern.matches(string, this.value.toString())) {
                    throw new XPathException.Dynamic("The value '" + this.value + "' is not a valid xs:language");
                }
                return;
            }
            case 225: {
                if (!Name.isQName(this.value.toString())) {
                    throw new XPathException.Dynamic("The value '" + this.value + "' is not a valid Name");
                }
                return;
            }
            case 226: 
            case 227: 
            case 228: 
            case 230: {
                if (!XMLChar.isValidNCName(this.value.toString())) {
                    throw new XPathException.Dynamic("The value '" + this.value + "' is not a valid NCName");
                }
                return;
            }
            case 223: {
                if (!XMLChar.isValidNmtoken(this.value.toString())) {
                    throw new XPathException.Dynamic("The value '" + this.value + "' is not a valid NMTOKEN");
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown string value type " + this.type);
    }

    public int getItemType() {
        return this.type;
    }

    public AtomicValue convert(int n) throws XPathException {
        if (n == 101) {
            return new StringValue(this.value);
        }
        return super.convert(n);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + Type.getTypeName(this.type) + " (\"" + this.value + "\")");
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }
}

