/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public final class IntegerValue
extends NumericValue {
    public static final IntegerValue MINUS_ONE = new IntegerValue(-1L);
    public static final IntegerValue ZERO = new IntegerValue(0L);
    public static final IntegerValue PLUS_ONE = new IntegerValue(1L);
    private long value;
    private int type;
    static long[] ranges = new long[]{200L, Long.MIN_VALUE, Long.MAX_VALUE, 201L, Long.MIN_VALUE, 0L, 202L, Long.MIN_VALUE, -1L, 203L, Long.MIN_VALUE, Long.MAX_VALUE, 204L, Integer.MIN_VALUE, Integer.MAX_VALUE, 205L, -32768L, 32767L, 206L, -128L, 127L, 207L, 0L, Long.MAX_VALUE, 208L, 1L, Long.MAX_VALUE, 209L, 0L, Long.MAX_VALUE, 210L, 0L, 0xFFFFFFFFL, 211L, 0L, 65535L, 212L, 0L, 255L};
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    public IntegerValue(long l) {
        this.value = l;
        this.type = 200;
    }

    public IntegerValue(long l, int n) throws XPathException {
        this.value = l;
        this.type = n;
        IntegerValue.checkRange(this.value, n);
    }

    private static void checkRange(long l, int n) throws XPathException {
        int n2 = 0;
        while (n2 < ranges.length) {
            if (ranges[n2] == (long)n) {
                if (l < ranges[n2 + 1] || l > ranges[n2 + 2]) {
                    throw new XPathException.Dynamic("Value is out of range for type " + Type.getTypeName(n));
                }
                return;
            }
            n2 += 3;
        }
        throw new XPathException.Dynamic("No range information for type " + Type.getTypeName(n));
    }

    public int hashCode() {
        if (this.value > Integer.MIN_VALUE && this.value < Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return new Double(this.asDouble()).hashCode();
    }

    public long getValue() {
        return this.value;
    }

    public long asLong() {
        return this.value;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value != 0L;
    }

    public int compareTo(Object object) {
        if (object instanceof IntegerValue) {
            long l = ((IntegerValue)object).value;
            if (this.value == l) {
                return 0;
            }
            if (this.value < l) {
                return -1;
            }
            return 1;
        }
        return super.compareTo(object);
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 102: {
                return BooleanValue.get(this.value != 0L);
            }
            case 88: 
            case 90: 
            case 91: 
            case 200: 
            case 203: {
                return this;
            }
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                return new IntegerValue(this.value, n);
            }
            case 105: {
                return new DoubleValue(this.value);
            }
            case 104: {
                return new FloatValue(this.value);
            }
            case 103: {
                return new DecimalValue(this.getStringValue());
            }
            case 101: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException.Dynamic("Cannot convert integer to " + Type.getTypeName(n));
    }

    public String getStringValue() {
        return this.value + "";
    }

    public NumericValue negate() {
        return new IntegerValue(-this.value);
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        long l = Math.abs(this.value);
        if (n >= 0) {
            return this;
        }
        long l2 = 1L;
        long l3 = 1L;
        while (l3 <= (long)(-n)) {
            l2 *= 10L;
            ++l3;
        }
        long l4 = l % l2;
        long l5 = l - l4;
        long l6 = l4 * 2L;
        if (l6 > l2) {
            l5 += l2;
        } else if (l6 >= l2 && l5 % (2L * l2) != 0L) {
            l5 += l2;
        }
        if (this.value < 0L) {
            l5 = -l5;
        }
        return new IntegerValue(l5);
    }

    public boolean isWholeNumber() {
        return true;
    }

    public NumericValue arithmetic(int n, NumericValue numericValue) throws XPathException {
        if (numericValue instanceof IntegerValue) {
            switch (n) {
                case 15: {
                    return new IntegerValue(this.value + ((IntegerValue)numericValue).value);
                }
                case 16: {
                    return new IntegerValue(this.value - ((IntegerValue)numericValue).value);
                }
                case 17: {
                    return new IntegerValue(this.value * ((IntegerValue)numericValue).value);
                }
                case 50: {
                    try {
                        return new IntegerValue(this.value / ((IntegerValue)numericValue).value);
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new XPathException.Dynamic("Integer division failure", arithmeticException);
                    }
                }
                case 18: {
                    double d = numericValue.asDouble();
                    if (d == 0.0) {
                        throw new XPathException.Dynamic("Division by zero");
                    }
                    return new DecimalValue(this.asDouble() / numericValue.asDouble());
                }
                case 19: {
                    return new IntegerValue(this.value % ((IntegerValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        return ((NumericValue)this.convert(numericValue.getItemType())).arithmetic(n, numericValue);
    }

    public int getItemType() {
        return this.type;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = IntegerValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = IntegerValue.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 14;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntegerValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 15;
        }
        if (clazz == Byte.TYPE) {
            return 12;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = IntegerValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 13;
        }
        if (clazz == Character.TYPE) {
            return 10;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = IntegerValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 11;
        }
        if (clazz == Double.TYPE) {
            return 2;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = IntegerValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 3;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = IntegerValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 5;
        }
        if (clazz == Integer.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IntegerValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 7;
        }
        if (clazz == Long.TYPE) {
            return 0;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IntegerValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 1;
        }
        if (clazz == Short.TYPE) {
            return 8;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IntegerValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 9;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = IntegerValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = IntegerValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 16;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = IntegerValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Long(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = IntegerValue.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(102);
            return new Boolean(booleanValue.getValue());
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntegerValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(102);
            return new Boolean(booleanValue.getValue());
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = IntegerValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = IntegerValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = IntegerValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = IntegerValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IntegerValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IntegerValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IntegerValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = IntegerValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = IntegerValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        throw new XPathException.Dynamic("Conversion of integer to " + clazz.getName() + " is not supported");
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + Type.getTypeName(this.type) + " (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

