/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.ChildEnumeration;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.TextImpl;
import org.w3c.dom.Node;

abstract class ParentNodeImpl
extends NodeImpl {
    private Object children = null;
    protected int sequence;

    ParentNodeImpl() {
    }

    protected final long getSequenceNumber() {
        return (long)this.sequence << 32;
    }

    public final boolean hasChildNodes() {
        return this.children != null;
    }

    public final AxisIterator enumerateChildren(NodeTest nodeTest) {
        if (this.children == null) {
            return EmptyIterator.getInstance();
        }
        if (this.children instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)this.children;
            if (nodeTest == null || nodeTest.matches(nodeImpl.getItemType(), nodeImpl.getFingerprint(), nodeImpl.getTypeAnnotation())) {
                return new SingletonIterator(nodeImpl);
            }
            return EmptyIterator.getInstance();
        }
        if (nodeTest == null || nodeTest instanceof AnyNodeTest) {
            return new ArrayIterator((NodeImpl[])this.children);
        }
        return new ChildEnumeration(this, nodeTest);
    }

    public final Node getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeImpl[])this.children)[0];
    }

    public final Node getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
        return nodeImplArray[nodeImplArray.length - 1];
    }

    protected final NodeImpl getNthChild(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this.children : null;
        }
        NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
        if (n < 0 || n >= nodeImplArray.length) {
            return null;
        }
        return nodeImplArray[n];
    }

    public String getStringValue() {
        StringBuffer stringBuffer = null;
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            if (nodeImpl instanceof TextImpl) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(nodeImpl.getStringValue());
            }
            nodeImpl = nodeImpl.getNextInDocument(this);
        }
        if (stringBuffer == null) {
            return "";
        }
        return stringBuffer.toString();
    }

    public void useChildrenArray(NodeImpl[] nodeImplArray) {
        this.children = nodeImplArray;
    }

    public void addChild(NodeImpl nodeImpl, int n) {
        NodeImpl[] nodeImplArray;
        if (this.children == null) {
            nodeImplArray = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            nodeImplArray = new NodeImpl[10];
            nodeImplArray[0] = (NodeImpl)this.children;
        } else {
            nodeImplArray = (NodeImpl[])this.children;
        }
        if (n >= nodeImplArray.length) {
            NodeImpl[] nodeImplArray2 = new NodeImpl[nodeImplArray.length * 2];
            System.arraycopy(nodeImplArray, 0, nodeImplArray2, 0, nodeImplArray.length);
            nodeImplArray = nodeImplArray2;
        }
        nodeImplArray[n] = nodeImpl;
        nodeImpl.parent = this;
        nodeImpl.index = n;
        this.children = nodeImplArray;
    }

    public void compact(int n) {
        if (n == 0) {
            this.children = null;
        } else if (n == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            NodeImpl[] nodeImplArray = new NodeImpl[n];
            System.arraycopy(this.children, 0, nodeImplArray, 0, n);
            this.children = nodeImplArray;
        }
    }

    public String getNodeValue() {
        return null;
    }
}

