/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.NodeFactory;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.SystemIdMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo,
Document {
    private ElementImpl documentElement;
    private HashMap idTable = null;
    private int documentNumber;
    private HashMap entityTable = null;
    private HashMap elementList = null;
    private NamePool namePool;
    private NodeFactory nodeFactory;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();

    public DocumentImpl() {
        this.parent = null;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.documentNumber = namePool.allocateDocumentNumber(this);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected void setDocumentElement(ElementImpl elementImpl) {
        this.documentElement = elementImpl;
    }

    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(this.sequence, string);
    }

    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.sequence);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    protected void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(n, string);
    }

    protected String getSystemId(int n) {
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(this.sequence, 0);
    }

    protected void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    protected int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getItemType() {
        return 9;
    }

    public final Node getNextSibling() {
        return null;
    }

    public final Node getPreviousSibling() {
        return null;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public String generateId() {
        return "d" + this.documentNumber;
    }

    protected AxisIterator getAllElements(int n) {
        ArrayList<NodeImpl> arrayList;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new HashMap();
        }
        if ((arrayList = (ArrayList<NodeImpl>)this.elementList.get(n2)) == null) {
            arrayList = new ArrayList<NodeImpl>();
            NodeImpl nodeImpl = this.getNextInDocument(this);
            while (nodeImpl != null) {
                if (nodeImpl.getItemType() == 1 && nodeImpl.getFingerprint() == n) {
                    arrayList.add(nodeImpl);
                }
                nodeImpl = nodeImpl.getNextInDocument(this);
            }
            this.elementList.put(n2, arrayList);
        }
        return new ArrayListIterator(arrayList);
    }

    private void indexIDs() {
        NodeImpl nodeImpl;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new HashMap();
        DocumentImpl documentImpl = nodeImpl = this;
        while (nodeImpl != null) {
            if (nodeImpl.getItemType() == 1) {
                ElementImpl elementImpl = (ElementImpl)nodeImpl;
                AttributeCollection attributeCollection = elementImpl.getAttributeList();
                int n = 0;
                while (n < attributeCollection.getLength()) {
                    if ("ID".equals(attributeCollection.getType(n)) && XMLChar.isValidNCName(attributeCollection.getValue(n))) {
                        this.registerID(elementImpl, attributeCollection.getValue(n));
                    }
                    ++n;
                }
            }
            nodeImpl = nodeImpl.getNextInDocument(documentImpl);
        }
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        Object v = this.idTable.get(string);
        if (v == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            this.indexIDs();
        }
        return (NodeInfo)this.idTable.get(string);
    }

    protected void setUnparsedEntity(String string, String string2, String string3) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap();
        }
        String[] stringArray = new String[]{string2, string3};
        this.entityTable.put(string, stringArray);
    }

    public String[] getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return null;
        }
        return (String[])this.entityTable.get(string);
    }

    public void copy(Receiver receiver, int n) throws TransformerException {
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            nodeImpl.copy(receiver, n);
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
    }
}

