/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.XPathException;

public class KeyManager
implements Serializable {
    private HashMap keyList = new HashMap();
    private transient WeakHashMap docIndexes = new WeakHashMap();

    public void setKeyDefinition(int n, KeyDefinition keyDefinition) {
        Integer n2 = new Integer(n);
        ArrayList<KeyDefinition> arrayList = (ArrayList<KeyDefinition>)this.keyList.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<KeyDefinition>();
            this.keyList.put(n2, arrayList);
        }
        arrayList.add(keyDefinition);
    }

    public ArrayList getKeyDefinitions(int n) {
        return (ArrayList)this.keyList.get(new Integer(n));
    }

    private synchronized HashMap buildIndex(int n, DocumentInfo documentInfo, Controller controller) throws XPathException {
        ArrayList arrayList = this.getKeyDefinitions(n);
        if (arrayList == null) {
            throw new XPathException.Dynamic("Key " + controller.getNamePool().getDisplayName(n) + " has not been defined");
        }
        HashMap hashMap = new HashMap();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.constructIndex(documentInfo, hashMap, (KeyDefinition)arrayList.get(n2), controller, n2 == 0);
            ++n2;
        }
        return hashMap;
    }

    private void constructIndex(DocumentInfo documentInfo, HashMap hashMap, KeyDefinition keyDefinition, Controller controller, boolean bl) throws XPathException {
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        int n = keyDefinition.getItemType();
        Collator collator = keyDefinition.getCollation();
        DocumentInfo documentInfo2 = documentInfo;
        NodeInfo nodeInfo = documentInfo2;
        SequenceIterator sequenceIterator = controller.getCurrentIterator();
        Object[] objectArray = controller.saveContext();
        XPathContext xPathContext = controller.newXPathContext();
        int n2 = pattern.getItemType();
        if (n2 == 2 || n2 == 0 || n2 == 9) {
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)5);
            while (axisIterator.hasNext()) {
                nodeInfo = (NodeInfo)axisIterator.next();
                if (nodeInfo.getItemType() == 1) {
                    AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)2);
                    while (axisIterator2.hasNext()) {
                        NodeInfo nodeInfo2 = (NodeInfo)axisIterator2.next();
                        if (!pattern.matches(nodeInfo2, controller)) continue;
                        this.processKeyNode(nodeInfo2, expression, n, collator, hashMap, xPathContext, bl);
                    }
                    if (n2 != 0 || !pattern.matches(nodeInfo, controller)) continue;
                    this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContext, bl);
                    continue;
                }
                if (!pattern.matches(nodeInfo, controller)) continue;
                this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContext, bl);
            }
        } else {
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, pattern.getNodeTest());
            while (axisIterator.hasNext()) {
                nodeInfo = (NodeInfo)axisIterator.next();
                if (!(pattern instanceof NodeTest) && !pattern.matches(nodeInfo, controller)) continue;
                this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContext, bl);
            }
        }
        controller.setCurrentIterator(sequenceIterator);
        controller.restoreContext(objectArray);
    }

    private void processKeyNode(NodeInfo nodeInfo, Expression expression, int n, Collator collator, HashMap hashMap, XPathContext xPathContext, boolean bl) throws XPathException {
        SingletonIterator singletonIterator = new SingletonIterator(nodeInfo);
        if (singletonIterator.hasNext()) {
            singletonIterator.next();
        }
        xPathContext.setCurrentIterator(singletonIterator);
        xPathContext.getController().setCurrentIterator(singletonIterator);
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        while (sequenceIterator.hasNext()) {
            AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
            Object object = n == 101 ? (collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue())) : (n == 104 && Float.isNaN(((FloatValue)atomicValue).getValue()) ? "NaN" : (n == 105 && Double.isNaN(((DoubleValue)atomicValue).getValue()) ? "NaN" : atomicValue));
            ArrayList<NodeInfo> arrayList = (ArrayList<NodeInfo>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeInfo>();
                hashMap.put(object, arrayList);
                arrayList.add(nodeInfo);
                continue;
            }
            if (bl) {
                if (arrayList.get(arrayList.size() - 1) == nodeInfo) continue;
                arrayList.add(nodeInfo);
                continue;
            }
            LocalOrderComparer localOrderComparer = LocalOrderComparer.getInstance();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3 = localOrderComparer.compare(nodeInfo, (NodeInfo)arrayList.get(n2));
                if (n3 <= 0) {
                    if (n3 != 0) {
                        arrayList.add(n2, nodeInfo);
                    }
                    return;
                }
                ++n2;
            }
            arrayList.add(nodeInfo);
        }
    }

    public SequenceIterator selectByKey(int n, DocumentInfo documentInfo, AtomicValue atomicValue, Controller controller) throws XPathException {
        Object object;
        Object object2 = this.getIndex(documentInfo, n);
        if (object2 instanceof String) {
            throw new XPathException.Dynamic("Key definition is circular");
        }
        HashMap hashMap = (HashMap)object2;
        if (hashMap == null) {
            this.putIndex(documentInfo, n, "Under Construction", controller);
            hashMap = this.buildIndex(n, documentInfo, controller);
            this.putIndex(documentInfo, n, hashMap, controller);
        }
        KeyDefinition keyDefinition = (KeyDefinition)this.getKeyDefinitions(n).get(0);
        int n2 = keyDefinition.getItemType();
        Collator collator = keyDefinition.getCollation();
        if (n2 == 101) {
            object = collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue());
        } else if (n2 == 104 || n2 == 105) {
            object = atomicValue.convert(n2);
            if (Double.isNaN(((NumericValue)object).asDouble())) {
                object = "NaN";
            }
        } else {
            object = atomicValue.convert(n2);
        }
        ArrayList arrayList = (ArrayList)hashMap.get(object);
        if (arrayList == null) {
            return EmptyIterator.getInstance();
        }
        return new ArrayListIterator(arrayList);
    }

    private synchronized void putIndex(DocumentInfo documentInfo, int n, Object object, Controller controller) {
        HashMap hashMap;
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap();
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null || weakReference.get() == null) {
            hashMap = new HashMap();
            controller.setUserData(documentInfo, "key-index-list", (Object)hashMap);
            this.docIndexes.put(documentInfo, new WeakReference<HashMap>(hashMap));
        } else {
            hashMap = (HashMap)weakReference.get();
        }
        hashMap.put(new Integer(n), object);
    }

    private synchronized Object getIndex(DocumentInfo documentInfo, int n) {
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap();
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null) {
            return null;
        }
        HashMap hashMap = (HashMap)weakReference.get();
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(new Integer(n));
    }
}

