/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.functions.FormatNumber2;

public class DecimalFormatManager
implements Serializable {
    private DecimalFormatSymbols defaultDFS;
    private HashMap formatTable = new HashMap();
    private boolean usingOriginalDefault = true;

    public DecimalFormatManager() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        this.defaultDFS = decimalFormatSymbols;
    }

    public static void setDefaults(DecimalFormatSymbols decimalFormatSymbols) {
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setInfinity("Infinity");
        decimalFormatSymbols.setMinusSign('-');
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setPerMill('\u2030');
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setPatternSeparator(';');
    }

    public void setDefaultDecimalFormat(DecimalFormatSymbols decimalFormatSymbols) throws TransformerConfigurationException {
        if (!this.usingOriginalDefault && !decimalFormatSymbols.equals(this.defaultDFS)) {
            throw new TransformerConfigurationException("There are two conflicting definitions of the default decimal format");
        }
        this.defaultDFS = decimalFormatSymbols;
        this.usingOriginalDefault = false;
        this.setNamedDecimalFormat("", "", decimalFormatSymbols);
    }

    public void fixupDefaultDefault() throws TransformerConfigurationException {
        if (this.usingOriginalDefault) {
            this.setNamedDecimalFormat("", "", this.defaultDFS);
        }
    }

    public DecimalFormatSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(String string, String string2, DecimalFormatSymbols decimalFormatSymbols) throws TransformerConfigurationException {
        String string3 = string2 + '#' + string;
        Object v = this.formatTable.get(string3);
        if (v != null) {
            if (v instanceof List) {
                Iterator iterator = ((List)v).iterator();
                while (iterator.hasNext()) {
                    FormatNumber2 formatNumber2 = (FormatNumber2)iterator.next();
                    formatNumber2.fixup(decimalFormatSymbols);
                }
            } else {
                DecimalFormatSymbols decimalFormatSymbols2 = (DecimalFormatSymbols)v;
                if (!decimalFormatSymbols.equals(decimalFormatSymbols2)) {
                    throw new TransformerConfigurationException("Duplicate declaration of decimal-format");
                }
            }
        }
        this.formatTable.put(string3, decimalFormatSymbols);
    }

    public void registerUsage(String string, String string2, FormatNumber2 formatNumber2) {
        String string3 = string2 + '#' + string;
        Object v = this.formatTable.get(string3);
        if (v == null) {
            ArrayList<FormatNumber2> arrayList = new ArrayList<FormatNumber2>();
            arrayList.add(formatNumber2);
            this.formatTable.put(string3, arrayList);
        } else if (v instanceof List) {
            List list = (List)v;
            list.add(formatNumber2);
        } else {
            formatNumber2.fixup((DecimalFormatSymbols)v);
        }
    }

    public DecimalFormatSymbols getNamedDecimalFormat(String string, String string2) {
        String string3 = string2 + '#' + string;
        return (DecimalFormatSymbols)this.formatTable.get(string3);
    }
}

