/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Builder;
import net.sf.saxon.tinytree.TinyDocumentImpl;

public class TinyBuilder
extends Builder {
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private int[] sizeParameters;
    private int[] prevAtDepth = new int[100];

    public void setSizeParameters(int[] nArray) {
        this.sizeParameters = nArray;
    }

    public void createDocument() {
        this.currentDocument = this.sizeParameters == null ? new TinyDocumentImpl() : new TinyDocumentImpl(this.sizeParameters[0], this.sizeParameters[1], this.sizeParameters[2], this.sizeParameters[3]);
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        tinyDocumentImpl.setSystemId(this.getSystemId());
        tinyDocumentImpl.setNamePool(this.namePool);
    }

    public void startDocument() throws TransformerException {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.currentDocument == null) {
            this.createDocument();
        } else {
            if (!(this.currentDocument instanceof TinyDocumentImpl)) {
                throw new TransformerException("Root node supplied is of wrong type");
            }
            if (this.currentDocument.hasChildNodes()) {
                throw new TransformerException("Supplied document is not empty");
            }
            this.currentDocument.setNamePool(this.namePool);
        }
        this.currentDepth = 0;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (this.lineNumbering) {
            tinyDocumentImpl.setLineNumbering();
        }
        tinyDocumentImpl.addNode((short)9, 0, 0, 0, -1);
        this.prevAtDepth[0] = 0;
        this.prevAtDepth[1] = -1;
        tinyDocumentImpl.next[0] = -1;
        ++this.currentDepth;
        super.startDocument();
    }

    public void endDocument() throws TransformerException {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        super.endDocument();
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        int n4;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        this.nodeNr = tinyDocumentImpl.addNode((short)1, this.currentDepth, -1, -1, n);
        if (n2 != 0) {
            tinyDocumentImpl.setElementAnnotation(this.nodeNr, n2);
        }
        if ((n4 = this.prevAtDepth[this.currentDepth]) > 0) {
            tinyDocumentImpl.next[n4] = this.nodeNr;
        }
        tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] nArray = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, nArray, 0, this.currentDepth);
            this.prevAtDepth = nArray;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        if (this.locator != null) {
            tinyDocumentImpl.setSystemId(this.nodeNr, this.locator.getSystemId());
            if (this.lineNumbering) {
                tinyDocumentImpl.setLineNumber(this.nodeNr, this.locator.getLineNumber());
            }
        }
    }

    public void namespace(int n, int n2) throws TransformerException {
        ((TinyDocumentImpl)this.currentDocument).addNamespace(this.nodeNr, n);
    }

    public void attribute(int n, int n2, String string, int n3) throws TransformerException {
        if ((n3 & 1) != 0) {
            throw new TransformerException("Cannot disable output escaping when writing a tree");
        }
        ((TinyDocumentImpl)this.currentDocument).addAttribute(this.nodeNr, n, n2, string);
    }

    public void startContent() {
        ++this.nodeNr;
    }

    public void endElement() throws TransformerException {
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (charSequence.length() > 0) {
            if ((n & 1) != 0) {
                throw new TransformerException("Cannot disable output escaping when writing a tree");
            }
            int n2 = tinyDocumentImpl.charBufferLength;
            tinyDocumentImpl.appendChars(charSequence);
            this.nodeNr = tinyDocumentImpl.addNode((short)3, this.currentDepth, n2, charSequence.length(), -1);
            int n3 = this.prevAtDepth[this.currentDepth];
            if (n3 > 0) {
                tinyDocumentImpl.next[n3] = this.nodeNr;
            }
            tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (tinyDocumentImpl.commentBuffer == null) {
            tinyDocumentImpl.commentBuffer = new StringBuffer();
        }
        int n2 = tinyDocumentImpl.commentBuffer.length();
        tinyDocumentImpl.commentBuffer.append(charSequence.toString());
        int n3 = this.namePool.allocate("", "", string);
        this.nodeNr = tinyDocumentImpl.addNode((short)7, this.currentDepth, n2, charSequence.length(), n3);
        int n4 = this.prevAtDepth[this.currentDepth];
        if (n4 > 0) {
            tinyDocumentImpl.next[n4] = this.nodeNr;
        }
        tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (tinyDocumentImpl.commentBuffer == null) {
            tinyDocumentImpl.commentBuffer = new StringBuffer();
        }
        int n2 = tinyDocumentImpl.commentBuffer.length();
        tinyDocumentImpl.commentBuffer.append(charSequence.toString());
        this.nodeNr = tinyDocumentImpl.addNode((short)8, this.currentDepth, n2, charSequence.length(), -1);
        int n3 = this.prevAtDepth[this.currentDepth];
        if (n3 > 0) {
            tinyDocumentImpl.next[n3] = this.nodeNr;
        }
        tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
    }

    public void setUnparsedEntity(String string, String string2, String string3) {
        ((TinyDocumentImpl)this.currentDocument).setUnparsedEntity(string, string2, string3);
    }
}

