/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;

final class FollowingEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl document;
    private TinyNodeImpl startNode;
    private int nextNodeNr;
    private NodeTest test;
    private boolean includeDescendants;

    public FollowingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.includeDescendants = bl;
        short s = tinyDocumentImpl.depth[this.nextNodeNr];
        if (bl) {
            ++this.nextNodeNr;
        } else {
            do {
                ++this.nextNodeNr;
                if (this.nextNodeNr < tinyDocumentImpl.numberOfNodes) continue;
                this.nextNodeNr = -1;
                return;
            } while (tinyDocumentImpl.depth[this.nextNodeNr] > s);
        }
        if (!this.test.matches(tinyDocumentImpl.nodeKind[this.nextNodeNr], tinyDocumentImpl.nameCode[this.nextNodeNr], tinyDocumentImpl.getElementAnnotation(this.nextNodeNr))) {
            this.advance();
        }
    }

    private void advance() {
        do {
            ++this.nextNodeNr;
            if (this.nextNodeNr < this.document.numberOfNodes) continue;
            this.nextNodeNr = -1;
            return;
        } while (!this.test.matches(this.document.nodeKind[this.nextNodeNr], this.document.nameCode[this.nextNodeNr], this.document.getElementAnnotation(this.nextNodeNr)));
    }

    public boolean hasNext() {
        return this.nextNodeNr >= 0;
    }

    public Item next() {
        ++this.position;
        this.current = this.document.getNode(this.nextNodeNr);
        this.advance();
        return this.current;
    }

    public SequenceIterator getAnother() {
        return new FollowingEnumeration(this.document, this.startNode, this.test, this.includeDescendants);
    }
}

