/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;

final class AttributeEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl doc;
    private int element;
    private NodeTest nodeTest;
    private int index;

    protected AttributeEnumeration(TinyDocumentImpl tinyDocumentImpl, int n, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.doc = tinyDocumentImpl;
        this.element = n;
        this.index = tinyDocumentImpl.alpha[n];
        this.advance();
    }

    public boolean hasNext() {
        return this.index >= 0;
    }

    public Item next() {
        ++this.position;
        int n = this.index++;
        if (this.nodeTest instanceof NameTest) {
            this.index = -1;
        } else {
            this.advance();
        }
        this.current = this.doc.getAttributeNode(n);
        return this.current;
    }

    private void advance() {
        while (true) {
            if (this.index >= this.doc.numberOfAttributes || this.doc.attParent[this.index] != this.element) {
                this.index = -1;
                return;
            }
            if (this.nodeTest.matches(2, this.doc.attCode[this.index], this.doc.getAttributeAnnotation(this.index))) {
                return;
            }
            ++this.index;
        }
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.doc, this.element, this.nodeTest);
    }
}

