/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Variable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class XSLVariable
extends XSLVariableDeclaration {
    private int state = 0;

    public void prepareAttributes() throws TransformerConfigurationException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable");
        }
        this.state = 1;
        super.prepareAttributes();
        this.state = 2;
    }

    public boolean isInstruction() {
        return true;
    }

    public SequenceType getRequiredType() {
        SequenceType sequenceType;
        SequenceType sequenceType2 = sequenceType = this.requiredType == null ? SequenceType.ANY_SEQUENCE : this.requiredType;
        if (this.assignable) {
            return sequenceType;
        }
        if (this.requiredType != null) {
            return this.requiredType;
        }
        if (this.select != null) {
            if (this.select instanceof EmptySequence) {
                return sequenceType;
            }
            try {
                return new SequenceType(this.select.getItemType(), 88, this.select.getCardinality());
            }
            catch (Exception exception) {
                return sequenceType;
            }
        }
        if (this.hasChildNodes()) {
            return new SequenceType(9, 88, 512);
        }
        return SequenceType.SINGLE_STRING;
    }

    public Instruction compile() throws TransformerConfigurationException {
        if (this.references.size() == 0 && !this.assignable) {
            this.redundant = true;
        }
        if (this.global && !this.redundant) {
            this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        }
        if (!this.redundant) {
            Variable variable = new Variable();
            this.initializeInstruction(variable);
            variable.setVariableName(this.getVariableName());
            variable.setSlotNumber(this.getSlotNumber());
            variable.setRequiredType(this.getRequiredType());
            this.fixupBinding(variable);
            return variable;
        }
        return null;
    }
}

