/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class XSLTemplate
extends StyleElement {
    private int[] modeNameCodes;
    private int templateFingerprint = -1;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private Procedure procedure = new Procedure();
    private boolean needsStackFrame;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;

    public boolean mayContainTemplateBody() {
        return true;
    }

    public int getTemplateFingerprint() {
        try {
            if (this.templateFingerprint == -1) {
                StandardNames standardNames = this.getStandardNames();
                String string = this.getAttributeList().getValue(standardNames.NAME);
                if (string != null) {
                    this.templateFingerprint = this.makeNameCode(string, false) & 0xFFFFF;
                }
            }
            return this.templateFingerprint;
        }
        catch (NamespaceException namespaceException) {
            return -1;
        }
        catch (XPathException xPathException) {
            return -1;
        }
    }

    protected int getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    private int getMinImportPrecedence() {
        return ((XSLStyleSheet)this.getDocumentElement()).getMinImportPrecedence();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        int n2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n3 = 0;
        while (n3 < attributeCollection.getLength()) {
            n2 = attributeCollection.getNameCode(n3);
            n = n2 & 0xFFFFF;
            if (n == standardNames.MODE) {
                string = attributeCollection.getValue(n3).trim();
            } else if (n == standardNames.NAME) {
                string2 = attributeCollection.getValue(n3).trim();
            } else if (n == standardNames.MATCH) {
                string4 = attributeCollection.getValue(n3);
            } else if (n == standardNames.PRIORITY) {
                string3 = attributeCollection.getValue(n3).trim();
            } else if (n == standardNames.AS) {
                string5 = attributeCollection.getValue(n3);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n3;
        }
        try {
            if (string == null) {
                this.modeNameCodes = new int[1];
                this.modeNameCodes[0] = -1;
            } else {
                if (string4 == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent");
                }
                n2 = 0;
                n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n2;
                }
                this.modeNameCodes = new int[n2];
                n2 = 0;
                stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (string6.equals("#default")) {
                        this.modeNameCodes[n2++] = -1;
                        continue;
                    }
                    if (string6.equals("#all")) {
                        n = 1;
                        this.modeNameCodes[n2++] = -2;
                        continue;
                    }
                    this.modeNameCodes[n2++] = this.makeNameCode(string6, false);
                }
                if (n != 0 && n2 > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes");
                }
            }
            if (string2 != null) {
                this.templateFingerprint = this.makeNameCode(string2, false) & 0xFFFFF;
            }
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
        boolean bl = this.prioritySpecified = string3 != null;
        if (this.prioritySpecified) {
            if (string4 == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent");
            }
            try {
                this.priority = new Double(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ")");
            }
        }
        if (string4 != null) {
            this.match = this.makePattern(string4);
        }
        if (this.match == null && string2 == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)");
        }
        if (string5 != null) {
            this.requiredType = this.makeSequenceType(string5);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        if (this.templateFingerprint != -1) {
            AxisIterator axisIterator = this.iterateAxis((byte)11);
            while (axisIterator.hasNext()) {
                XSLTemplate xSLTemplate;
                Item item = axisIterator.next();
                if (!(item instanceof XSLTemplate) || (xSLTemplate = (XSLTemplate)item).getTemplateFingerprint() != this.templateFingerprint || xSLTemplate.getPrecedence() != this.getPrecedence()) continue;
                this.compileError("There is another template with the same name and precedence");
            }
        }
        this.typeCheck("match", this.match);
        this.markTailCalls();
    }

    public void markTailCalls() {
        StyleElement styleElement;
        if (this.requiredType == null && (styleElement = this.getLastChildInstruction()) != null) {
            styleElement.markTailCalls();
        }
    }

    public Pattern getContextNodePattern() {
        return this.match;
    }

    public Instruction compile() throws TransformerConfigurationException {
        Sequence sequence = new Sequence(null, this.requiredType);
        this.compileChildren(sequence);
        this.needsStackFrame = this.procedure.getNumberOfVariables() > 0;
        this.compiledTemplate.init(sequence, this.needsStackFrame, this.getPrecedence(), this.getMinImportPrecedence());
        if (this.match != null) {
            RuleManager ruleManager = this.getPrincipalStyleSheet().getRuleManager();
            int n = 0;
            while (n < this.modeNameCodes.length) {
                int n2 = this.modeNameCodes[n];
                Mode mode = ruleManager.getMode(n2);
                if (n2 != -1 && n2 != -2) {
                    mode.setModeName(this.getTargetNamePool().getDisplayName(n2));
                }
                if (this.prioritySpecified) {
                    ruleManager.setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence(), this.priority);
                } else {
                    ruleManager.setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence());
                }
                ++n;
            }
        }
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        return this.compiledTemplate;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }
}

