/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.tree.AttributeCollection;

public class XSLSortKey
extends StyleElement {
    private String keyURI;
    private String keyLocalName;

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        if (!Name.isQName(string)) {
            this.compileError("Name of sort key must be a valid QName");
            return;
        }
        try {
            String[] stringArray = Name.getQNameParts(string);
            this.keyLocalName = stringArray[1];
            this.keyURI = this.getURIForPrefix(stringArray[0], false);
        }
        catch (NamespaceException namespaceException) {
            this.compileError("Invalid sort key name. " + namespaceException.getMessage());
        }
        catch (QNameException qNameException) {
            this.compileError("Invalid sort key name. " + qNameException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        if (!this.hasChildNodes()) {
            this.compileError("xsl:sort-key declaration must have child xsl:sort elements");
        }
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (nodeInfo instanceof XSLSort || nodeInfo.getItemType() == 3 && Navigator.isWhite(nodeInfo.getStringValue())) continue;
            this.compileError("Only xsl:sort is allowed as a child of xsl:sort-key");
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        this.getPrincipalStyleSheet().setSortSpecification(this.keyURI, this.keyLocalName, this.makeSortKeys());
        return null;
    }
}

