/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.Collator;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public class XSLKey
extends StyleElement {
    private int keyFingerprint = -1;
    private Pattern match;
    private Expression use;
    private int itemType;
    private String collationName;

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.USE) {
                string3 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.MATCH) {
                string2 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.AS) {
                string4 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.COLLATION) {
                this.collationName = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.keyFingerprint = this.makeNameCode(string, false) & 0xFFFFF;
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
        if (string2 == null) {
            this.reportAbsence("match");
            string2 = "*";
        }
        this.match = this.makePattern(string2);
        if (string3 == null) {
            this.reportAbsence("use");
            string3 = ".";
        }
        this.use = this.makeExpression(string3);
        if (string4 == null) {
            this.itemType = 101;
        } else {
            if (!Name.isQName(string4)) {
                this.compileError("Data type '" + string4 + "'is not a valid QName'");
            }
            try {
                String[] stringArray = Name.getQNameParts(string4);
                String string5 = this.getURIForPrefix(stringArray[0], false);
                this.itemType = Type.getNamedType(string5, stringArray[1]);
                if (!Type.isSubType(this.itemType, 90)) {
                    this.compileError("The type of the key values must be an atomic type");
                }
            }
            catch (NamespaceException namespaceException) {
                this.compileError("Invalid type. " + namespaceException.getMessage());
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid type. " + qNameException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
        try {
            if (this.use == null) {
                return;
            }
            RoleLocator roleLocator = new RoleLocator(4, "xsl:key/use", 0);
            this.use = TypeChecker.staticTypeCheck(this.use, new SequenceType(this.itemType, 88, 1792), false, roleLocator);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
    }

    public Instruction compile() throws TransformerConfigurationException {
        Object object;
        Collator collator = null;
        if (this.collationName != null) {
            object = this.getPrincipalStyleSheet().findCollation(this.collationName);
            if (object == null) {
                this.compileError("The collation name '" + this.collationName + "' has not been defined");
            }
            if (!(object instanceof Collator)) {
                this.compileError("The collation used for xsl:key must be a java.text.Collator");
            }
            collator = (Collator)object;
        }
        object = this.getPrincipalStyleSheet().getKeyManager();
        KeyDefinition keyDefinition = new KeyDefinition(this.match, this.use, this.itemType, collator);
        ((KeyManager)object).setKeyDefinition(this.keyFingerprint, keyDefinition);
        return null;
    }
}

