/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.DecimalFormatSymbols;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.tree.AttributeCollection;

public class XSLDecimalFormat
extends StyleElement {
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                this.name = attributeCollection.getValue(n);
            } else if (n3 == standardNames.DECIMAL_SEPARATOR) {
                this.decimalSeparator = attributeCollection.getValue(n);
            } else if (n3 == standardNames.GROUPING_SEPARATOR) {
                this.groupingSeparator = attributeCollection.getValue(n);
            } else if (n3 == standardNames.INFINITY) {
                this.infinity = attributeCollection.getValue(n);
            } else if (n3 == standardNames.MINUS_SIGN) {
                this.minusSign = attributeCollection.getValue(n);
            } else if (n3 == standardNames.NAN) {
                this.NaN = attributeCollection.getValue(n);
            } else if (n3 == standardNames.PERCENT) {
                this.percent = attributeCollection.getValue(n);
            } else if (n3 == standardNames.PER_MILLE) {
                this.perMille = attributeCollection.getValue(n);
            } else if (n3 == standardNames.ZERO_DIGIT) {
                this.zeroDigit = attributeCollection.getValue(n);
            } else if (n3 == standardNames.DIGIT) {
                this.digit = attributeCollection.getValue(n);
            } else if (n3 == standardNames.PATTERN_SEPARATOR) {
                this.patternSeparator = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
    }

    public Instruction compile() throws TransformerConfigurationException {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        if (this.decimalSeparator != null) {
            decimalFormatSymbols.setDecimalSeparator(this.toChar(this.decimalSeparator));
        }
        if (this.groupingSeparator != null) {
            decimalFormatSymbols.setGroupingSeparator(this.toChar(this.groupingSeparator));
        }
        if (this.infinity != null) {
            decimalFormatSymbols.setInfinity(this.infinity);
        }
        if (this.minusSign != null) {
            decimalFormatSymbols.setMinusSign(this.toChar(this.minusSign));
        }
        if (this.NaN != null) {
            decimalFormatSymbols.setNaN(this.NaN);
        }
        if (this.percent != null) {
            decimalFormatSymbols.setPercent(this.toChar(this.percent));
        }
        if (this.perMille != null) {
            decimalFormatSymbols.setPerMill(this.toChar(this.perMille));
        }
        if (this.zeroDigit != null) {
            decimalFormatSymbols.setZeroDigit(this.toChar(this.zeroDigit));
        }
        if (this.digit != null) {
            decimalFormatSymbols.setDigit(this.toChar(this.digit));
        }
        if (this.patternSeparator != null) {
            decimalFormatSymbols.setPatternSeparator(this.toChar(this.patternSeparator));
        }
        DecimalFormatManager decimalFormatManager = this.getPrincipalStyleSheet().getDecimalFormatManager();
        if (this.name == null) {
            decimalFormatManager.setDefaultDecimalFormat(decimalFormatSymbols);
        } else {
            try {
                String[] stringArray = Name.getQNameParts(this.name);
                String string = this.getURIForPrefix(stringArray[0], false);
                decimalFormatManager.setNamedDecimalFormat(string, stringArray[1], decimalFormatSymbols);
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid decimal format name. " + qNameException.getMessage());
            }
            catch (NamespaceException namespaceException) {
                this.compileError("Invalid decimal format name. " + namespaceException.getMessage());
            }
        }
        return null;
    }

    private char toChar(String string) throws TransformerConfigurationException {
        if (string.length() != 1) {
            this.compileError("Attribute \"" + string + "\" should be a single character");
        }
        return string.charAt(0);
    }
}

