/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.AttributeCollection;

public class XSLCharacterMap
extends StyleElement {
    int fingerprint;
    String use;
    List characterMapElements = null;
    boolean validated = false;
    boolean redundant = false;

    public int getCharacterMapFingerprint() {
        return this.fingerprint;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        this.use = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.USE_CHARACTER_MAPS) {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = this.getURIForPrefix(stringArray[0], true);
            int n4 = this.getTargetNamePool().allocate(stringArray[0], string2, stringArray[1]);
            this.fingerprint = n4 & 0xFFFFF;
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (QNameException qNameException) {
            this.compileError(qNameException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        if (this.validated) {
            return;
        }
        this.checkTopLevel();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            if (axisIterator.next() instanceof XSLOutputCharacter) continue;
            this.compileError("Only xsl:output-character is allowed within xsl:character-map");
        }
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        XSLCharacterMap xSLCharacterMap = xSLStyleSheet.getCharacterMap(this.fingerprint);
        if (xSLCharacterMap != this) {
            if (this.getPrecedence() == xSLCharacterMap.getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence");
            } else if (this.getPrecedence() < xSLCharacterMap.getPrecedence()) {
                this.redundant = true;
            }
        }
        if (this.use != null) {
            Object object;
            this.characterMapElements = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.use);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                try {
                    String[] stringArray = Name.getQNameParts((String)object);
                    String string = this.getURIForPrefix(stringArray[0], true);
                    int n = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                    XSLCharacterMap xSLCharacterMap2 = xSLStyleSheet.getCharacterMap(n & 0xFFFFF);
                    if (xSLCharacterMap2 == null) {
                        this.compileError("No character-map named '" + (String)object + "' has been defined");
                        continue;
                    }
                    this.characterMapElements.add(xSLCharacterMap2);
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid character-map name. " + qNameException.getMessage());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
            }
            object = this.characterMapElements.iterator();
            while (object.hasNext()) {
                ((XSLCharacterMap)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    private void checkCircularity(XSLCharacterMap xSLCharacterMap) throws TransformerConfigurationException {
        if (this == xSLCharacterMap) {
            this.compileError("The definition of the character map is circular");
            this.characterMapElements = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.characterMapElements != null) {
                Iterator iterator = this.characterMapElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLCharacterMap)iterator.next()).checkCircularity(xSLCharacterMap);
                }
            }
        }
    }

    public void assemble(HashMap hashMap) {
        StyleElement styleElement;
        if (this.characterMapElements != null) {
            int n = 0;
            while (n < this.characterMapElements.size()) {
                styleElement = (XSLCharacterMap)this.characterMapElements.get(n);
                ((XSLCharacterMap)styleElement).assemble(hashMap);
                ++n;
            }
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            styleElement = (XSLOutputCharacter)axisIterator.next();
            hashMap.put(new Integer(((XSLOutputCharacter)styleElement).getCodePoint()), ((XSLOutputCharacter)styleElement).getReplacementString());
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }
}

