/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private int modeNameCode = -1;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;
    private String modeAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.MODE) {
                this.modeAttribute = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.modeAttribute != null) {
            if (this.modeAttribute.equals("#current")) {
                this.useCurrentMode = true;
            } else if (!this.modeAttribute.equals("#default")) {
                try {
                    this.modeNameCode = this.makeNameCode(this.modeAttribute, false);
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                catch (XPathException xPathException) {
                    this.compileError("Mode name " + this.modeAttribute + " is not a valid QName");
                }
            }
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        Object object;
        this.checkWithinTemplate();
        if (!this.useCurrentMode) {
            this.mode = this.getPrincipalStyleSheet().getRuleManager().getMode(this.modeNameCode);
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            object = (NodeInfo)axisIterator.next();
            if (object instanceof XSLSort || object instanceof XSLWithParam) continue;
            if (object.getItemType() == 3) {
                if (Navigator.isWhite(object.getStringValue())) continue;
                this.compileError("No character data allowed within xsl:apply-templates");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates");
        }
        if (this.select == null) {
            this.select = new AxisExpression(3, null);
        }
        this.select = this.typeCheck("select", this.select);
        try {
            object = new RoleLocator(4, "xsl:apply-templates/select", 0);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, (RoleLocator)object);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public void markTailCalls() {
        this.useTailRecursion = true;
    }

    public Instruction compile() throws TransformerConfigurationException {
        return new ApplyTemplates(this.select, this.makeSortKeys(), this.getWithParamInstructions(), this.useCurrentMode, this.useTailRecursion, this.mode);
    }
}

