/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedTupleIterator;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class TupleSorter
extends ComputedExpression
implements MappingFunction {
    private Expression base;
    private FixedSortKeyDefinition[] sortKeys;

    public TupleSorter(Expression expression, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) {
        this.base = expression;
        this.sortKeys = fixedSortKeyDefinitionArray;
    }

    public Expression simplify() throws XPathException {
        this.base = this.base.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.base = this.base.analyze(staticContext);
        return this;
    }

    public int getItemType() {
        return 88;
    }

    public int computeCardinality() {
        return 1792;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[this.sortKeys.length + 1];
        expressionArray[0] = this.base;
        int n = 0;
        while (n < this.sortKeys.length) {
            expressionArray[n + 1] = this.sortKeys[n].getSortKey();
            ++n;
        }
        return expressionArray;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.base = this.base.promote(promotionOffer);
        int n = 0;
        while (n < this.sortKeys.length) {
            this.sortKeys[n].setSortKey(this.sortKeys[n].getSortKey().promote(promotionOffer));
            ++n;
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SortedTupleIterator sortedTupleIterator = new SortedTupleIterator(xPathContext, this.base.iterate(xPathContext), this.sortKeys);
        MappingIterator mappingIterator = new MappingIterator(sortedTupleIterator, this, xPathContext, null);
        return mappingIterator;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.base.effectiveBooleanValue(xPathContext);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "TupleSorter");
        this.base.display(n + 1);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        Value value = (Value)((ObjectValue)item).getObject();
        return value.iterate(xPathContext);
    }
}

