/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class TupleExpression
extends ComputedExpression {
    Expression[] components;

    public TupleExpression(int n) {
        this.components = new Expression[n];
    }

    public void setExpression(int n, Expression expression) {
        this.components[n] = expression;
    }

    public Expression simplify() throws XPathException {
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = this.components[n].simplify();
            ++n;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = this.components[n].promote(promotionOffer);
            ++n;
        }
        return this;
    }

    public int getItemType() {
        return 130;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        int n = 0;
        while (n < this.components.length) {
            this.components[n] = this.components[n].analyze(staticContext);
            ++n;
        }
        return this;
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "Tuple");
        int n2 = 0;
        while (n2 < this.components.length) {
            this.components[n2].display(n + 1);
            ++n2;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value[] valueArray = new Value[this.components.length];
        int n = 0;
        while (n < this.components.length) {
            valueArray[n] = ExpressionTool.eagerEvaluate(this.components[n], xPathContext);
            ++n;
        }
        return new ObjectValue(valueArray);
    }

    public int computeCardinality() {
        return 512;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Expression[] getSubExpressions() {
        return this.components;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return super.iterate(xPathContext);
    }
}

