/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Comparator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.QuickSort;
import net.sf.saxon.sort.Sortable;
import net.sf.saxon.xpath.XPathException;

public class SortedIterator
implements SequenceIterator,
LastPositionFinder,
Sortable {
    protected SequenceIterator base;
    protected FixedSortKeyDefinition[] sortkeys;
    protected int recordSize;
    protected Object[] nodeKeys;
    protected int count = -1;
    protected int index = 0;
    protected XPathContext context;
    private Comparator[] keyComparers;

    public SortedIterator(XPathContext xPathContext, SequenceIterator sequenceIterator, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) throws XPathException {
        this.context = xPathContext.newContext();
        this.base = sequenceIterator;
        this.sortkeys = fixedSortKeyDefinitionArray;
        this.recordSize = fixedSortKeyDefinitionArray.length + 2;
        this.keyComparers = new Comparator[fixedSortKeyDefinitionArray.length];
        int n = 0;
        while (n < fixedSortKeyDefinitionArray.length) {
            this.keyComparers[n] = fixedSortKeyDefinitionArray[n].getComparer(xPathContext);
            ++n;
        }
    }

    public boolean hasNext() throws XPathException {
        if (this.count < 0) {
            return this.base.hasNext();
        }
        return this.index < this.count;
    }

    public Item next() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return (Item)this.nodeKeys[this.index++ * this.recordSize];
    }

    public Item current() {
        return (Item)this.nodeKeys[(this.index - 1) * this.recordSize];
    }

    public int position() {
        return this.index;
    }

    public int getLastPosition() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new SortedIterator(this.context, this.base.getAnother(), this.sortkeys);
    }

    protected void buildArray() throws XPathException {
        int n = 100;
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        SequenceIterator sequenceIterator = this.context.getCurrentIterator();
        this.context.setCurrentIterator(this.base);
        Controller controller = this.context.getController();
        SequenceIterator sequenceIterator2 = controller.getCurrentIterator();
        controller.setCurrentIterator(this.base);
        while (this.base.hasNext()) {
            Item item = this.base.next();
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = item;
            int n3 = 0;
            while (n3 < this.sortkeys.length) {
                this.nodeKeys[n2 + n3 + 1] = this.sortkeys[n3].getSortKey().evaluateItem(this.context);
                ++n3;
            }
            this.nodeKeys[n2 + this.sortkeys.length + 1] = new Integer(this.count);
            ++this.count;
        }
        this.context.setCurrentIterator(sequenceIterator);
        controller.setCurrentIterator(sequenceIterator2);
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        QuickSort.sort(this, 0, this.count - 1);
    }

    public int compare(int n, int n2) {
        int n3 = n * this.recordSize + 1;
        int n4 = n2 * this.recordSize + 1;
        int n5 = 0;
        while (n5 < this.sortkeys.length) {
            Comparator comparator = this.keyComparers[n5];
            int n6 = this.nodeKeys[n3 + n5] == null ? (this.nodeKeys[n4 + n5] == null ? 0 : -1) : (this.nodeKeys[n4 + n5] == null ? 1 : comparator.compare(this.nodeKeys[n3 + n5], this.nodeKeys[n4 + n5]));
            if (n6 != 0) {
                return n6;
            }
            ++n5;
        }
        return (Integer)this.nodeKeys[n3 + this.sortkeys.length] - (Integer)this.nodeKeys[n4 + this.sortkeys.length];
    }

    public void swap(int n, int n2) {
        int n3 = n * this.recordSize;
        int n4 = n2 * this.recordSize;
        int n5 = 0;
        while (n5 < this.recordSize) {
            Object object = this.nodeKeys[n3 + n5];
            this.nodeKeys[n3 + n5] = this.nodeKeys[n4 + n5];
            this.nodeKeys[n4 + n5] = object;
            ++n5;
        }
    }
}

