/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class SortedGroupIterator
extends SortedIterator
implements GroupIterator {
    public SortedGroupIterator(XPathContext xPathContext, GroupIterator groupIterator, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) throws XPathException {
        super(xPathContext, groupIterator, fixedSortKeyDefinitionArray);
        this.recordSize += 2;
    }

    protected void buildArray() throws XPathException {
        int n = 100;
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        SequenceIterator sequenceIterator = this.context.getCurrentIterator();
        this.context.setCurrentIterator(this.base);
        Controller controller = this.context.getController();
        SequenceIterator sequenceIterator2 = controller.getCurrentIterator();
        GroupIterator groupIterator = controller.getCurrentGroupIterator();
        controller.setCurrentIterator(this.base);
        controller.setCurrentGroupIterator((GroupIterator)this.base);
        while (this.base.hasNext()) {
            Item item = this.base.next();
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = item;
            int n3 = 0;
            while (n3 < this.sortkeys.length) {
                this.nodeKeys[n2 + n3 + 1] = this.sortkeys[n3].getSortKey().evaluateItem(this.context);
                ++n3;
            }
            this.nodeKeys[n2 + this.sortkeys.length + 1] = new Integer(this.count);
            this.nodeKeys[n2 + this.sortkeys.length + 2] = ((GroupIterator)this.base).getCurrentGroupingKey();
            this.nodeKeys[n2 + this.sortkeys.length + 3] = ((GroupIterator)this.base).iterateCurrentGroup();
            ++this.count;
        }
        this.context.setCurrentIterator(sequenceIterator);
        controller.setCurrentIterator(sequenceIterator2);
        controller.setCurrentGroupIterator(groupIterator);
    }

    public AtomicValue getCurrentGroupingKey() {
        return (AtomicValue)this.nodeKeys[(this.index - 1) * this.recordSize + this.sortkeys.length + 2];
    }

    public SequenceIterator iterateCurrentGroup() throws XPathException {
        SequenceIterator sequenceIterator = (SequenceIterator)this.nodeKeys[(this.index - 1) * this.recordSize + this.sortkeys.length + 3];
        return sequenceIterator.getAnother();
    }
}

