/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.LowercaseFirstComparer;
import net.sf.saxon.sort.NumericComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.TextComparer;
import net.sf.saxon.sort.UppercaseFirstComparer;
import net.sf.saxon.style.SAXONCollation;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class FixedSortKeyDefinition
extends SortKeyDefinition {
    private transient Comparator comparer = null;

    public SortKeyDefinition simplify() throws XPathException {
        this.comparer = this.bindComparer();
        return this;
    }

    public int getDependencies() {
        return this.sortKey.getDependencies() & 0x21;
    }

    public FixedSortKeyDefinition reduce(XPathContext xPathContext) throws XPathException {
        if (this.getDependencies() == 0) {
            return this;
        }
        FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
        fixedSortKeyDefinition.setSortKey(this.sortKey);
        fixedSortKeyDefinition.order = this.order;
        fixedSortKeyDefinition.dataTypeExpression = this.dataTypeExpression;
        fixedSortKeyDefinition.caseOrder = this.caseOrder;
        fixedSortKeyDefinition.language = this.language;
        fixedSortKeyDefinition.collation = this.collation;
        fixedSortKeyDefinition.comparer = this.comparer;
        return fixedSortKeyDefinition;
    }

    private Comparator bindComparer() throws XPathException {
        Object object;
        Comparator comparator;
        String string = ((StringValue)this.order).getStringValue();
        String string2 = ((StringValue)this.caseOrder).getStringValue();
        String string3 = ((StringValue)this.language).getStringValue();
        if (this.collation != null) {
            comparator = this.collation;
        } else {
            if (string3.equals("")) {
                object = Collator.getInstance();
            } else {
                Locale locale = SAXONCollation.getLocale(string3);
                object = Collator.getInstance(locale);
            }
            comparator = this.getCaseOrderComparer((Collator)object, string2);
        }
        if (this.dataTypeExpression == null || this.dataTypeExpression instanceof EmptySequence) {
            object = new RoleLocator(4, "xsl:sort/sort-key", 0);
            this.sortKey = new CardinalityChecker(this.sortKey, 768, (RoleLocator)object);
            comparator = new AtomicSortComparer(comparator);
        } else {
            object = ((StringValue)this.dataTypeExpression).getStringValue();
            if (((String)object).equals("text")) {
                comparator = new TextComparer(comparator);
            } else if (((String)object).equals("number")) {
                comparator = new NumericComparer();
            } else {
                throw new XPathException.Dynamic("data-type on xsl:sort must be 'text' or 'number'");
            }
        }
        comparator = this.getOrderedComparer(comparator, string);
        return comparator;
    }

    private Comparator getOrderedComparer(Comparator comparator, String string) throws XPathException {
        if (string.equals("ascending")) {
            return comparator;
        }
        if (string.equals("descending")) {
            return new DescendingComparer(comparator);
        }
        throw new XPathException.Dynamic("order must be 'ascending' or 'descending'");
    }

    private Comparator getCaseOrderComparer(Collator collator, String string) throws XPathException {
        if (string.equals("#default")) {
            return collator;
        }
        if (string.equals("lower-first")) {
            return new LowercaseFirstComparer(collator);
        }
        if (string.equals("upper-first")) {
            return new UppercaseFirstComparer(collator);
        }
        throw new XPathException.Dynamic("case-order must be lower-first or upper-first");
    }

    public Comparator getComparer(XPathContext xPathContext) throws XPathException {
        return this.comparer;
    }
}

